/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
 * This file contains only some constants used anyware in the WebApp
 */

/**
*  Possible layouts in the 'main' area:
*  - BORDERLAYOUT --> only one element in main area and uses the full width and height of main (DEFAULT).
*  - FLOWLAYOUT   --> elements will be shown next to each other, each element has the same width and height.
*  - GRIDLAYOUT   --> elements will be shown in a table. Example:
*                     -- main -------------------------------
*                     | --element-- --element-- --element-- |
*                     | |         | |         | |         | |
*                     | |         | |         | |         | |
*                     | ----------- ----------- ----------- |
*                     | --element-- --element-- --element-- |
*                     | |         | |         | |         | |
*                     | |         | |         | |         | |
*                     | ----------- ----------- ----------- |
*                     ---------------------------------------
*
*  - BOXLAYOUT     --> elements will be shown below each ohter, each elements has the same width and height.
* 
* The left and the right area will have the 'BOXLAYOUT'. This can't be changed, because of
* the small width of each, left and right, area.          
*/
var BORDER_LAYOUT = 0;
var FLOW_LAYOUT = 1;
var GRID_LAYOUT = 2;
var BOX_LAYOUT = 3;

/**
*  Possible ways to insert a new element:
*  - INSERT_ELEMENT_AT_TOP      --> element will be inserted at the top of the area.
*  - INSERT_ELEMENT_AT_BOTTOM   --> element will be inserted at the bottom of the area (DEFAULT).
*  - INSERT_ELEMENT_BETWEEN     --> element will be inserted between the current elements in the area.  
*/
var INSERT_ELEMENT_AT_TOP = 0;
var INSERT_ELEMENT_AT_BOTTOM = 1;
var INSERT_ELEMENT_BETWEEN = 2;

/**
* Delete all elements and modules in an area.
*/ 
var RESET_AREA = true;

/**
* Determines if an appointment can be resized.
*/
var APPOINTMENT_RESIZABLE = true; 
var APPOINTMENT_NOT_RESIZABLE = false;

/**
 * Free/busy status
 */ 
var FB_FREE =  0;
var FB_TENTATIVE = 1;
var FB_BUSY = 2;
var FB_OUTOFOFFICE = 3;


/**
 * Used with Date
 */
var MONTHS = new Array(_("January"), _("February"), _("March"), _("April"), _("May"), _("June"), _("July"), _("August"), _("September"), _("October"), _("November"), _("December"));
var MONTHS_SHORT = new Array(_("Jan"), _("Feb"), _("Mar"), _("Apr"), _("May"), _("Jun"), _("Jul"), _("Aug"), _("Sep"), _("Oct"), _("Nov"), _("Dec"));
var DAYS = new Array(_("Sunday"), _("Monday"), _("Tuesday"), _("Wednesday"), _("Thursday"), _("Friday"), _("Saturday"));
var DAYS_SHORT = new Array(_("Sun"), _("Mon"), _("Tue"), _("Wed"), _("Thu"), _("Fri"), _("Sat"));

// Please note that using ONE_DAY isn't timezone/DST safe! use Date.addDays() for calculations
var ONE_DAY = 86400000;
// Please note that using ONE_HOUR isn't timezone/DST safe! use Date.addHours() for calculations
var ONE_HOUR = 3600000;
var HALF_HOUR = 1800000;

// this string is equivalent with the html tag &nbsp; for use with textNodes
var NBSP = "\u00a0";
// carriage return line feed, for new line character
var CRLF = "\u000D\u000A";

// used with fields/columns to specify a autosize column
var PERCENTAGE = "percentage";



// used for access rights
var ecRightsNone			=		0x00000000;
var ecRightsReadAny			=		0x00000001;
var ecRightsCreate			=		0x00000002;
var ecRightsEditOwned		=		0x00000008;
var ecRightsDeleteOwned		=		0x00000010;
var ecRightsEditAny			=		0x00000020;
var ecRightsDeleteAny		=		0x00000040;
var ecRightsCreateSubfolder	=		0x00000080;
var ecRightsFolderAccess	=		0x00000100;
//var ecRightsContact		=		0x00000200;
var ecRightsFolderVisible	=		0x00000400;

var ecRightsAll				=		0x000005FB;
var ecRightsFullControl		=		0x000004FB;
var ecRightsDefault			=		ecRightsNone | ecRightsFolderVisible;
var ecRightsDefaultPublic	=		ecRightsReadAny | ecRightsFolderVisible;
var ecRightsAdmin			=		0x00001000;
var ecRightsAllMask			=		0x000015FB;

// rights template from provider/ECProps/PropPage.cpp
var ecRightsTemplate = new Object();
ecRightsTemplate[_("Full control")] 	= ecRightsFullControl;
ecRightsTemplate[_("Owner")] 			= ecRightsAll;
ecRightsTemplate[_("Secretary")] 		= (ecRightsFullControl&~ecRightsCreateSubfolder);
ecRightsTemplate[_("Only read")] 		= ecRightsReadAny|ecRightsFolderVisible;
ecRightsTemplate[_("No rights")] 		= ecRightsNone|ecRightsFolderVisible;


// message flags
var MSGFLAG_READ		=	0x00000001;
var MSGFLAG_UNMODIFIED	=	0x00000002;
var MSGFLAG_SUBMIT		=	0x00000004;
var MSGFLAG_UNSENT		=	0x00000008;
var MSGFLAG_HASATTACH	=	0x00000010;
var MSGFLAG_FROMME		=	0x00000020;
var MSGFLAG_ASSOCIATED	=	0x00000040;
var MSGFLAG_RESEND		=	0x00000080;
var MSGFLAG_RN_PENDING	=	0x00000100;
var MSGFLAG_NRN_PENDING	=	0x00000200;

// importance
var IMPORTANCE_LOW		= 0;
var IMPORTANCE_NORMAL	= 1;
var IMPORTANCE_HIGH		= 2;

// sensitivity
var SENSITIVITY_NONE					= 0x00000000;
var SENSITIVITY_PERSONAL				= 0x00000001;
var SENSITIVITY_PRIVATE					= 0x00000002;
var SENSITIVITY_COMPANY_CONFIDENTIAL	= 0x00000003;

// Access
var MAPI_ACCESS_MODIFY				= 0x00000001;
var MAPI_ACCESS_READ				= 0x00000002;
var MAPI_ACCESS_DELETE				= 0x00000004;
var MAPI_ACCESS_CREATE_HIERARCHY	= 0x00000008;
var MAPI_ACCESS_CREATE_CONTENTS		= 0x00000010;
var MAPI_ACCESS_CREATE_ASSOCIATED	= 0x00000020;

// search 
var SEARCH_RUNNING      = 0x00000001;
var SEARCH_REBUILD      = 0x00000002;
var SEARCH_RECURSIVE    = 0x00000004;
var SEARCH_FOREGROUND   = 0x00000008;


// Meeting Request Recipient Type
var MAPI_ORIG	= 0;
var MAPI_TO		= 1;
var MAPI_CC		= 2;
var MAPI_BCC	= 3;

// Recipient flags
var recipSendable				= 1;
var recipOrganizer				= 2;

