/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure;

import br.arca.morcego.Morcego;
import br.arca.morcego.physics.Spring;
import br.arca.morcego.structure.GraphElement;
import br.arca.morcego.structure.Node;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public abstract class Link
extends GraphElement {
    private Spring spring;
    protected Node node1;
    protected Node node2;

    public Link(Node n1, Node n2) {
        this.spring = new Spring(n1.getBody(), n2.getBody());
        this.node1 = n1;
        this.node2 = n2;
    }

    public boolean hasNode(Node node) {
        return this.node1 == node || this.node2 == node;
    }

    public float getDepth() {
        return this.node1.getDepth() + this.node2.getDepth() / 2.0f;
    }

    public boolean contains(MouseEvent e) {
        return false;
    }

    public void paint(Graphics g) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        Morcego.setHandCursor();
    }

    public void mouseExited(MouseEvent e) {
        Morcego.setDefaultCursor();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Spring getSpring() {
        return this.spring;
    }

    public void setProperty(String name, Object value) {
        if (name.equals("springSize")) {
            this.spring.setSize(((Float)value).floatValue());
        }
        if (name.equals("springElasticConstant")) {
            this.spring.setElasticConstant(((Float)value).floatValue());
        }
        super.setProperty(name, value);
    }

    public Node getNode1() {
        return this.node1;
    }

    public Node getNode2() {
        return this.node2;
    }

    public boolean visible() {
        return this.getNode1().visible() && this.getNode2().visible();
    }
}

