/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.GraphModel;
import org.jgraph.pad.GPDocument;
import org.jgraph.pad.GPFileChooser;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GraphModelFileFormat;
import org.jgraph.pad.GraphModelProvider;
import org.jgraph.pad.GraphModelProviderRegistry;
import org.jgraph.pad.actions.AbstractActionFile;
import org.jgraph.pad.resources.Translator;

public class FileOpen
extends AbstractActionFile {
    public FileOpen(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        URL uRL;
        GPFileChooser gPFileChooser = new GPFileChooser(null);
        gPFileChooser.setDialogTitle(Translator.getString("openLabel"));
        int n = gPFileChooser.showOpenDialog(this.graphpad);
        if (n == 1) {
            return;
        }
        try {
            uRL = gPFileChooser.getSelectedFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        if (uRL != null) {
            GPDocument[] gPDocumentArray = this.graphpad.getAllDocuments();
            if (gPDocumentArray != null) {
                int n2 = 0;
                while (n2 < gPDocumentArray.length) {
                    URL uRL2 = gPDocumentArray[n2].getFilename();
                    if (uRL2 != null && uRL.equals(uRL2)) {
                        int n3 = JOptionPane.showConfirmDialog(this.graphpad, Translator.getString("FileAlreadyOpenWarning"), Translator.getString("Title"), 0);
                        if (n3 == 0) {
                            this.graphpad.removeGPInternalFrame(gPDocumentArray[n2].getInternalFrame());
                            this.addDocument(gPFileChooser);
                            return;
                        }
                        return;
                    }
                    ++n2;
                }
            }
        } else {
            return;
        }
        this.addDocument(gPFileChooser);
    }

    protected void addDocument(GPFileChooser gPFileChooser) {
        final File file = gPFileChooser.getSelectedFile();
        final GraphModelProvider graphModelProvider = GraphModelProviderRegistry.getGraphModelProvider(file);
        final GraphModelFileFormat graphModelFileFormat = GraphModelProviderRegistry.getGraphModelFileFormat(file);
        if (graphModelFileFormat == null) {
            JOptionPane.showMessageDialog(this.graphpad, Translator.getString("Error.No_GraphModelFileFormat_available"), Translator.getString("Error"), 0);
            return;
        }
        final Hashtable hashtable = graphModelFileFormat.getReadProperties(gPFileChooser.getAccessory());
        Thread thread = new Thread("Read File Thread"){

            public void run() {
                GPGraph gPGraph = graphModelProvider.createCleanGraph(graphModelProvider.createCleanGraphModel());
                GraphModel graphModel = null;
                try {
                    URL uRL = file.toURL();
                    try {
                        graphModel = graphModelFileFormat.read(uRL, hashtable, gPGraph);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(FileOpen.this.graphpad, exception.getLocalizedMessage(), Translator.getString("Error"), 0);
                        return;
                    }
                    if (graphModel == null) {
                        return;
                    }
                    FileOpen.this.graphpad.addDocument(uRL, graphModelProvider, gPGraph, graphModel, null);
                    FileOpen.this.graphpad.update();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        };
        thread.start();
    }

    public void update() {
    }
}

