/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import br.arca.morcego.Graph;
import br.arca.morcego.Node;
import br.arca.morcego.Renderer;
import br.arca.morcego.SpeedVector;
import java.util.Enumeration;

class Balancer
implements Runnable {
    private boolean balancing = true;
    private boolean balancingLock = false;
    private Graph graph;
    private Renderer renderer;
    private int balancedCount;

    public Balancer(Graph g, Renderer r) {
        this.graph = g;
        this.renderer = r;
        this.balancedCount = 0;
        this.graph.setBalancer(this);
    }

    public void stop() {
        if (!this.balancingLock) {
            this.balancing = false;
        }
    }

    public void lockBalance() {
        this.balancingLock = true;
    }

    public void unlockBalance() {
        this.balancingLock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awake() {
        this.balancing = true;
        this.balancedCount = 0;
        Enumeration e = this.graph.elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            node.awake();
        }
        Balancer balancer = this;
        synchronized (balancer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        try {
            while (true) {
                if (!this.balancing) {
                    Balancer balancer = this;
                    synchronized (balancer) {
                        this.wait();
                    }
                }
                Enumeration e = this.graph.elements();
                while (e.hasMoreElements()) {
                    Node node = (Node)e.nextElement();
                    node.clearSpeed();
                }
                for (int j = 0; j < this.graph.size(); ++j) {
                    Node node1 = (Node)this.graph.elementAt(j);
                    for (int k = j + 1; k < this.graph.size(); ++k) {
                        Node node2 = (Node)this.graph.elementAt(k);
                        SpeedVector sp = node1.getForceFromNode(node2);
                        node1.addSpeed(sp);
                        node2.addSpeed(sp.reverse());
                    }
                }
                Enumeration en = this.graph.elements();
                while (en.hasMoreElements()) {
                    Node node = (Node)en.nextElement();
                    node.balance(this);
                }
                if (this.balancing) {
                    this.balancedCount = 0;
                }
                Renderer renderer = this.renderer;
                synchronized (renderer) {
                    this.renderer.notify();
                }
                Thread.sleep(((Integer)Config.getValue("balancingStepInterval")).intValue());
            }
        }
        catch (InterruptedException e) {
            System.out.println("Balancing interrupted");
            return;
        }
    }

    public void notifyBalanced(Node node) {
        ++this.balancedCount;
        if (this.balancedCount == this.graph.size()) {
            this.stop();
        }
    }
}

