/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.fesi;

import FESI.Data.ArrayPrototype;
import FESI.Data.DatePrototype;
import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpc;

public class FesiRpcUtil {
    public static ESValue convertJ2E(Object what, Evaluator evaluator) throws Exception {
        if (what == null) {
            return ESNull.theNull;
        }
        if (what instanceof Vector) {
            Vector v = (Vector)what;
            ArrayPrototype retval = new ArrayPrototype(evaluator.getArrayPrototype(), evaluator);
            int l = v.size();
            int i = 0;
            while (i < l) {
                retval.putProperty(i, FesiRpcUtil.convertJ2E(v.elementAt(i), evaluator));
                ++i;
            }
            return retval;
        }
        if (what instanceof Hashtable) {
            Hashtable t = (Hashtable)what;
            ObjectPrototype retval = new ObjectPrototype(evaluator.getObjectPrototype(), evaluator);
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                String next = (String)e.nextElement();
                retval.putProperty(next, FesiRpcUtil.convertJ2E(t.get(next), evaluator), next.hashCode());
            }
            return retval;
        }
        if (what instanceof String) {
            return new ESString(what.toString());
        }
        if (what instanceof Number) {
            return new ESNumber(new Double(what.toString()).doubleValue());
        }
        if (what instanceof Boolean) {
            return ESBoolean.makeBoolean((boolean)((Boolean)what));
        }
        if (what instanceof Date) {
            return new DatePrototype(evaluator, (Date)what);
        }
        return ESLoader.normalizeValue((Object)what, (Evaluator)evaluator);
    }

    public static Object convertE2J(ESValue what) throws EcmaScriptException {
        if (XmlRpc.debug) {
            System.out.println("converting e-2-j: " + what.getClass());
        }
        if (what instanceof ESNull) {
            return null;
        }
        if (what instanceof ArrayPrototype) {
            ArrayPrototype a = (ArrayPrototype)what;
            int l = a.size();
            Vector<Object> v = new Vector<Object>();
            int i = 0;
            while (i < l) {
                Object nj = FesiRpcUtil.convertE2J(a.getProperty(i));
                v.addElement(nj);
                ++i;
            }
            return v;
        }
        if (what instanceof ObjectPrototype) {
            ObjectPrototype o = (ObjectPrototype)what;
            Hashtable<String, Object> t = new Hashtable<String, Object>();
            Enumeration e = o.getProperties();
            while (e.hasMoreElements()) {
                Object nj;
                String next = (String)e.nextElement();
                if (XmlRpc.debug) {
                    System.out.println("converting object member " + next);
                }
                if ((nj = FesiRpcUtil.convertE2J(o.getProperty(next, next.hashCode()))) == null) continue;
                t.put(next, nj);
            }
            return t;
        }
        if (what instanceof ESUndefined || what instanceof ESNull) {
            return null;
        }
        Object jval = what.toJavaObject();
        if (jval instanceof Byte || jval instanceof Short) {
            jval = new Integer(jval.toString());
        }
        return jval;
    }
}

