
# Generated from the Telepathy spec
""" Copyright (C) 2005-2008 Collabora Limited 
 Copyright (C) 2005, 2006 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or modify it
      under the terms of the GNU Lesser General Public License as published by
      the Free Software Foundation; either version 2.1 of the License, or (at
      your option) any later version.

    This library is distributed in the hope that it will be useful, but
      WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
      General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
      along with this library; if not, write to the Free Software Foundation,
      Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ConnectionInterfaceContacts(dbus.service.Interface):
    """\
      This interface allows many attributes of many contacts to be
        obtained in a single D-Bus round trip.

      Each contact attribute has an string identifier
        (Contact_Attribute), which is namespaced
        by the D-Bus interface which defines it.

      An initial set of contact attributes is defined here:

      
        org.freedesktop.Telepathy.Connection/contact-id
          (type s)
        The same string that would be returned by
          InspectHandles
          (always present in the result)
        
        org.freedesktop.Telepathy.Connection.Interface.Aliasing/alias
          (type s)
        The same string that would be returned by GetAliases
          (always present with some value, possibly the
          same as Connection/contact-id, if information from the
          Aliasing interface was requested)
        
        org.freedesktop.Telepathy.Connection.Interface.Avatars/token
          (type s, Avatar_Token)
        The same string that would be returned by GetKnownAvatarTokens
          (omitted from the result if the contact's avatar token is not known,
          present as an empty string if the contact is known not to have
          an avatar). Unlike in the GetKnownAvatarTokens
            method, the avatar tokens for the self handle aren't required to be
            present. This attribute should not be used to determine whether or
            not the Avatar needs to be set.
        
        org.freedesktop.Telepathy.Connection.Interface.SimplePresence/presence
          (type (uss), Simple_Presence)
         The same struct that would be returned by
            GetPresences
          (always present with some value if information from the
          SimplePresence interface was requested)
          
        org.freedesktop.Telepathy.Connection.Interface.Capabilities/caps
          (type a(usuu), Contact_Capability)
        The same structs that would be returned by
          GetCapabilities
          (all of them will redundantly have the contact's handle as the
          first member). Omitted from the result if the contact's capabilities
          are not known; present in the result as an empty array if the
          contact is known to have no capabilities at all.

        org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.DRAFT/caps
          (type a{ua(a{sv}as)},
          Contact_Capabilities_Map)
        The same structs that would be returned by
          GetContactCapabilities
          Omitted from the result if the contact's capabilities
          are not known; present in the result as an empty array if the
          contact is known to have no capabilities at all.

        org.freedesktop.Telepathy.Connection.Interface.Location.DRAFT/location
          (type a{sv}, Location)
        The same struct used by
          GetLocations
          Omitted from the result if the contact's location
          is not known.

      
    """

    def __init__(self):
        self._interfaces.add('org.freedesktop.Telepathy.Connection.Interface.Contacts')

    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.Contacts', in_signature='auasb', out_signature='a{ua{sv}}')
    def GetContactAttributes(self, Handles, Interfaces, Hold):
        """
        Return any number of contact attributes for the given handles.
      
        """
        raise NotImplementedError
  