'''OpenGL extension EXT.copy_texture

Overview (from the spec)
	
	This extension defines methods to load texture images directly from the
	framebuffer.  Methods are defined for both complete and partial
	replacement of a texture image.  Because it is not possible to define
	an entire 3D texture using a 2D framebuffer image, 3D textures are
	supported only for partial replacement.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/copy_texture.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_copy_texture'

glCopyTexImage1DEXT = platform.createExtensionFunction( 
	'glCopyTexImage1DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLenum, constants.GLint, constants.GLint, constants.GLsizei, constants.GLint,),
	doc = 'glCopyTexImage1DEXT( GLenum(target), GLint(level), GLenum(internalformat), GLint(x), GLint(y), GLsizei(width), GLint(border) ) -> None',
	argNames = ('target', 'level', 'internalformat', 'x', 'y', 'width', 'border',),
)

glCopyTexImage2DEXT = platform.createExtensionFunction( 
	'glCopyTexImage2DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLenum, constants.GLint, constants.GLint, constants.GLsizei, constants.GLsizei, constants.GLint,),
	doc = 'glCopyTexImage2DEXT( GLenum(target), GLint(level), GLenum(internalformat), GLint(x), GLint(y), GLsizei(width), GLsizei(height), GLint(border) ) -> None',
	argNames = ('target', 'level', 'internalformat', 'x', 'y', 'width', 'height', 'border',),
)

glCopyTexSubImage1DEXT = platform.createExtensionFunction( 
	'glCopyTexSubImage1DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLint, constants.GLint, constants.GLint, constants.GLsizei,),
	doc = 'glCopyTexSubImage1DEXT( GLenum(target), GLint(level), GLint(xoffset), GLint(x), GLint(y), GLsizei(width) ) -> None',
	argNames = ('target', 'level', 'xoffset', 'x', 'y', 'width',),
)

glCopyTexSubImage2DEXT = platform.createExtensionFunction( 
	'glCopyTexSubImage2DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLint, constants.GLint, constants.GLint, constants.GLint, constants.GLsizei, constants.GLsizei,),
	doc = 'glCopyTexSubImage2DEXT( GLenum(target), GLint(level), GLint(xoffset), GLint(yoffset), GLint(x), GLint(y), GLsizei(width), GLsizei(height) ) -> None',
	argNames = ('target', 'level', 'xoffset', 'yoffset', 'x', 'y', 'width', 'height',),
)

glCopyTexSubImage3DEXT = platform.createExtensionFunction( 
	'glCopyTexSubImage3DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLint, constants.GLint, constants.GLint, constants.GLint, constants.GLint, constants.GLsizei, constants.GLsizei,),
	doc = 'glCopyTexSubImage3DEXT( GLenum(target), GLint(level), GLint(xoffset), GLint(yoffset), GLint(zoffset), GLint(x), GLint(y), GLsizei(width), GLsizei(height) ) -> None',
	argNames = ('target', 'level', 'xoffset', 'yoffset', 'zoffset', 'x', 'y', 'width', 'height',),
)


def glInitCopyTextureEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
