# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2007-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.core import media_uri
from elisa.plugins.themoviedb.constants import *

def get_movie_lookup_url(search_term, surround_with_quotes=False):
    """
    A little helper giving the API url call to use to search for a movie
    on themoviedb.org.

    @returns: the search URL that can be used in a get() call of the
              resource_provider.
    @rtype:   L{elisa.core.media_uri.MediaUri}
    """
    if surround_with_quotes:
        # Very quick experimentation showed that surrounding the search term
        # with double quotes sometimes give some results as opposed to searching
        # without quotes. This is by no means confirmed by the themoviedb.org
        # API and should be used with care.
        search_term = '"%s"' % search_term
    quoted_term = media_uri.quote(search_term)
    url = "http://%s/2.0/Movie.search?title=%s&api_key=%s" % (API_SERVER,
                                                              quoted_term,
                                                              API_KEY)
    return media_uri.MediaUri(url)
    
def get_movie_info_url(tmdb_id):
    """
    A little helper giving the API url call to use to lookup a movie
    on themoviedb.org directly by using its TMDB id.

    @param tmdb_id:    the TMDB id of the movie that we want to lookup.
    @type tmdb_id:     L{string}
    @returns: the search URL that can be used in a get() call of the
              resource_provider.
    @rtype:   L{elisa.core.media_uri.MediaUri}
    """
    url = "http://%s/2.0/Movie.getInfo?id=%s&api_key=%s" % (API_SERVER,
                                                            tmdb_id,
                                                            API_KEY) 
    return media_uri.MediaUri(url)
