
from twisted.internet import defer
from twisted.trial.unittest import TestCase
from elisa.plugins.base.tests.resource_providers import GenericSetup, UriRegExpTester

from elisa.core import common
from elisa.core.media_uri import MediaUri

from elisa.plugins.filtered_shares.filtered_shares_resource import FilteredSharesResource

class TestFilteredSharesResource(GenericSetup, UriRegExpTester, TestCase):

    resource_class = FilteredSharesResource

    working_uris = ['network-services:///', 'network-services:///?filter=smb,daap']
    failing_uris = ['network://', 'network_services', 'networkservices:///']

    def setUpClass(self):
       
        class Application(object):pass

        class Manager(object):
            data = {}
            def get(self, uri, model=None):
                result = self.data.get(unicode(uri), None)
                if not result:
                    return None, defer.fail(Exception('Not found'))

                return result, defer.succeed(result)

        self.application = common.application
        self.manager = Manager()
        common.application = Application()
        common.application.resource_manager = self.manager

    def setUp(self):
        class Model(object): pass

        self.manager.data = {}

        coherence = Model()
        coherence.media_servers = []
        for i in xrange(5):
            model = Model()
            model.type = "urn:upnp-org:serviceId:ContentDirectory"
            coherence.media_servers.append(model)

        # this is a none content directory one
        model = Model()
        model.type = 'other stuff'
        coherence.media_servers.append(model)

        self.manager.data['coherence://media_servers'] = coherence

        avahi = Model()
        avahi.services = []
        
        # three daap/ssh/sftp/smb ones:
        for media in ('daap', 'ssh', 'sftp', 'smb'):
            for i in xrange(3):
                model = Model()
                model.type = media
                avahi.services.append(model)

        self.manager.data['lan://'] = avahi

        # and some SMB shares :)

        smb = Model()
        smb.servers = []

        for i in xrange(3):
            server = Model()
            server.type = "smb"
            smb.servers.append(server)

        self.manager.data['smb://'] = smb

        return super(TestFilteredSharesResource, self).setUp()

    def tearDownClass(self):
        common.application = self.application

    def test_get_both_unfiltered(self):
        """
        try to get all informations with an unfiltered system
        """
        uri = MediaUri('network-shares:///')
        model, dfr = self.resource.get(uri, None)

        def check(model):
            self.assertEquals(len(model.services), 17)

        dfr.addCallback(check)
        return dfr

    def test_get_upnp(self):
        """
        try to get all upnp shares
        """
        uri = MediaUri('network-shares:///?filter=upnp')
        model, dfr = self.resource.get(uri, None)

        def check(model):
            self.assertEquals(len(model.services), 5)

        dfr.addCallback(check)
        return dfr

    def test_get_exclude_daap(self):
        """
        try to get all upnp shares and file (exclude daap)
        """
        uri = MediaUri('network-shares:///?filter=upnp,file')
        model, dfr = self.resource.get(uri, None)

        def check(model):
            self.assertEquals(len(model.services), 14)

        dfr.addCallback(check)
        return dfr

    def test_get_only_daap(self):
        """
        try to get all daap
        """
        uri = MediaUri('network-shares:///?filter=audio')
        model, dfr = self.resource.get(uri, None)

        def check(model):
            self.assertEquals(len(model.services), 3)

        dfr.addCallback(check)
        return dfr
