/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: FaceVector.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef FACEVECTOR_H
#define FACEVECTOR_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <iostream>
#include <fstream>
#include "Face.h"
#include "FileReader.h"

namespace Animorph {

/*!
The format of Faces file:
\verbatim
<int>,<int>,<int>{,<int>}
...
\endverbatim
The format of Face colors file:
\verbatim
<int>
...
\endverbatim
*/
class FaceVector : public std::vector <Face>
{
private:
  void fromGeometryStream (std::ifstream &in_stream);
  void fromColorsStream (std::ifstream &in_stream);

public:
  /// load the Face data from a file
  /*!
   * \param filename the file to load
   * \return true if file is found
   * \return false if file isn't found
   */
  bool loadGeometry (const std::string& filename);

  /// load the Face Color data from a file
  /*!
   * \param filename the file to load
   * \return true if file is saved
   * \return false if file isn't saved
   */
  bool loadColors (const std::string& filename);
};

}

#endif	// FACEVECTOR_H
