'''OpenGL extension SGIS.pixel_texture

Overview (from the spec)
	
	The geometry rasterization and pixel pipeline "convert to fragment"
	stages each produce fragments.  The fragments are processed by
	a unified per fragment pipeline that begins with the application
	of the texture to the fragment color.  Because the pixel pipeline
	shares the per fragment processing with the geometry pipeline, the
	fragments produced by the pixel pipeline must have the same fields
	as the ones produced by the geometry pipeline.  When
	pixel groups are being converted to fragments, the parts 
	of the fragment that aren't derived from the pixel groups 
	are taken from the associated values in the current raster position.
	
	A fragment consists of x and y window coordinates and their
	associated color value, depth value, and texture coordinates.
	In the 1.1 OpenGL specification, when the pixel group is RGBA
	the fragment color is always derived from the pixel group, 
	and the depth value and texture coordinates always come 
	from the raster position.
	
	This extension provides a way to specify how the texture coordinates
	of the fragments can be derived from RGBA pixel groups.  When
	this option is enabled, the source of the fragment color value
	when the pixel group is RGBA can be specified to come from either 
	the raster position or the pixel group.
	
	Deriving the fragment texture coordinates from the pixel group
	effectively converts a color image into a texture coordinate image.
	The multidimensional texture mapping lookup logic also makes this
	extension useful for implementing multidimensional color lookups.
	Multidimensional color lookups can be used to implement very
	accurate color space conversions.
	
	Deriving texture coordinates from the pixel groups in the pixel
	pipeline introduces a problem with the lambda parameter in the
	texture mapping equations.  When texture coordinates are
	being taken from the current raster position texture coordinates,
	the texture coordinate values don't change from pixel to pixel,
	and the equation for calculating lambda always produces zero.
	Enabling pixel_texture introduces changes in the texture
	coordinates from pixel to pixel which are not necessarily
	meaningful for texture lookups.  This problem is addressed
	by specifying that lambda is always set to zero when pixel_texture 
	is enabled.  

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIS/pixel_texture.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIS_pixel_texture'
GL_PIXEL_TEXTURE_SGIS = constant.Constant( 'GL_PIXEL_TEXTURE_SGIS', 0x8353 )
GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = constant.Constant( 'GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS', 0x8354 )
GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = constant.Constant( 'GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS', 0x8355 )
GL_PIXEL_GROUP_COLOR_SGIS = constant.Constant( 'GL_PIXEL_GROUP_COLOR_SGIS', 0x8356 )
glPixelTexGenParameteriSGIS = platform.createExtensionFunction( 
	'glPixelTexGenParameteriSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint,),
	doc = 'glPixelTexGenParameteriSGIS( GLenum(pname), GLint(param) ) -> None',
	argNames = ('pname', 'param',),
)

glPixelTexGenParameterivSGIS = platform.createExtensionFunction( 
	'glPixelTexGenParameterivSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLintArray,),
	doc = 'glPixelTexGenParameterivSGIS( GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('pname', 'params',),
)

glPixelTexGenParameterfSGIS = platform.createExtensionFunction( 
	'glPixelTexGenParameterfSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLfloat,),
	doc = 'glPixelTexGenParameterfSGIS( GLenum(pname), GLfloat(param) ) -> None',
	argNames = ('pname', 'param',),
)

glPixelTexGenParameterfvSGIS = platform.createExtensionFunction( 
	'glPixelTexGenParameterfvSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLfloatArray,),
	doc = 'glPixelTexGenParameterfvSGIS( GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('pname', 'params',),
)

glGetPixelTexGenParameterivSGIS = platform.createExtensionFunction( 
	'glGetPixelTexGenParameterivSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLintArray,),
	doc = 'glGetPixelTexGenParameterivSGIS( GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('pname', 'params',),
)

glGetPixelTexGenParameterfvSGIS = platform.createExtensionFunction( 
	'glGetPixelTexGenParameterfvSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLfloatArray,),
	doc = 'glGetPixelTexGenParameterfvSGIS( GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('pname', 'params',),
)


def glInitPixelTextureSGIS():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
