/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AbstractDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ReversePostOrder;
import java.util.BitSet;
import org.apache.bcel.classfile.Method;

public class DominatorsAnalysis
extends AbstractDominatorsAnalysis {
    private DepthFirstSearch dfs;

    public DominatorsAnalysis(CFG cfg, DepthFirstSearch dfs, boolean ignoreExceptionEdges) {
        super(cfg, ignoreExceptionEdges);
        this.dfs = dfs;
    }

    public boolean isForwards() {
        return true;
    }

    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReversePostOrder(cfg, this.dfs);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println("Usage: " + DominatorsAnalysis.class.getName() + " <classfile>");
            System.exit(1);
        }
        DataflowTestDriver<BitSet, DominatorsAnalysis> driver = new DataflowTestDriver<BitSet, DominatorsAnalysis>(){

            @Override
            public Dataflow<BitSet, DominatorsAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                CFG cfg = classContext.getCFG(method);
                DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
                DominatorsAnalysis analysis = new DominatorsAnalysis(cfg, dfs, SystemProperties.getBoolean("dominators.ignoreexceptionedges"));
                Dataflow<BitSet, DominatorsAnalysis> dataflow = new Dataflow<BitSet, DominatorsAnalysis>(cfg, analysis);
                dataflow.execute();
                return dataflow;
            }
        };
        driver.execute(argv[0]);
    }
}

