/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.AbstractFilesCollector;
import de.tobject.findbugs.builder.FilesCollectorFactory;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class FindBugsEditorAction
implements IEditorActionDelegate {
    protected static final ILock findbugsExecuteLock = Platform.getJobManager().newLock();
    private ISelection selection;
    private IEditorPart currentEditor;

    public final void setActiveEditor(IAction action, IEditorPart targetPart) {
        this.currentEditor = targetPart;
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public final void run(IAction action) {
        if (this.currentEditor != null) {
            this.work(((FileEditorInput)this.currentEditor.getEditorInput()).getFile());
        }
    }

    private Collection filesInResource(IResource resource) throws CoreException {
        if (resource instanceof IContainer) {
            AbstractFilesCollector collector = FilesCollectorFactory.getFilesCollector((IContainer)resource);
            return collector.getFiles();
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        result.add(resource);
        if (resource.getFileExtension().equalsIgnoreCase("java")) {
            result.add(resource.getParent().findMember(Util.changeExtension(resource.getName(), "class")));
        } else if (resource.getFileExtension().equalsIgnoreCase("class")) {
            result.add(resource.getParent().findMember(Util.changeExtension(resource.getName(), "java")));
        }
        return result;
    }

    private void work(final IFile theFile) {
        try {
            final Collection files = this.filesInResource((IResource)theFile);
            Job runFindBugs = new Job("Finding bugs in " + theFile.getName() + "..."){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    FindBugsWorker worker = new FindBugsWorker(theFile.getProject(), monitor);
                    try {
                        findbugsExecuteLock.acquire();
                        worker.work(files, true);
                    }
                    catch (CoreException e) {
                        FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Analysis exception");
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        findbugsExecuteLock.release();
                    }
                    return Status.OK_STATUS;
                }
            };
            runFindBugs.setUser(true);
            runFindBugs.schedule();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }
}

