require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SPARC_DB_MACHDEP_H_)) {
    eval 'sub _SPARC_DB_MACHDEP_H_ () {1;}' unless defined(&_SPARC_DB_MACHDEP_H_);
    require 'uvm/uvm_extern.ph';
    require 'machine/frame.ph';
    require 'machine/psl.ph';
    require 'machine/trap.ph';
    require 'machine/reg.ph';
    if(1) {
    } else {
    }
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub DDB_TF () {( ($ddb_regs->{ddb_tf}));}' unless defined(&DDB_TF);
    eval 'sub DDB_FR () {( ($ddb_regs->{ddb_fr}));}' unless defined(&DDB_FR);
    eval 'sub DDB_FP () {( ($ddb_regs->{ddb_fpstate}));}' unless defined(&DDB_FP);
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> ($ddb_tf->{tf_pc})));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q(($regs)-> ($ddb_tf->{tf_pc}) = ( &int32_t)($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub PC_ADVANCE {
        my($regs) = @_;
	    eval q( &do {  &vaddr_t  &n = ($regs)-> ($ddb_tf->{tf_npc}); ($regs)-> ($ddb_tf->{tf_pc}) =  &n; ($regs)-> ($ddb_tf->{tf_npc}) =  &n + 4; }  &while(0));
    }' unless defined(&PC_ADVANCE);
    eval 'sub BKPT_INST () {0x91d02001;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(4);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_BREAKPOINT || ($type) ==  &T_KGDB_EXEC));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) == &T_PA_WATCHPT || ($type) ==  &T_VA_WATCHPT));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub SOFTWARE_SSTEP () {1;}' unless defined(&SOFTWARE_SSTEP);
    eval 'sub inst_trap_return {
        my($ins) = @_;
	    eval q( &db_inst_trap_return($ins));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        my($ins) = @_;
	    eval q( &db_inst_return($ins));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        my($ins) = @_;
	    eval q( &db_inst_call($ins));
    }' unless defined(&inst_call);
    eval 'sub inst_branch {
        my($ins) = @_;
	    eval q( &db_inst_branch($ins));
    }' unless defined(&inst_branch);
    eval 'sub inst_load {
        my($ins) = @_;
	    eval q( &db_inst_load($ins));
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        my($ins) = @_;
	    eval q( &db_inst_store($ins));
    }' unless defined(&inst_store);
    eval 'sub inst_unconditional_flow_transfer {
        my($ins) = @_;
	    eval q( &db_inst_unconditional_flow_transfer($ins));
    }' unless defined(&inst_unconditional_flow_transfer);
    eval 'sub branch_taken {
        my($ins, $pc, $fun, $regs) = @_;
	    eval q( &db_branch_taken(($ins), ($pc), ($regs)));
    }' unless defined(&branch_taken);
    eval 'sub next_instr_address {
        my($pc, $bd) = @_;
	    eval q((($bd) ? ($pc) :  ($ddb_regs->{ddb_tf}->{tf_npc})));
    }' unless defined(&next_instr_address);
    eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    eval 'sub DB_ELF_SYMBOLS () {1;}' unless defined(&DB_ELF_SYMBOLS);
    eval 'sub DB_ELFSIZE () {64;}' unless defined(&DB_ELFSIZE);
}
1;
