Gem::Specification.new do |s|
  s.name = %q{haml}
  s.version = "1.8.2"

  s.specification_version = 1 if s.respond_to? :specification_version=

  s.required_rubygems_version = nil if s.respond_to? :required_rubygems_version=
  s.authors = ["Hampton Catlin"]
  s.autorequire = ["haml", "sass"]
  s.cert_chain = nil
  s.date = %q{2008-02-24}
  s.description = %q{Haml (HTML Abstraction Markup Language) is a layer on top of XHTML or XML that's designed to express the structure of XHTML or XML documents in a non-repetitive, elegant, easy way, using indentation rather than closing tags and allowing Ruby to be embedded with ease. It was originally envisioned as a plugin for Ruby on Rails, but it can function as a stand-alone templating engine.}
  s.email = %q{haml@googlegroups.com}
  s.executables = ["haml", "html2haml", "sass", "css2sass"]
  s.extra_rdoc_files = ["VERSION", "MIT-LICENSE", "README"]
  s.files = ["lib/sass.rb", "lib/sass", "lib/sass/plugin", "lib/sass/plugin/rails.rb", "lib/sass/plugin/merb.rb", "lib/sass/error.rb", "lib/sass/tree", "lib/sass/tree/value_node.rb", "lib/sass/tree/attr_node.rb", "lib/sass/tree/directive_node.rb", "lib/sass/tree/node.rb", "lib/sass/tree/comment_node.rb", "lib/sass/tree/rule_node.rb", "lib/sass/constant.rb", "lib/sass/constant", "lib/sass/constant/color.rb", "lib/sass/constant/string.rb", "lib/sass/constant/number.rb", "lib/sass/constant/operation.rb", "lib/sass/constant/literal.rb", "lib/sass/plugin.rb", "lib/sass/css.rb", "lib/sass/engine.rb", "lib/haml", "lib/haml/util.rb", "lib/haml/exec.rb", "lib/haml/html.rb", "lib/haml/error.rb", "lib/haml/buffer.rb", "lib/haml/template.rb", "lib/haml/template", "lib/haml/template/plugin.rb", "lib/haml/template/patch.rb", "lib/haml/helpers.rb", "lib/haml/filters.rb", "lib/haml/engine.rb", "lib/haml/precompiler.rb", "lib/haml/helpers", "lib/haml/helpers/action_view_extensions.rb", "lib/haml/helpers/action_view_mods.rb", "lib/haml.rb", "bin/css2sass", "bin/sass", "bin/haml", "bin/html2haml", "test/sass", "test/sass/templates", "test/sass/templates/bork2.sass", "test/sass/templates/compressed.sass", "test/sass/templates/expanded.sass", "test/sass/templates/import.sass", "test/sass/templates/subdir", "test/sass/templates/subdir/subdir.sass", "test/sass/templates/subdir/nested_subdir", "test/sass/templates/subdir/nested_subdir/nested_subdir.sass", "test/sass/templates/basic.sass", "test/sass/templates/_partial.sass", "test/sass/templates/nested.sass", "test/sass/templates/compact.sass", "test/sass/templates/alt.sass", "test/sass/templates/constants.sass", "test/sass/templates/importee.sass", "test/sass/templates/parent_ref.sass", "test/sass/templates/bork.sass", "test/sass/templates/complex.sass", "test/sass/plugin_test.rb", "test/sass/results", "test/sass/results/nested.css", "test/sass/results/subdir", "test/sass/results/subdir/nested_subdir", "test/sass/results/subdir/nested_subdir/nested_subdir.css", "test/sass/results/subdir/subdir.css", "test/sass/results/import.css", "test/sass/results/compact.css", "test/sass/results/expanded.css", "test/sass/results/alt.css", "test/sass/results/complex.css", "test/sass/results/constants.css", "test/sass/results/compressed.css", "test/sass/results/parent_ref.css", "test/sass/results/basic.css", "test/sass/engine_test.rb", "test/haml", "test/haml/mocks", "test/haml/mocks/article.rb", "test/haml/template_test.rb", "test/haml/html2haml_test.rb", "test/haml/rhtml", "test/haml/rhtml/_av_partial_1.rhtml", "test/haml/rhtml/standard.rhtml", "test/haml/rhtml/action_view.rhtml", "test/haml/rhtml/_av_partial_2.rhtml", "test/haml/helper_test.rb", "test/haml/templates", "test/haml/templates/list.haml", "test/haml/templates/_text_area.haml", "test/haml/templates/_partial.haml", "test/haml/templates/_av_partial_2.haml", "test/haml/templates/helpful.haml", "test/haml/templates/just_stuff.haml", "test/haml/templates/silent_script.haml", "test/haml/templates/very_basic.haml", "test/haml/templates/eval_suppressed.haml", "test/haml/templates/tag_parsing.haml", "test/haml/templates/whitespace_handling.haml", "test/haml/templates/partials.haml", "test/haml/templates/standard.haml", "test/haml/templates/partialize.haml", "test/haml/templates/_av_partial_1.haml", "test/haml/templates/filters.haml", "test/haml/templates/content_for_layout.haml", "test/haml/templates/helpers.haml", "test/haml/templates/original_engine.haml", "test/haml/templates/breakage.haml", "test/haml/templates/action_view.haml", "test/haml/runner.rb", "test/haml/results", "test/haml/results/content_for_layout.xhtml", "test/haml/results/just_stuff.xhtml", "test/haml/results/whitespace_handling.xhtml", "test/haml/results/silent_script.xhtml", "test/haml/results/filters.xhtml", "test/haml/results/standard.xhtml", "test/haml/results/helpful.xhtml", "test/haml/results/very_basic.xhtml", "test/haml/results/eval_suppressed.xhtml", "test/haml/results/partials.xhtml", "test/haml/results/original_engine.xhtml", "test/haml/results/helpers.xhtml", "test/haml/results/list.xhtml", "test/haml/results/tag_parsing.xhtml", "test/haml/markaby", "test/haml/markaby/standard.mab", "test/haml/engine_test.rb", "test/profile.rb", "test/benchmark.rb", "Rakefile", "init.rb", "VERSION", "MIT-LICENSE", "README"]
  s.has_rdoc = true
  s.homepage = %q{http://haml.hamptoncatlin.com/}
  s.rdoc_options = ["--title", "Haml", "--main", "README", "--exclude", "lib/haml/buffer.rb", "--line-numbers", "--inline-source"]
  s.require_paths = ["lib"]
  s.required_ruby_version = Gem::Requirement.new("> 0.0.0")
  s.rubygems_version = %q{1.1.1}
  s.summary = %q{An elegant, structured XHTML/XML templating engine. Comes with Sass, a similar CSS templating engine.}
  s.test_files = ["test/sass/plugin_test.rb", "test/sass/engine_test.rb", "test/haml/template_test.rb", "test/haml/html2haml_test.rb", "test/haml/helper_test.rb", "test/haml/engine_test.rb"]
end
