/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.AuTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;

public class AuAudioOutputStream
extends TAudioOutputStream {
    private static String description = "Created by Tritonus";

    protected static void writeText(TDataOutputStream tDataOutputStream, String string) throws IOException {
        if (string.length() > 0) {
            tDataOutputStream.writeBytes(string);
            tDataOutputStream.writeByte(0);
            if (string.length() % 2 == 0) {
                tDataOutputStream.writeByte(0);
            }
        }
    }

    protected static int getTextLength(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return string.length() + 2 & 0xFFFFFFFE;
    }

    protected void writeHeader() throws IOException {
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("AuAudioOutputStream.writeHeader(): called.");
        }
        AudioFormat audioFormat = this.getFormat();
        long l = this.getLength();
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("AuAudioOutputStream.writeHeader(): AudioFormat: " + audioFormat);
            TDebug.out("AuAudioOutputStream.writeHeader(): length: " + l);
        }
        tDataOutputStream.writeInt(779316836);
        tDataOutputStream.writeInt(24 + AuAudioOutputStream.getTextLength(description));
        tDataOutputStream.writeInt(l != (long)-1 ? (int)l : -1);
        tDataOutputStream.writeInt(AuTool.getFormatCode(audioFormat));
        tDataOutputStream.writeInt((int)audioFormat.getSampleRate());
        tDataOutputStream.writeInt(audioFormat.getChannels());
        AuAudioOutputStream.writeText(tDataOutputStream, description);
    }

    protected void patchHeader() throws IOException {
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        tDataOutputStream.seek(0L);
        this.setLengthFromCalculatedLength();
        this.writeHeader();
    }

    public AuAudioOutputStream(AudioFormat audioFormat, long l, TDataOutputStream tDataOutputStream) {
        long l2 = l > Integer.MAX_VALUE ? (long)-1 : l;
        boolean bl = false;
        if (l == (long)-1 && tDataOutputStream.supportsSeek()) {
            bl = true;
        }
        super(audioFormat, l2, tDataOutputStream, bl);
    }
}

