/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class URLClassLoader
extends SecureClassLoader {
    private static HashMap urlloaders = new HashMap();
    private static HashMap factoryCache = new HashMap(5);
    private final Vector urls;
    private final Vector urlinfos;
    private final URLStreamHandlerFactory factory;
    private final AccessControlContext securityContext;
    private String thisString;

    protected void addURL(URL uRL) {
        this.urls.add(uRL);
        this.addURLImpl(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addURLImpl(URL uRL) {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            URL uRL2;
            Object object;
            Object object2;
            Object object3;
            if (uRL == null) {
                return;
            }
            this.thisString = null;
            URLLoader uRLLoader = (URLLoader)urlloaders.get(uRL);
            if (uRLLoader == null) {
                object3 = uRL.getFile();
                object2 = uRL.getProtocol();
                if ("file".equals(object2)) {
                    object = new File((String)object3);
                    try {
                        uRL2 = ((File)object).getCanonicalFile().toURL();
                    }
                    catch (IOException iOException) {
                        try {
                            uRL2 = ((File)object).getAbsoluteFile().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL2 = uRL;
                        }
                    }
                } else {
                    uRL2 = uRL;
                }
                uRLLoader = !((String)object3).endsWith("/") && !((String)object3).endsWith(File.separator) ? new JarURLLoader(this, uRL, uRL2) : ("file".equals(object2) ? new FileURLLoader(this, uRL, uRL2) : new RemoteURLLoader(this, uRL));
                urlloaders.put(uRL, uRLLoader);
            }
            this.urlinfos.add(uRLLoader);
            object3 = uRLLoader.getClassPath();
            if (object3 != null) {
                object2 = ((AbstractList)object3).iterator();
                while (object2.hasNext()) {
                    uRL2 = (URL)object2.next();
                    object = (URLLoader)urlloaders.get(uRL2);
                    if (this.urlinfos.contains(object)) continue;
                    this.addURLImpl(uRL2);
                }
            }
            return;
        }
    }

    private final void addURLs(URL[] uRLArray) {
        int n = 0;
        while (n < uRLArray.length) {
            this.urls.add(uRLArray[n]);
            this.addURLImpl(uRLArray[n]);
            ++n;
        }
    }

    private final String getAttributeValue(Attributes.Name name, Attributes attributes, Attributes attributes2) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        }
        if (string == null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            if (stringBuffer.charAt(n) == '.') {
                stringBuffer.setCharAt(n, '/');
            }
            --n;
        }
        stringBuffer.append('/');
        String string2 = stringBuffer.toString();
        Attributes attributes = manifest.getAttributes(string2);
        Attributes attributes2 = manifest.getMainAttributes();
        String string3 = this.getAttributeValue(Attributes.Name.SPECIFICATION_TITLE, attributes, attributes2);
        String string4 = this.getAttributeValue(Attributes.Name.SPECIFICATION_VERSION, attributes, attributes2);
        String string5 = this.getAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, attributes, attributes2);
        String string6 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_TITLE, attributes, attributes2);
        String string7 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, attributes, attributes2);
        String string8 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VENDOR, attributes, attributes2);
        String string9 = attributes2.getValue(Attributes.Name.SEALED);
        if ("false".equals(string9)) {
            uRL = null;
        }
        return this.definePackage(string, string3, string5, string4, string6, string8, string7, uRL);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findClass(final String var1_1) throws ClassNotFoundException {
        var2_2 = var1_1.replace('.', '/') + ".class";
        var3_3 = this.findURLResource(var2_2);
        if (var3_3 == null) {
            throw new ClassNotFoundException(var1_1 + " not found in " + this);
        }
        try {
            var5_4 = var3_3.getInputStream();
            try {
                block14: {
                    var9_6 = var3_3.getLength();
                    if (var9_6 == -1) break block14;
                    var4_8 = new byte[var9_6];
                    var10_10 = 0;
                    while (var9_6 - var10_10 > 0) {
                        var11_13 = var5_4.read(var4_8, var10_10, var9_6 - var10_10);
                        if (var11_13 == -1) {
                            throw new EOFException("Not enough data reading from: " + var5_4);
                        }
                        var10_10 += var11_13;
                    }
                    ** GOTO lbl-1000
                }
                var10_11 = new ByteArrayOutputStream(4096);
                var11_14 = new byte[4096];
                var12_16 = 0;
                while (true) {
                    block15: {
                        if (var12_16 != -1) break block15;
                        var4_8 = var10_11.toByteArray();
                        break;
                    }
                    var12_16 = var5_4.read(var11_14);
                    if (var12_16 == -1) continue;
                    var10_11.write(var11_14, 0, var12_16);
                }
            }
            catch (Throwable var6_17) {
                var7_18 = null;
                var5_4.close();
                throw var6_17;
            }
lbl-1000:
            // 2 sources

            {
                var7_19 = null;
            }
            var5_4.close();
            var9_7 = var4_8;
            var10_12 = var3_3.getCodeSource();
            var11_15 = null;
            var12_16 = var1_1.lastIndexOf(46);
            if (var12_16 != -1) {
                var11_15 = var1_1.substring(0, var12_16);
            }
            if (var11_15 != null && this.getPackage(var11_15) == null) {
                var13_20 = var3_3.loader.getManifest();
                if (var13_20 == null) {
                    this.definePackage(var11_15, null, null, null, null, null, null, null);
                } else {
                    this.definePackage(var11_15, (Manifest)var13_20, var3_3.loader.baseURL);
                }
            }
            var13_20 = System.getSecurityManager();
            var14_21 = null;
            var14_21 = var13_20 != null && this.securityContext != null ? (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return URLClassLoader.this.defineClass(var1_1, var9_7, 0, var9_7.length, var10_12);
                }
            }, this.securityContext) : this.defineClass(var1_1, var9_7, 0, var9_7.length, var10_12);
            var15_22 = var3_3.getCertificates();
            if (var15_22 != null) {
                super.setSigners(var14_21, var15_22);
            }
            return var14_21;
        }
        catch (IOException var4_9) {
            var5_5 = new ClassNotFoundException(var1_1 + " not found in " + this);
            var5_5.initCause(var4_9);
            throw var5_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            block6: {
                if (this.thisString != null) break block6;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getClass().getName());
                stringBuffer.append("{urls=[");
                URL[] uRLArray = this.getURLs();
                int n = 0;
                while (true) {
                    if (n >= uRLArray.length) {
                        stringBuffer.append(']');
                        stringBuffer.append(", parent=");
                        stringBuffer.append(this.getParent());
                        stringBuffer.append('}');
                        this.thisString = stringBuffer.toString();
                        break;
                    }
                    stringBuffer.append(uRLArray[n]);
                    if (n < uRLArray.length - 1) {
                        stringBuffer.append(',');
                    }
                    ++n;
                }
            }
            return this.thisString;
        }
    }

    private final Resource findURLResource(String string) {
        int n = this.urlinfos.size();
        int n2 = 0;
        while (n2 < n) {
            Resource resource;
            URLLoader uRLLoader = (URLLoader)this.urlinfos.elementAt(n2);
            if (uRLLoader != null && (resource = uRLLoader.getResource(string)) != null) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    public URL findResource(String string) {
        Resource resource = this.findURLResource(string);
        if (resource != null) {
            return resource.getURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    URLStreamHandler getURLStreamHandler(String string) {
        if (this.factory == null) {
            return null;
        }
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)factoryCache.get(this.factory);
            URLStreamHandler uRLStreamHandler = (URLStreamHandler)hashMap2.get(string);
            if (uRLStreamHandler == null) {
                uRLStreamHandler = this.factory.createURLStreamHandler(string);
                hashMap2.put(string, uRLStreamHandler);
            }
            return uRLStreamHandler;
        }
    }

    public Enumeration findResources(String string) throws IOException {
        Vector vector = new Vector();
        int n = this.urlinfos.size();
        int n2 = 0;
        while (n2 < n) {
            URLLoader uRLLoader = (URLLoader)this.urlinfos.elementAt(n2);
            Resource resource = uRLLoader.getResource(string);
            if (resource != null) {
                vector.add(resource.getURL());
            }
            ++n2;
        }
        return vector.elements();
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            String string2 = uRL.getFile();
            if (string2.endsWith("/") || string2.endsWith(File.separator)) {
                permissionCollection.add(new FilePermission(string2 + '-', "read"));
            } else {
                permissionCollection.add(new FilePermission(string2, "read"));
            }
        } else {
            String string3 = uRL.getHost();
            if (string3 != null) {
                permissionCollection.add(new SocketPermission(string3, "connect,accept"));
            }
        }
        return permissionCollection;
    }

    public URL[] getURLs() {
        return (URL[])this.urls.toArray(new URL[this.urls.size()]);
    }

    public static URLClassLoader newInstance(URL[] uRLArray) throws SecurityException {
        return URLClassLoader.newInstance(uRLArray, null);
    }

    public static URLClassLoader newInstance(URL[] uRLArray, final ClassLoader classLoader) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return new URLClassLoader(uRLArray, classLoader);
        }
        final Object object = securityManager.getSecurityContext();
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException("securityContext must be AccessControlContext: " + object);
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return new URLClassLoader(classLoader, (AccessControlContext)object);
            }
        });
        uRLClassLoader.addURLs(uRLArray);
        return uRLClassLoader;
    }

    private final /* synthetic */ void this() {
        this.urls = new Vector();
        this.urlinfos = new Vector();
    }

    public URLClassLoader(URL[] uRLArray) throws SecurityException {
        this.this();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(uRLArray);
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) throws SecurityException {
        super(classLoader);
        this.this();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(uRLArray);
    }

    URLClassLoader(ClassLoader classLoader, AccessControlContext accessControlContext) {
        super(classLoader);
        this.this();
        this.factory = null;
        this.securityContext = accessControlContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws SecurityException {
        super(classLoader);
        this.this();
        this.securityContext = null;
        this.factory = uRLStreamHandlerFactory;
        this.addURLs(uRLArray);
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            if (uRLStreamHandlerFactory != null && factoryCache.get(uRLStreamHandlerFactory) == null) {
                factoryCache.put(uRLStreamHandlerFactory, new HashMap(5));
            }
            return;
        }
    }

    static abstract class URLLoader {
        final URLClassLoader classloader;
        final URL baseURL;
        final CodeSource noCertCodeSource;

        abstract Resource getResource(String var1);

        Manifest getManifest() {
            return null;
        }

        Vector getClassPath() {
            return null;
        }

        URLLoader(URLClassLoader uRLClassLoader, URL uRL) {
            this(uRLClassLoader, uRL, uRL);
        }

        URLLoader(URLClassLoader uRLClassLoader, URL uRL, URL uRL2) {
            this.classloader = uRLClassLoader;
            this.baseURL = uRL;
            this.noCertCodeSource = new CodeSource(uRL2, null);
        }
    }

    static final class JarURLLoader
    extends URLLoader {
        final JarFile jarfile;
        final URL baseJarURL;
        Vector classPath;

        final Resource getResource(String string) {
            JarEntry jarEntry;
            if (this.jarfile == null) {
                return null;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if ((jarEntry = this.jarfile.getJarEntry(string)) != null) {
                return new JarURLResource(this, string, jarEntry);
            }
            return null;
        }

        final Manifest getManifest() {
            try {
                return this.jarfile == null ? null : this.jarfile.getManifest();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        final Vector getClassPath() {
            return this.classPath;
        }

        public JarURLLoader(URLClassLoader uRLClassLoader, URL uRL, URL uRL2) {
            super(uRLClassLoader, uRL, uRL2);
            String string = uRL.toExternalForm();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 6);
            stringBuffer.append("jar:");
            stringBuffer.append(string);
            stringBuffer.append("!/");
            String string2 = stringBuffer.toString();
            this.classPath = null;
            URL uRL3 = null;
            JarFile jarFile = null;
            try {
                String string3;
                Attributes attributes;
                uRL3 = new URL(null, string2, uRLClassLoader.getURLStreamHandler("jar"));
                jarFile = ((JarURLConnection)uRL3.openConnection()).getJarFile();
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string3 = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    this.classPath = new Vector();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                    while (stringTokenizer.hasMoreElements()) {
                        String string4 = stringTokenizer.nextToken();
                        try {
                            URL uRL4 = new URL(uRL, string4);
                            this.classPath.add(uRL4);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
            catch (IOException iOException) {}
            this.baseJarURL = uRL3;
            this.jarfile = jarFile;
        }
    }

    static final class FileURLLoader
    extends URLLoader {
        File dir;

        final Resource getResource(String string) {
            try {
                File file = new File(this.dir, string).getCanonicalFile();
                if (file.exists()) {
                    return new FileResource(this, file);
                }
            }
            catch (IOException iOException) {}
            return null;
        }

        FileURLLoader(URLClassLoader uRLClassLoader, URL uRL, URL uRL2) {
            super(uRLClassLoader, uRL, uRL2);
            this.dir = new File(uRL2.getFile());
        }
    }

    static final class RemoteURLLoader
    extends URLLoader {
        private final String protocol;

        final Resource getResource(String string) {
            try {
                int n;
                URL uRL = new URL(this.baseURL, string, this.classloader.getURLStreamHandler(this.protocol));
                URLConnection uRLConnection = uRL.openConnection();
                int n2 = uRLConnection.getContentLength();
                InputStream inputStream = uRLConnection.getInputStream();
                if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)uRLConnection).getResponseCode()) / 100 != 2) {
                    return null;
                }
                if (inputStream != null) {
                    return new RemoteResource(this, string, uRL, inputStream, n2);
                }
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        RemoteURLLoader(URLClassLoader uRLClassLoader, URL uRL) {
            super(uRLClassLoader, uRL);
            this.protocol = uRL.getProtocol();
        }
    }

    static abstract class Resource {
        final URLLoader loader;

        CodeSource getCodeSource() {
            Certificate[] certificateArray = this.getCertificates();
            if (certificateArray == null) {
                return this.loader.noCertCodeSource;
            }
            return new CodeSource(this.loader.baseURL, certificateArray);
        }

        Certificate[] getCertificates() {
            return null;
        }

        abstract URL getURL();

        abstract int getLength();

        abstract InputStream getInputStream() throws IOException;

        Resource(URLLoader uRLLoader) {
            this.loader = uRLLoader;
        }
    }

    static final class FileResource
    extends Resource {
        final File file;

        final InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public final int getLength() {
            return (int)this.file.length();
        }

        public final URL getURL() {
            try {
                return this.file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                InternalError internalError = new InternalError();
                internalError.initCause(malformedURLException);
                throw internalError;
            }
        }

        FileResource(FileURLLoader fileURLLoader, File file) {
            super(fileURLLoader);
            this.file = file;
        }
    }

    static final class RemoteResource
    extends Resource {
        private final URL url;
        private final InputStream stream;
        private final int length;

        final InputStream getInputStream() throws IOException {
            return this.stream;
        }

        public final int getLength() {
            return this.length;
        }

        public final URL getURL() {
            return this.url;
        }

        RemoteResource(RemoteURLLoader remoteURLLoader, String string, URL uRL, InputStream inputStream, int n) {
            super(remoteURLLoader);
            this.url = uRL;
            this.stream = inputStream;
            this.length = n;
        }
    }

    static final class JarURLResource
    extends Resource {
        private final JarEntry entry;
        private final String name;

        final InputStream getInputStream() throws IOException {
            return ((JarURLLoader)this.loader).jarfile.getInputStream(this.entry);
        }

        final int getLength() {
            return (int)this.entry.getSize();
        }

        final Certificate[] getCertificates() {
            return ((JarEntry)((JarURLLoader)this.loader).jarfile.getEntry(this.name)).getCertificates();
        }

        final URL getURL() {
            try {
                return new URL(((JarURLLoader)this.loader).baseJarURL, this.name, this.loader.classloader.getURLStreamHandler("jar"));
            }
            catch (MalformedURLException malformedURLException) {
                InternalError internalError = new InternalError();
                internalError.initCause(malformedURLException);
                throw internalError;
            }
        }

        JarURLResource(JarURLLoader jarURLLoader, String string, JarEntry jarEntry) {
            super(jarURLLoader);
            this.entry = jarEntry;
            this.name = string;
        }
    }
}

