/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.io.VMObjectInputStream;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static boolean dump;
    private static final boolean DEBUG = false;
    private DataInputStream realInputStream;
    private DataInputStream dataInputStream;
    private DataInputStream blockDataInput;
    private int blockDataPosition;
    private int blockDataBytes;
    private byte[] blockData;
    private boolean useSubclassMethod;
    private int nextOID;
    private boolean resolveEnabled;
    private Hashtable objectLookupTable;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private TreeSet currentObjectValidators;
    private boolean readDataFromBlock;
    private boolean fieldsAlreadyRead;
    private Hashtable classLookupTable;
    private GetField prereadFields;
    private int depth;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object readObject() throws ClassNotFoundException, IOException {
        Object object;
        if (this.useSubclassMethod) {
            return this.readObjectOverride();
        }
        boolean bl = this.setBlockDataMode(false);
        byte by = this.realInputStream.readByte();
        if (dump) {
            this.dumpElement("MARKER: 0x" + Integer.toHexString(by) + ' ');
        }
        try {
            object = this.parseContent(by);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setBlockDataMode(bl);
            throw throwable;
        }
        {
            Object var5_6 = null;
            this.setBlockDataMode(bl);
        }
        return object;
    }

    private final Object parseContent(byte by) throws ClassNotFoundException, IOException {
        Object object;
        boolean bl = false;
        switch (by) {
            case 120: {
                object = null;
                bl = true;
                break;
            }
            case 119: 
            case 122: {
                if (by == 122) {
                    if (dump) {
                        this.dumpElementln("BLOCKDATALONG");
                    }
                } else if (dump) {
                    this.dumpElementln("BLOCKDATA");
                }
                this.readNextBlock(by);
            }
            case 112: {
                if (dump) {
                    this.dumpElementln("NULL");
                }
                object = null;
                break;
            }
            case 113: {
                if (dump) {
                    this.dumpElement("REFERENCE ");
                }
                Integer n = new Integer(this.realInputStream.readInt());
                if (dump) {
                    this.dumpElementln(Integer.toHexString(n));
                }
                object = ((ObjectIdentityWrapper)this.objectLookupTable.get((Object)n)).object;
                break;
            }
            case 118: {
                if (dump) {
                    this.dumpElementln("CLASS");
                }
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class clazz = objectStreamClass.forClass();
                this.assignNewHandle(clazz);
                object = clazz;
                break;
            }
            case 125: {
                if (dump) {
                    this.dumpElementln("PROXYCLASS");
                }
                boolean bl2 = this.realInputStream.readInt();
                String[] stringArray = new String[bl2];
                boolean bl3 = false;
                while (bl3 < bl2) {
                    stringArray[bl3] = this.realInputStream.readUTF();
                    bl3 += 1;
                }
                bl3 = this.setBlockDataMode(true);
                Class clazz = this.resolveProxyClass(stringArray);
                this.setBlockDataMode(bl3);
                ObjectStreamClass objectStreamClass = this.lookupClass(clazz);
                if (objectStreamClass.firstNonSerializableParentConstructor == null) {
                    objectStreamClass.realClassIsSerializable = true;
                    objectStreamClass.fieldMapping = new ObjectStreamField[0];
                    objectStreamClass.fields = objectStreamClass.fieldMapping;
                    try {
                        Class clazz2 = class$java$lang$Object;
                        if (clazz2 == null) {
                            clazz2 = class$java$lang$Object = ObjectInputStream.class("[Ljava.lang.Object;", false);
                        }
                        objectStreamClass.firstNonSerializableParentConstructor = clazz2.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw (InternalError)new InternalError("Object ctor missing").initCause(noSuchMethodException);
                    }
                }
                this.assignNewHandle(objectStreamClass);
                if (!bl) {
                    byte by2 = this.realInputStream.readByte();
                    if (by2 != 120) {
                        throw new IOException("Data annotated to class was not consumed." + by2);
                    }
                } else {
                    bl = false;
                }
                ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
                objectStreamClass.setSuperclass(objectStreamClass2);
                object = objectStreamClass;
                break;
            }
            case 114: {
                ObjectStreamClass objectStreamClass = this.readClassDescriptor();
                if (!bl) {
                    byte by3 = this.realInputStream.readByte();
                    if (by3 != 120) {
                        throw new IOException("Data annotated to class was not consumed." + by3);
                    }
                } else {
                    bl = false;
                }
                objectStreamClass.setSuperclass((ObjectStreamClass)this.readObject());
                object = objectStreamClass;
                break;
            }
            case 116: 
            case 124: {
                if (dump) {
                    this.dumpElement("STRING=");
                }
                String string = this.realInputStream.readUTF();
                if (dump) {
                    this.dumpElementln(string);
                }
                object = this.processResolution(null, string, this.assignNewHandle(string));
                break;
            }
            case 117: {
                if (dump) {
                    this.dumpElementln("ARRAY");
                }
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class clazz = objectStreamClass.forClass().getComponentType();
                if (dump) {
                    this.dumpElement("ARRAY LENGTH=");
                }
                int n = this.realInputStream.readInt();
                if (dump) {
                    this.dumpElementln(n + "; COMPONENT TYPE=" + clazz);
                }
                Object object2 = Array.newInstance(clazz, n);
                int n2 = this.assignNewHandle(object2);
                this.readArrayElements(object2, clazz);
                if (dump) {
                    int n3 = 0;
                    int n4 = Array.getLength(object2);
                    while (n3 < n4) {
                        this.dumpElementln("  ELEMENT[" + n3 + "]=" + Array.get(object2, n3));
                        ++n3;
                    }
                }
                object = this.processResolution(null, object2, n2);
                break;
            }
            case 115: {
                if (dump) {
                    this.dumpElementln("OBJECT");
                }
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class clazz = objectStreamClass.forClass();
                if (!objectStreamClass.realClassIsSerializable) {
                    throw new NotSerializableException(clazz + " is not Serializable, and thus cannot be deserialized.");
                }
                if (objectStreamClass.realClassIsExternalizable) {
                    Externalizable externalizable = objectStreamClass.newInstance();
                    int n = this.assignNewHandle(externalizable);
                    boolean bl2 = false;
                    if ((objectStreamClass.getFlags() & 8) != 0) {
                        bl2 = true;
                    }
                    boolean bl5 = bl2;
                    boolean bl6 = this.readDataFromBlock;
                    if (bl5) {
                        this.setBlockDataMode(true);
                    }
                    externalizable.readExternal(this);
                    if (bl5) {
                        this.setBlockDataMode(bl6);
                        if (!bl6 && this.realInputStream.readByte() != 120) {
                            throw new IOException("No end of block data seen for class with readExternal (ObjectInputStream) method.");
                        }
                    }
                    object = this.processResolution(objectStreamClass, externalizable, n);
                    break;
                }
                Object object3 = this.newObject(clazz, objectStreamClass.firstNonSerializableParentConstructor);
                int n = this.assignNewHandle(object3);
                Object object4 = this.currentObject;
                ObjectStreamClass objectStreamClass3 = this.currentObjectStreamClass;
                TreeSet treeSet = this.currentObjectValidators;
                this.currentObject = object3;
                this.currentObjectValidators = null;
                ObjectStreamClass[] objectStreamClassArray = this.inputGetObjectStreamClasses(clazz);
                int n5 = 0;
                while (n5 < objectStreamClassArray.length) {
                    byte by4;
                    Method method;
                    this.currentObjectStreamClass = objectStreamClassArray[n5];
                    if (dump) {
                        this.dumpElementln("Reading fields of " + this.currentObjectStreamClass.getName());
                    }
                    if ((method = this.currentObjectStreamClass.readObjectMethod) != null) {
                        this.fieldsAlreadyRead = false;
                        by4 = this.setBlockDataMode(true);
                        this.callReadMethod(method, this.currentObjectStreamClass.forClass(), object3);
                        this.setBlockDataMode(by4 != 0);
                    } else {
                        this.readFields(object3, this.currentObjectStreamClass);
                    }
                    if (this.currentObjectStreamClass.hasWriteMethod()) {
                        if (dump) {
                            this.dumpElement("ENDBLOCKDATA? ");
                        }
                        try {
                            by4 = this.realInputStream.readByte();
                            while (by4 != 120) {
                                this.parseContent(by4);
                                by4 = this.realInputStream.readByte();
                            }
                            if (dump) {
                                this.dumpElementln("yes");
                            }
                        }
                        catch (EOFException eOFException) {
                            throw (IOException)new IOException("No end of block data seen for class with readObject (ObjectInputStream) method.").initCause(eOFException);
                        }
                    }
                    ++n5;
                }
                this.currentObject = object4;
                this.currentObjectStreamClass = objectStreamClass3;
                object = this.processResolution(objectStreamClass, object3, n);
                if (this.currentObjectValidators != null) {
                    this.invokeValidators();
                }
                this.currentObjectValidators = treeSet;
                break;
            }
            case 121: {
                if (dump) {
                    this.dumpElementln("RESET");
                }
                this.clearHandles();
                object = this.readObject();
                break;
            }
            case 123: {
                if (dump) {
                    this.dumpElement("EXCEPTION=");
                }
                Exception exception = (Exception)this.readObject();
                if (dump) {
                    this.dumpElementln(exception.toString());
                }
                this.clearHandles();
                throw new WriteAbortedException("Exception thrown during writing of stream", exception);
            }
            default: {
                throw new IOException("Unknown marker on stream: " + by);
            }
        }
        return object;
    }

    private final void checkTypeConsistency(String string, ObjectStreamField[] objectStreamFieldArray, ObjectStreamField[] objectStreamFieldArray2) throws InvalidClassException {
        int n = 0;
        n = 0;
        while (n < objectStreamFieldArray.length && objectStreamFieldArray[n].isPrimitive()) {
            ++n;
        }
        if (n == objectStreamFieldArray.length) {
            return;
        }
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length && n < objectStreamFieldArray.length) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[n];
            ObjectStreamField objectStreamField2 = objectStreamFieldArray2[n2];
            if (!objectStreamField2.isPrimitive()) break;
            int n3 = objectStreamField.getName().compareTo(objectStreamField2.getName());
            if (n3 < 0) {
                ++n;
                continue;
            }
            if (n3 > 0) {
                ++n2;
                continue;
            }
            throw new InvalidClassException("invalid field type for " + objectStreamField2.getName() + " in class " + string);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected ObjectStreamClass readClassDescriptor() throws ClassNotFoundException, IOException {
        block23: {
            if (ObjectInputStream.dump) {
                this.dumpElement("CLASSDESC NAME=");
            }
            var1_1 = this.realInputStream.readUTF();
            if (ObjectInputStream.dump) {
                this.dumpElement(var1_1 + "; UID=");
            }
            var2_2 = this.realInputStream.readLong();
            if (ObjectInputStream.dump) {
                this.dumpElement(Long.toHexString(var2_2) + "; FLAGS=");
            }
            var4_3 = this.realInputStream.readByte();
            if (ObjectInputStream.dump) {
                this.dumpElement(Integer.toHexString(var4_3) + "; FIELD COUNT=");
            }
            var5_4 = this.realInputStream.readShort();
            if (ObjectInputStream.dump) {
                this.dumpElementln(Short.toString((short)var5_4));
            }
            var6_5 = new ObjectStreamField[var5_4];
            var7_6 = new ObjectStreamClass(var1_1, var2_2, var4_3, var6_5);
            this.assignNewHandle(var7_6);
            var8_7 = this.currentLoader();
            var9_8 = 0;
            while (var9_8 < var5_4) {
                if (ObjectInputStream.dump) {
                    this.dumpElement("  TYPE CODE=");
                }
                var10_10 = (char)this.realInputStream.readByte();
                if (ObjectInputStream.dump) {
                    this.dumpElement((char)var10_10 + "; FIELD NAME=");
                }
                var11_11 = this.realInputStream.readUTF();
                if (ObjectInputStream.dump) {
                    this.dumpElementln((String)var11_11);
                }
                var12_12 = var10_10 == 76 != 0 || var10_10 == 91 != 0 ? (String)this.readObject() : String.valueOf((char)var10_10);
                var6_5[var9_8] = new ObjectStreamField((String)var11_11, (String)var12_12, var8_7);
                ++var9_8;
            }
            var9_9 = this.resolveClass(var7_6);
            var10_10 = this.setBlockDataMode(true);
            var7_6.setClass(var9_9, this.lookupClass(var9_9.getSuperclass()));
            this.classLookupTable.put(var9_9, var7_6);
            this.setBlockDataMode(var10_10);
            var11_11 = var9_9.getSuperclass();
            if (var11_11 != null) ** GOTO lbl46
            var11_11 = var9_9;
            break block23;
lbl-1000:
            // 1 sources

            {
                var11_11 = var11_11.getSuperclass();
lbl46:
                // 2 sources

                if ((v0 = ObjectInputStream.class$java$io$Serializable) != null) continue;
                v0 = ObjectInputStream.class("[Ljava.io.Serializable;", false);
                ** while (v0.isAssignableFrom((Class)var11_11))
            }
        }
        var12_12 = var11_11;
        var7_6.firstNonSerializableParentConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction((Class)var12_12){
            final /* synthetic */ Class val$local_constructor_class;

            public final Object run() {
                try {
                    Constructor constructor = this.val$local_constructor_class.getDeclaredConstructor(new Class[0]);
                    if (Modifier.isPrivate(constructor.getModifiers())) {
                        return null;
                    }
                    return constructor;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
            {
                this.val$local_constructor_class = clazz;
            }
        });
        v1 = ObjectInputStream.class$java$io$Serializable;
        if (v1 == null) {
            v1 = ObjectInputStream.class$java$io$Serializable = ObjectInputStream.class("[Ljava.io.Serializable;", false);
        }
        var7_6.realClassIsSerializable = v1.isAssignableFrom(var9_9);
        v2 = ObjectInputStream.class$java$io$Externalizable;
        if (v2 == null) {
            v2 = ObjectInputStream.class$java$io$Externalizable = ObjectInputStream.class("[Ljava.io.Externalizable;", false);
        }
        var7_6.realClassIsExternalizable = v2.isAssignableFrom(var9_9);
        var13_13 = var7_6.fields;
        var14_14 = ObjectStreamClass.lookupForClassObject((Class)var9_9).fields;
        var15_15 = new ObjectStreamField[2 * Math.max(var13_13.length, var14_14.length)];
        var16_16 = 0;
        var17_17 = 0;
        var18_18 = 0;
        this.checkTypeConsistency(var1_1, var14_14, var13_13);
        this.checkTypeConsistency(var1_1, var13_13, var14_14);
        while (var16_16 < var13_13.length || var17_17 < var14_14.length) {
            var19_19 = null;
            var20_20 = null;
            if (var16_16 == var13_13.length) {
                var20_20 = var14_14[var17_17++];
            } else if (var17_17 == var14_14.length) {
                var19_19 = var13_13[var16_16++];
            } else {
                var21_21 = var14_14[var17_17].compareTo(var13_13[var16_16]);
                if (var21_21 < 0) {
                    var20_20 = var14_14[var17_17++];
                } else if (var21_21 > 0) {
                    var19_19 = var13_13[var16_16++];
                } else {
                    var19_19 = var13_13[var16_16++];
                    var20_20 = var14_14[var17_17++];
                    if (var19_19.getType() != var20_20.getType()) {
                        throw new InvalidClassException("invalid field type for " + var20_20.getName() + " in class " + var1_1);
                    }
                }
            }
            if (var18_18 == var15_15.length) {
                var21_22 = new ObjectStreamField[var15_15.length + 2];
                System.arraycopy(var15_15, 0, var21_22, 0, var15_15.length);
                var15_15 = var21_22;
            }
            var15_15[var18_18++] = var19_19;
            var15_15[var18_18++] = var20_20;
        }
        var7_6.fieldMapping = var15_15;
        return var7_6;
    }

    public void defaultReadObject() throws ClassNotFoundException, IOException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultReadObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("defaultReadObject called but fields already read from stream (by defaultReadObject or readFields)");
        }
        boolean bl = this.setBlockDataMode(false);
        this.readFields(this.currentObject, this.currentObjectStreamClass);
        this.setBlockDataMode(bl);
        this.fieldsAlreadyRead = true;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws InvalidObjectException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("registerValidation called by non-active class and/or object");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("attempt to add a null ObjectInputValidation object");
        }
        if (this.currentObjectValidators == null) {
            this.currentObjectValidators = new TreeSet();
        }
        this.currentObjectValidators.add(new ValidatorAndPriority(objectInputValidation, n));
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        String string = objectStreamClass.getName();
        try {
            return Class.forName(string, true, this.currentLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals("void")) {
                return Void.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            throw classNotFoundException;
        }
    }

    private final ClassLoader currentLoader() {
        return VMObjectInputStream.currentClassLoader();
    }

    private final ObjectStreamClass lookupClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.classLookupTable.get(clazz);
        if (objectStreamClass == null) {
            return ObjectStreamClass.lookup(clazz);
        }
        return objectStreamClass;
    }

    private final ObjectStreamClass[] inputGetObjectStreamClasses(Class clazz) {
        ObjectStreamClass objectStreamClass = this.lookupClass(clazz);
        if (objectStreamClass == null) {
            return new ObjectStreamClass[0];
        }
        Vector vector = new Vector();
        while (objectStreamClass != null) {
            vector.addElement(objectStreamClass);
            objectStreamClass = objectStreamClass.getSuper();
        }
        int n = vector.size();
        ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            objectStreamClassArray[n - n2 - 1] = (ObjectStreamClass)vector.elementAt(n2);
            --n2;
        }
        return objectStreamClassArray;
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        int n;
        ClassLoader classLoader = this.currentLoader();
        Class[] classArray = new Class[stringArray.length];
        if (classLoader == null) {
            n = 0;
            while (n < stringArray.length) {
                classArray[n] = Class.forName(stringArray[n]);
                ++n;
            }
            classLoader = ClassLoader.getSystemClassLoader();
        } else {
            n = 0;
            while (n < stringArray.length) {
                classArray[n] = Class.forName(stringArray[n], false, classLoader);
                ++n;
            }
        }
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean bl2 = this.resolveEnabled;
        this.resolveEnabled = bl;
        return bl2;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (dump) {
            this.dumpElement("STREAM MAGIC ");
        }
        if (this.realInputStream.readShort() != -21267) {
            throw new StreamCorruptedException("Invalid stream magic number");
        }
        if (dump) {
            this.dumpElementln("STREAM VERSION ");
        }
        if (this.realInputStream.readShort() != 5) {
            throw new StreamCorruptedException("Invalid stream version number");
        }
    }

    public int read() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockData[this.blockDataPosition++] & 0xFF;
        }
        return this.realInputStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readDataFromBlock) {
            int n3 = this.blockDataBytes - this.blockDataPosition;
            if (n3 == 0) {
                this.readNextBlock();
                n3 = this.blockDataBytes - this.blockDataPosition;
            }
            n2 = Math.min(n2, n3);
            System.arraycopy(this.blockData, this.blockDataPosition, byArray, n, n2);
            this.blockDataPosition += n2;
            return n2;
        }
        return this.realInputStream.read(byArray, n, n2);
    }

    public int available() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockDataBytes - this.blockDataPosition;
        }
        return this.realInputStream.available();
    }

    public void close() throws IOException {
        this.realInputStream.close();
    }

    public boolean readBoolean() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        boolean bl3 = this.dataInputStream.readBoolean();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return bl3;
    }

    public byte readByte() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        byte by = this.dataInputStream.readByte();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return by;
    }

    public int readUnsignedByte() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readUnsignedByte();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    public short readShort() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        short s = this.dataInputStream.readShort();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return s;
    }

    public int readUnsignedShort() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readUnsignedShort();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    public char readChar() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        char c = this.dataInputStream.readChar();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return c;
    }

    public int readInt() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 4) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readInt();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    public long readLong() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 8) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        long l = this.dataInputStream.readLong();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return l;
    }

    public float readFloat() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 4) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        float f = this.dataInputStream.readFloat();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return f;
    }

    public double readDouble() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 8) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        double d = this.dataInputStream.readDouble();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return d;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dataInputStream.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.dataInputStream.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.dataInputStream.skipBytes(n);
    }

    public String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("readFields called by non-active class and/or object");
        }
        if (this.prereadFields != null) {
            return this.prereadFields;
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("readFields called but fields already read from stream (by defaultReadObject or readFields)");
        }
        final ObjectStreamClass objectStreamClass = this.currentObjectStreamClass;
        final byte[] byArray = new byte[objectStreamClass.primFieldSize];
        final Object[] objectArray = new Object[objectStreamClass.objectFieldCount];
        boolean bl = this.setBlockDataMode(false);
        this.readFully(byArray);
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.readObject();
            ++n;
        }
        this.setBlockDataMode(bl);
        this.prereadFields = new GetField(){

            public final ObjectStreamClass getObjectStreamClass() {
                return objectStreamClass;
            }

            public final boolean defaulted(String string) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = objectStreamClass.getField(string);
                if (objectStreamField != null) {
                    return objectStreamField.isPersistent() && !objectStreamField.isToSet();
                }
                try {
                    boolean bl = false;
                    if (objectStreamClass.forClass().getDeclaredField(string) != null) {
                        bl = true;
                    }
                    return bl;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalArgumentException(noSuchFieldException);
                }
            }

            public final boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Boolean.TYPE);
                if (objectStreamField == null) {
                    return bl;
                }
                int n = 0;
                if (byArray[objectStreamField.getOffset()] == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            public final char get(String string, char c) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Character.TYPE);
                if (objectStreamField == null) {
                    return c;
                }
                int n = objectStreamField.getOffset();
                return (char)((byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
            }

            public final byte get(String string, byte by) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Byte.TYPE);
                if (objectStreamField == null) {
                    return by;
                }
                return byArray[objectStreamField.getOffset()];
            }

            public final short get(String string, short s) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Short.TYPE);
                if (objectStreamField == null) {
                    return s;
                }
                int n = objectStreamField.getOffset();
                return (short)((byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
            }

            public final int get(String string, int n) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Integer.TYPE);
                if (objectStreamField == null) {
                    return n;
                }
                int n2 = objectStreamField.getOffset();
                return (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
            }

            public final long get(String string, long l) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Long.TYPE);
                if (objectStreamField == null) {
                    return l;
                }
                int n = objectStreamField.getOffset();
                return ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | (long)((byArray[n++] & 0xFF) << 24) | (long)((byArray[n++] & 0xFF) << 16) | (long)((byArray[n++] & 0xFF) << 8) | (long)(byArray[n] & 0xFF);
            }

            public final float get(String string, float f) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Float.TYPE);
                if (objectStreamField == null) {
                    return f;
                }
                int n = objectStreamField.getOffset();
                return Float.intBitsToFloat((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
            }

            public final double get(String string, double d) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Double.TYPE);
                if (objectStreamField == null) {
                    return d;
                }
                int n = objectStreamField.getOffset();
                return Double.longBitsToDouble(((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | (long)((byArray[n++] & 0xFF) << 24) | (long)((byArray[n++] & 0xFF) << 16) | (long)((byArray[n++] & 0xFF) << 8) | (long)(byArray[n] & 0xFF));
            }

            public final Object get(String string, Object object) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, object == null ? null : object.getClass());
                if (objectStreamField == null) {
                    return object;
                }
                return objectArray[objectStreamField.getOffset()];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final ObjectStreamField getField(String string, Class clazz) throws IllegalArgumentException {
                ObjectStreamField objectStreamField;
                ObjectStreamField objectStreamField2;
                block18: {
                    objectStreamField2 = objectStreamClass.getField(string);
                    boolean bl = false;
                    try {
                        Class clazz2;
                        block16: {
                            clazz2 = objectStreamField2.getType();
                            if (clazz != clazz2 && (clazz != null || clazz2.isPrimitive())) break block16;
                            ObjectStreamField objectStreamField3 = objectStreamField2;
                            Object var6_9 = null;
                            if (!bl && objectStreamField2 != null && !objectStreamField2.isToSet() && objectStreamField2.isPersistent()) {
                                return null;
                            }
                            try {
                                Field field = objectStreamClass.forClass().getDeclaredField(string);
                                if (Modifier.isTransient(field.getModifiers())) {
                                    throw new IllegalArgumentException("no such field (non transient) " + string);
                                }
                                if (objectStreamField2 != null) return objectStreamField3;
                                if (field.getType() == clazz) return objectStreamField3;
                                throw new IllegalArgumentException("Invalid requested type for field " + string);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                if (objectStreamField2 != null) return objectStreamField3;
                                throw new IllegalArgumentException(noSuchFieldException);
                            }
                        }
                        try {
                            String string2;
                            bl = true;
                            StringBuffer stringBuffer = new StringBuffer("Field requested is of type ").append(clazz2.getName()).append(", but requested type was ");
                            if (clazz == null) {
                                string2 = "Object";
                                throw new IllegalArgumentException(stringBuffer.append(string2).toString());
                            }
                            string2 = clazz.getName();
                            throw new IllegalArgumentException(stringBuffer.append(string2).toString());
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw illegalArgumentException;
                        }
                        objectStreamField = null;
                        Object var6_10 = null;
                        if (bl || objectStreamField2 == null || objectStreamField2.isToSet() || !objectStreamField2.isPersistent()) break block18;
                        return null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        if (!bl && objectStreamField2 != null && !objectStreamField2.isToSet() && objectStreamField2.isPersistent()) {
                            return null;
                        }
                        try {}
                        catch (NoSuchFieldException noSuchFieldException) {
                            if (objectStreamField2 != null) throw throwable;
                            throw new IllegalArgumentException(noSuchFieldException);
                        }
                        Field field = objectStreamClass.forClass().getDeclaredField(string);
                        if (Modifier.isTransient(field.getModifiers())) {
                            throw new IllegalArgumentException("no such field (non transient) " + string);
                        }
                        if (objectStreamField2 != null) throw throwable;
                        if (field.getType() == clazz) throw throwable;
                        throw new IllegalArgumentException("Invalid requested type for field " + string);
                    }
                }
                try {}
                catch (NoSuchFieldException noSuchFieldException) {
                    if (objectStreamField2 != null) return objectStreamField;
                    throw new IllegalArgumentException(noSuchFieldException);
                }
                Field field = objectStreamClass.forClass().getDeclaredField(string);
                if (Modifier.isTransient(field.getModifiers())) {
                    throw new IllegalArgumentException("no such field (non transient) " + string);
                }
                if (objectStreamField2 != null) return objectStreamField;
                if (field.getType() == clazz) return objectStreamField;
                throw new IllegalArgumentException("Invalid requested type for field " + string);
            }
        };
        this.fieldsAlreadyRead = true;
        return this.prereadFields;
    }

    protected Object readObjectOverride() throws ClassNotFoundException, IOException, OptionalDataException {
        throw new IOException("Subclass of ObjectInputStream must implement readObjectOverride");
    }

    private final int assignNewHandle(Object object) {
        this.objectLookupTable.put(new Integer(this.nextOID), new ObjectIdentityWrapper(object));
        return this.nextOID++;
    }

    private final Object processResolution(ObjectStreamClass objectStreamClass, Object object, int n) throws IOException {
        block8: {
            if (objectStreamClass != null && object instanceof Serializable) {
                try {
                    Method method = objectStreamClass.readResolveMethod;
                    if (method != null) {
                        object = method.invoke(object, new Object[0]);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable instanceof ObjectStreamException) {
                        throw (ObjectStreamException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (!(throwable instanceof Error)) break block8;
                    throw (Error)throwable;
                }
            }
        }
        if (this.resolveEnabled) {
            object = this.resolveObject(object);
        }
        this.objectLookupTable.put(new Integer(n), new ObjectIdentityWrapper(object));
        return object;
    }

    private final void clearHandles() {
        this.objectLookupTable.clear();
        this.nextOID = 0x7E0000;
    }

    private final void readNextBlock() throws IOException {
        byte by = this.realInputStream.readByte();
        while (by == 121) {
            if (dump) {
                this.dumpElementln("RESET");
            }
            this.clearHandles();
            by = this.realInputStream.readByte();
        }
        this.readNextBlock(by);
    }

    private final void readNextBlock(byte by) throws IOException {
        if (by == 119) {
            if (dump) {
                this.dumpElement("BLOCK DATA SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readUnsignedByte();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else if (by == 122) {
            if (dump) {
                this.dumpElement("BLOCK DATA LONG SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readInt();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else {
            throw new EOFException("Attempt to read primitive data, but no data block is active.");
        }
        if (this.blockData.length < this.blockDataBytes) {
            this.blockData = new byte[this.blockDataBytes];
        }
        this.realInputStream.readFully(this.blockData, 0, this.blockDataBytes);
        this.blockDataPosition = 0;
    }

    private final void readArrayElements(Object object, Class clazz) throws ClassNotFoundException, IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                int n = 0;
                while (n < blArray.length) {
                    blArray[n] = this.realInputStream.readBoolean();
                    ++n;
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                int n = 0;
                while (n < byArray.length) {
                    byArray[n] = this.realInputStream.readByte();
                    ++n;
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                int n = 0;
                while (n < cArray.length) {
                    cArray[n] = this.realInputStream.readChar();
                    ++n;
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                int n = 0;
                while (n < dArray.length) {
                    dArray[n] = this.realInputStream.readDouble();
                    ++n;
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                int n = 0;
                while (n < fArray.length) {
                    fArray[n] = this.realInputStream.readFloat();
                    ++n;
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = this.realInputStream.readInt();
                    ++n;
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                int n = 0;
                while (n < lArray.length) {
                    lArray[n] = this.realInputStream.readLong();
                    ++n;
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                int n = 0;
                while (n < sArray.length) {
                    sArray[n] = this.realInputStream.readShort();
                    ++n;
                }
                return;
            }
        } else {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = this.readObject();
                ++n;
            }
        }
    }

    private final void readFields(Object object, ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.fieldMapping;
        int n = 0;
        while (n < objectStreamFieldArray.length) {
            char c;
            String string;
            boolean bl;
            ObjectStreamField objectStreamField = objectStreamFieldArray[n];
            ObjectStreamField objectStreamField2 = objectStreamFieldArray[n + 1];
            boolean bl2 = false;
            if (objectStreamField != null && objectStreamField.getOffset() >= 0 && objectStreamField.isToSet()) {
                bl2 = true;
            }
            boolean bl3 = bl2;
            boolean bl4 = false;
            if (objectStreamField2 != null && objectStreamField2.isToSet()) {
                bl4 = bl = true;
            }
            if (objectStreamField != null) {
                string = objectStreamField.getName();
                c = objectStreamField.getTypeCode();
            } else {
                string = objectStreamField2.getName();
                c = objectStreamField2.getTypeCode();
            }
            switch (c) {
                case 'Z': {
                    boolean bl5;
                    boolean bl6 = false;
                    if (bl3) {
                        bl6 = bl5 = this.realInputStream.readBoolean();
                    }
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + bl5);
                    }
                    if (!bl) break;
                    objectStreamField2.setBooleanField(object, bl5);
                    break;
                }
                case 'B': {
                    byte by;
                    byte by2 = 0;
                    if (bl3) {
                        by2 = by = this.realInputStream.readByte();
                    }
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + by);
                    }
                    if (!bl) break;
                    objectStreamField2.setByteField(object, by);
                    break;
                }
                case 'C': {
                    char c2;
                    char c3 = '\u0000';
                    if (bl3) {
                        c3 = c2 = this.realInputStream.readChar();
                    }
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + c2);
                    }
                    if (!bl) break;
                    objectStreamField2.setCharField(object, c2);
                    break;
                }
                case 'D': {
                    double d;
                    double d2 = d = bl3 ? this.realInputStream.readDouble() : 0.0;
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + d);
                    }
                    if (!bl) break;
                    objectStreamField2.setDoubleField(object, d);
                    break;
                }
                case 'F': {
                    float f;
                    float f2 = f = bl3 ? this.realInputStream.readFloat() : 0.0f;
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + f);
                    }
                    if (!bl) break;
                    objectStreamField2.setFloatField(object, f);
                    break;
                }
                case 'I': {
                    int n2;
                    int n3 = 0;
                    if (bl3) {
                        n3 = n2 = this.realInputStream.readInt();
                    }
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + n2);
                    }
                    if (!bl) break;
                    objectStreamField2.setIntField(object, n2);
                    break;
                }
                case 'J': {
                    long l;
                    long l2 = l = bl3 ? this.realInputStream.readLong() : 0L;
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + l);
                    }
                    if (!bl) break;
                    objectStreamField2.setLongField(object, l);
                    break;
                }
                case 'S': {
                    short s;
                    short s2 = 0;
                    if (bl3) {
                        s2 = s = this.realInputStream.readShort();
                    }
                    if (dump && bl3 && bl) {
                        this.dumpElementln("  " + string + ": " + s);
                    }
                    if (!bl) break;
                    objectStreamField2.setShortField(object, s);
                    break;
                }
                case 'L': 
                case '[': {
                    Object object2;
                    Object object3 = object2 = bl3 ? this.readObject() : null;
                    if (!bl) break;
                    objectStreamField2.setObjectField(object, object2);
                    break;
                }
                default: {
                    throw new InternalError("Invalid type code: " + c);
                }
            }
            n += 2;
        }
    }

    private final boolean setBlockDataMode(boolean bl) {
        boolean bl2 = this.readDataFromBlock;
        this.readDataFromBlock = bl;
        this.dataInputStream = bl ? this.blockDataInput : this.realInputStream;
        return bl2;
    }

    private final Object newObject(Class clazz, Constructor constructor) throws ClassNotFoundException, IOException {
        if (constructor == null) {
            throw new InvalidClassException("Missing accessible no-arg base class constructor for " + clazz.getName());
        }
        try {
            return VMObjectInputStream.allocateObject(clazz, constructor.getDeclaringClass(), constructor);
        }
        catch (InstantiationException instantiationException) {
            throw (ClassNotFoundException)new ClassNotFoundException("Instance of " + clazz + " could not be created").initCause(instantiationException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void invokeValidators() throws InvalidObjectException {
        try {
            Iterator iterator = this.currentObjectValidators.iterator();
            while (iterator.hasNext()) {
                ValidatorAndPriority validatorAndPriority = (ValidatorAndPriority)iterator.next();
                ObjectInputValidation objectInputValidation = validatorAndPriority.validator;
                objectInputValidation.validateObject();
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.currentObjectValidators = null;
            throw throwable;
        }
        {
            Object var2_6 = null;
            this.currentObjectValidators = null;
            return;
        }
    }

    private final void callReadMethod(Method method, Class clazz, Object object) throws ClassNotFoundException, IOException {
        try {
            method.invoke(object, new Object[]{this});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw (IOException)new IOException("Exception thrown from readObject() on " + clazz).initCause(invocationTargetException);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("Failure invoking readObject() on " + clazz).initCause(exception);
        }
        this.prereadFields = null;
    }

    private final void dumpElement(String string) {
        System.out.print(string);
    }

    private final void dumpElementln(String string) {
        System.out.println(string);
        int n = 0;
        while (n < this.depth) {
            System.out.print(" ");
            ++n;
        }
        System.out.print(Thread.currentThread() + ": ");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.depth = 0;
    }

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.this();
        this.resolveEnabled = false;
        this.blockDataPosition = 0;
        this.blockDataBytes = 0;
        this.blockData = new byte[1024];
        this.blockDataInput = new DataInputStream(this);
        this.realInputStream = new DataInputStream(inputStream);
        this.nextOID = 0x7E0000;
        this.objectLookupTable = new Hashtable();
        this.classLookupTable = new Hashtable();
        this.setBlockDataMode(true);
        this.readStreamHeader();
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        this.this();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    private static final class ValidatorAndPriority
    implements Comparable {
        int priority;
        ObjectInputValidation validator;

        public final int compareTo(Object object) {
            ValidatorAndPriority validatorAndPriority = (ValidatorAndPriority)object;
            return this.priority - validatorAndPriority.priority;
        }

        ValidatorAndPriority(ObjectInputValidation objectInputValidation, int n) {
            this.priority = n;
            this.validator = objectInputValidation;
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

