/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static final Map systemFlavorMaps = new WeakHashMap();
    private static final String GNU_JAVA_MIME_PREFIX = "gnu.java:";
    private HashMap nativeToFlavorMap;
    private HashMap flavorToNativeMap;

    public final Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        return new HashMap();
    }

    public final Map getFlavorsForNatives(String[] stringArray) {
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final FlavorMap getDefaultFlavorMap() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Map map = systemFlavorMaps;
        synchronized (map) {
            FlavorMap flavorMap = (FlavorMap)systemFlavorMaps.get(classLoader);
            if (flavorMap == null) {
                flavorMap = new SystemFlavorMap();
                systemFlavorMaps.put(classLoader, flavorMap);
            }
            return flavorMap;
        }
    }

    public static final String encodeJavaMIMEType(String string) {
        if (string != null) {
            return GNU_JAVA_MIME_PREFIX + string;
        }
        return null;
    }

    public static final String encodeDataFlavor(DataFlavor dataFlavor) {
        if (dataFlavor != null) {
            return SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType());
        }
        return null;
    }

    public static final boolean isJavaMIMEType(String string) {
        boolean bl = false;
        if (string != null && string.startsWith(GNU_JAVA_MIME_PREFIX)) {
            bl = true;
        }
        return bl;
    }

    public static final String decodeJavaMIMEType(String string) {
        if (SystemFlavorMap.isJavaMIMEType(string)) {
            return string.substring(GNU_JAVA_MIME_PREFIX.length());
        }
        return null;
    }

    public static final DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
        if (string2 != null) {
            return new DataFlavor(string2);
        }
        return null;
    }

    public final List getFlavorsForNative(String string) {
        throw new Error("Not implemented");
    }

    public final List getNativesForFlavor(DataFlavor dataFlavor) {
        throw new Error("Not implemented");
    }

    public final synchronized void addFlavorForUnencodedNative(String string, DataFlavor dataFlavor) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        List list2 = (List)this.nativeToFlavorMap.get(string);
        if (list2 == null) {
            list2 = new ArrayList();
            this.nativeToFlavorMap.put(string, list2);
        } else if (!list2.contains(dataFlavor)) {
            list2.add(dataFlavor);
        }
    }

    public final synchronized void addUnencodedNativeForFlavor(DataFlavor dataFlavor, String string) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        List list2 = (List)this.flavorToNativeMap.get(dataFlavor);
        if (list2 == null) {
            list2 = new ArrayList();
            this.flavorToNativeMap.put(dataFlavor, list2);
        } else if (!list2.contains(string)) {
            list2.add(string);
        }
    }

    public final synchronized void setNativesForFlavor(DataFlavor dataFlavor, String[] stringArray) {
        if (stringArray == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        this.flavorToNativeMap.remove(dataFlavor);
        int n = 0;
        while (n < stringArray.length) {
            this.addUnencodedNativeForFlavor(dataFlavor, stringArray[n]);
            ++n;
        }
    }

    public final synchronized void setFlavorsForNative(String string, DataFlavor[] dataFlavorArray) {
        if (string == null || dataFlavorArray == null) {
            throw new NullPointerException();
        }
        this.nativeToFlavorMap.remove(string);
        int n = 0;
        while (n < dataFlavorArray.length) {
            this.addFlavorForUnencodedNative(string, dataFlavorArray[n]);
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.nativeToFlavorMap = new HashMap();
        this.flavorToNativeMap = new HashMap();
    }

    private SystemFlavorMap() {
        this.this();
    }
}

