/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Window;

public abstract class GraphicsDevice {
    public static final int TYPE_RASTER_SCREEN = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_IMAGE_BUFFER = 2;
    private Window full_screen;
    private Rectangle fullScreenOldBounds;
    private DisplayMode mode;

    public abstract int getType();

    public abstract String getIDstring();

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate graphicsConfigTemplate) {
        return graphicsConfigTemplate.getBestConfiguration(this.getConfigurations());
    }

    public boolean isFullScreenSupported() {
        return true;
    }

    public synchronized void setFullScreenWindow(Window window) {
        if (this.full_screen != null) {
            this.full_screen.setBounds(this.fullScreenOldBounds);
        }
        this.full_screen = null;
        if (window != null) {
            this.fullScreenOldBounds = window.getBounds();
            this.full_screen = window;
            DisplayMode displayMode = this.getDisplayMode();
            this.full_screen.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            this.full_screen.requestFocus();
            this.full_screen.setLocationRelativeTo(null);
        }
    }

    public Window getFullScreenWindow() {
        return this.full_screen;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        DisplayMode[] displayModeArray = this.getDisplayModes();
        if (!this.isDisplayChangeSupported()) {
            throw new UnsupportedOperationException();
        }
        int n = 0;
        if (displayModeArray != null) {
            n = displayModeArray.length;
        }
        int n2 = n;
        while (--n2 >= 0) {
            if (displayModeArray[n2].equals(displayMode)) break;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.mode = displayMode;
    }

    public DisplayMode getDisplayMode() {
        return this.mode;
    }

    public DisplayMode[] getDisplayModes() {
        return new DisplayMode[0];
    }

    public int getAvailableAcceleratedMemory() {
        return 0;
    }

    protected GraphicsDevice() {
    }
}

