### Name: as.POSIX*
### Title: Date-time Conversion Functions
### Aliases: as.POSIXct as.POSIXct.default as.POSIXct.POSIXlt
###   as.POSIXct.date as.POSIXct.dates as.POSIXct.Date as.POSIXlt
###   as.double.POSIXlt
### Keywords: utilities chron

### ** Examples

(z <- Sys.time())             # the current datetime, as class "POSIXct"
unclass(z)                    # a large integer
floor(unclass(z)/86400)       # the number of days since 1970-01-01
(z <- as.POSIXlt(Sys.time())) # the current datetime, as class "POSIXlt"
unlist(unclass(z))            # a list shown as a named vector

## suppose we have a time in seconds since 1960-01-01 00:00:00 GMT
z <- 1472562988
# two ways to convert this
ISOdatetime(1960,1,1,0,0,0) + z # late August 2006
strptime("1960-01-01", "%Y-%m-%d", tz="GMT") + z

as.POSIXlt(Sys.time(), "GMT") # the current time in GMT
## Not run: 
##D ## These may not be correct names on your system
##D as.POSIXlt(Sys.time(), "EST5EDT")  # the current time in New York
##D as.POSIXlt(Sys.time(), "EST" )     # ditto, ignoring DST
##D as.POSIXlt(Sys.time(), "HST")      # the current time in Hawaii
##D as.POSIXlt(Sys.time(), "Australia/Darwin")
## End(Not run)



