=begin
  locale_table_win32.rb - Locale table for win32

  Copyright (C) 2002-2008 Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: win32_table.rb,v 1.3 2008/02/02 16:47:40 mutoh Exp $
=end

module Locale
  module SystemWin32

    #LangID, locale name, code page
    LocaleTable = [
        [0x0000, "en", "CP1252"],
        [0x007f, "invariant", "CP1252"],
        [0x0400, "invalid", "CP1252"],
        [0x0800, "system", "CP1252"],
        [0x0436, "af-ZA", "CP1252"],
        [0x041c, "sq-AL", "CP1252"],
        [0x0484, "gsw-FR", "CP1252"],
        [0x045e, "am-ET", "UNICODE"],
        [0x0401, "ar-SA", "CP1256"],
        [0x0801, "ar-IQ", "CP1256"],
        [0x0c01, "ar-EG", "CP1256"],
        [0x1001, "ar-LY", "CP1256"],
        [0x1401, "ar-DZ", "CP1256"],
        [0x1801, "ar-MA", "CP1256"],
        [0x1c01, "ar-TN", "CP1256"],
        [0x2001, "ar-OM", "CP1256"],
        [0x2401, "ar-YE", "CP1256"],
        [0x2801, "ar-SY", "CP1256"],
        [0x2c01, "ar-JO", "CP1256"],
        [0x3001, "ar-LB", "CP1256"],
        [0x3401, "ar-KW", "CP1256"],
        [0x3801, "ar-AE", "CP1256"],
        [0x3c01, "ar-BH", "CP1256"],
        [0x4001, "ar-QA", "CP1256"],
        [0x042b, "hy-AM", "UNICODE"],
        [0x044d, "as-IN", "UNICODE"],
        [0x042c, "az-AZ-Latn", "CP1254"],
        [0x082c, "az-AZ-Cyrl", "CP1251"],
        [0x046d, "ba-RU", "UNICODE"],
        [0x042d, "eu-ES", "CP1252"],
        [0x0423, "be-BY", "CP1251"],
        [0x0445, "bn-IN", "UNICODE"],
        [0x201a, "bs-BA-Cyrl", "CP1251"],
        [0x141a, "bs-BA-Latn", "CP1250"],
        [0x047e, "br-FR", "CP1251"],
        [0x0402, "bg-BG", "CP1251"],
        [0x0455, "my-MM", "UNICODE"],
        [0x0403, "ca-ES", "CP1252"],
        [0x0004, "zh-CHS", "CP936"],
        [0x0404, "zh-TW", "CP950"],
        [0x0804, "zh-CN", "CP936"],
        [0x0c04, "zh-HK", "CP950"],
        [0x1004, "zh-SG", "CP936"],
        [0x1404, "zh-MO", "CP950"],
        [0x7c04, "zh-CHT", "CP950"],
        [0x0483, "co-FR", "CP1252"],
        [0x041a, "hr-HR", "CP1250"],
        [0x101a, "hr-BA", "CP1250"],
        [0x0405, "cs-CZ", "CP1250"],
        [0x0406, "da-DK", "CP1252"],
        [0x048c, "gbz-AF", "CP1256"],
        [0x0465, "dv-MV", "UNICODE"],
        [0x0413, "nl-NL", "CP1252"],
        [0x0813, "nl-BE", "CP1252"],
        [0x0409, "en-US", "CP1252"],
        [0x0809, "en-GB", "CP1252"],
        [0x0c09, "en-AU", "CP1252"],
        [0x1009, "en-CA", "CP1252"],
        [0x1409, "en-NZ", "CP1252"],
        [0x1809, "en-IE", "CP1252"],
        [0x1c09, "en-ZA", "CP1252"],
        [0x2009, "en-JA", "CP1252"],
        [0x2409, "en-CB", "CP1252"],
        [0x2809, "en-BZ", "CP1252"],
        [0x2c09, "en-TT", "CP1252"],
        [0x3009, "en-ZW", "CP1252"],
        [0x3409, "en-PH", "CP1252"],
        [0x4009, "en-IN", "CP1252"],
        [0x4409, "en-MY", "CP1252"],
        [0x4809, "en-SG", "CP1252"],
        [0x0425, "et-EE", "CP1257"],
        [0x0438, "fo-FO", "CP1252"],
        [0x464, "fil-PH", "CP1252"],
        [0x040b, "fi-FI", "CP1252"],
        [0x040c, "fr-FR", "CP1252"],
        [0x080c, "fr-BE", "CP1252"],
        [0x0c0c, "fr-CA", "CP1252"],
        [0x100c, "fr-CH", "CP1252"],
        [0x140c, "fr-LU", "CP1252"],
        [0x180c, "fr-MC", "CP1252"],
        [0x0462, "fy-NL", "CP1252"],
        [0x0456, "gl-ES", "CP1252"],
        [0x0437, "ka-GE", "UNICODE"],
        [0x0407, "de-DE", "CP1252"],
        [0x0807, "de-CH", "CP1252"],
        [0x0c07, "de-AT", "CP1252"],
        [0x1007, "de-LU", "CP1252"],
        [0x1407, "de-LI", "CP1252"],
        [0x0408, "el-GR", "CP1253"],
        [0x046f, "kl-GL", "CP1252"],
        [0x0447, "gu-IN", "UNICODE"],
        [0x0468, "ha-NG-Latn", "CP1252"],
        [0x040d, "he-IL", "CP1255"],
        [0x0439, "hi-IN", "UNICODE"],
        [0x040e, "hu-HU", "CP1250"],
        [0x040f, "is-IS", "CP1252"],
        [0x0421, "id-ID", "CP1252"],
        [0x045d, "iu-CA-Cans", "UNICODE"],
        [0x085d, "iu-CA-Latn", "CP1252"],
        [0x083c, "ga-IE", "CP1252"],
        [0x0434, "xh-ZA", "CP1252"],
        [0x0435, "zu-ZA", "CP1252"],
        [0x0410, "it-IT", "CP1252"],
        [0x0810, "it-CH", "CP1252"],
        [0x0411, "ja-JP", "CP932"],
        [0x044b, "kn-IN", "UNICODE"],
        [0x043f, "kk-KZ", "CP1251"],
        [0x0453, "kh-KH", "UNICODE"],
        [0x0486, "qut-GT", "CP1252"],
        [0x0487, "rw-RW", "CP1252"],
        [0x0457, "kok-IN", "UNICODE"],
        [0x0412, "ko-KR", "CP949"],
        [0x0812, "ko-KR@win95", "CP949"],
        [0x0440, "ky-KG", "CP1251"],
        [0x0454, "lo-LA", "UNICODE"],
        [0x0426, "lv-LV", "CP1257"],
        [0x0427, "lt-LT", "CP1257"],
        [0x0827, "lt-LT@win98", "CP1257"],
        [0x082e, "wee-DE", "CP1252"],
        [0x046e, "lb-LU", "CP1252"],
        [0x042f, "mk-MK", "CP1251"],
        [0x043e, "ms-MY", "CP1252"],
        [0x083e, "ms-BN", "CP1252"],
        [0x044c, "ml-IN", "UNICODE"],
        [0x043a, "mt-MT", "CP1252"],
        [0x0481, "mi-NZ", "CP1252"],
        [0x047a, "arn-CL", "CP1252"],
        [0x044e, "mr-IN", "UNICODE"],
        [0x047c, "moh-CA", "CP1252"],
        [0x0450, "mn-MN", "CP1251"],
        [0x0850, "mn-CN", "UNICODE"],
        [0x0461, "ne-NP", "UNICODE"],
        [0x0414, "nb-NO", "CP1252"],
        [0x0814, "nn-NO", "CP1252"],
        [0x0482, "oc-FR", "CP1252"],
        [0x0448, "or-IN", "UNICODE"],
        [0x0463, "ps-AF", "UNICODE"],
        [0x0429, "fa-IR", "CP1256"],
        [0x0415, "pl-PL", "CP1250"],
        [0x0416, "pt-BR", "CP1252"],
        [0x0816, "pt-PT", "CP1252"],
        [0x0446, "pa-IN", "UNICODE"],
        [0x046b, "quz-BO", "CP1252"],
        [0x086b, "quz-EC", "CP1252"],
        [0x0c6b, "quz-PE", "CP1252"],
        [0x0418, "ro-RO", "CP1250"],
        [0x0417, "rm-CH", "CP1252"],
        [0x0419, "ru-RU", "CP1251"],
        [0x243b, "smn-FI", "CP1252"],
        [0x103b, "smj-NO", "CP1252"],
        [0x143b, "smj-SE", "CP1252"],
        [0x043b, "se-NO", "CP1252"],
        [0x083b, "se-SE", "CP1252"],
        [0x0c3b, "se-FI", "CP1252"],
        [0x203b, "sms-FI", "CP1252"],
        [0x183b, "sma-NO", "CP1252"],
        [0x1c3b, "sma-SE", "CP1252"],
        [0x044f, "sa-IN", "UNICODE"],
        [0x0c1a, "sr-SP-Cyrl", "CP1251"],
        [0x1c1a, "sr-BA-Cyrl", "CP1251"],
        [0x081a, "sr-SP-Latn", "CP1250"],
        [0x181a, "sr-BA-Latn", "CP1250"],
        [0x046c, "ns-ZA", "CP1252"],
        [0x0432, "tn-ZA", "CP1252"],
        [0x045b, "si-LK", "UNICODE"],
        [0x041b, "sk-SK", "CP1250"],
        [0x0424, "sl-SI", "CP1250"],
        [0x040a, "es-ES-ts", "CP1252"],
        [0x080a, "es-MX", "CP1252"],
        [0x0c0a, "es-ES", "CP1252"],
        [0x100a, "es-GT", "CP1252"],
        [0x140a, "es-CR", "CP1252"],
        [0x180a, "es-PA", "CP1252"],
        [0x1c0a, "es-DO", "CP1252"],
        [0x200a, "es-VE", "CP1252"],
        [0x240a, "es-CO", "CP1252"],
        [0x280a, "es-PE", "CP1252"],
        [0x2c0a, "es-AR", "CP1252"],
        [0x300a, "es-EC", "CP1252"],
        [0x340a, "es-CL", "CP1252"],
        [0x380a, "es-UY", "CP1252"],
        [0x3c0a, "es-PY", "CP1252"],
        [0x400a, "es-BO", "CP1252"],
        [0x440a, "es-SV", "CP1252"],
        [0x480a, "es-HN", "CP1252"],
        [0x4c0a, "es-NI", "CP1252"],
        [0x500a, "es-PR", "CP1252"],
        [0x540a, "es-US", "CP1252"],
        [0x0430, "sutu", "UNICODE"],
        [0x0441, "sw-KE", "CP1252"],
        [0x041d, "sv-SE", "CP1252"],
        [0x081d, "sv-FI", "CP1252"],
        [0x045a, "syr-SY", "UNICODE"],
        [0x0428, "tg-TJ-Cyrl", "CP1251"],
        [0x085f, "ber-DZ", "CP1252"],
        [0x0449, "ta-IN", "UNICODE"],
        [0x0444, "tt-RU", "CP1251"],
        [0x044a, "te-IN", "UNICODE"],
        [0x041e, "th-TH", "CP874"],
        [0x0451, "bo-CN", "UNICODE"],
        [0x0851, "bo-BT", "UNICODE"],
        [0x041f, "tr-TR", "CP1254"],
        [0x0442, "tk-TM", "CP1251"],
        [0x0480, "ug-CN", "CP1256"],
        [0x0422, "uk-UA", "CP1251"],
        [0x042e, "wen-DE", "CP1252"],
        [0x0420, "ur-PK", "CP1256"],
        [0x0820, "tr-IN", "CP1256"],
        [0x0443, "uz-UZ-Latn", "CP1254"],
        [0x0843, "uz-UZ-Cyrl", "CP1251"],
        [0x042a, "vi-VN", "CP1252"],
        [0x0452, "cy-GB", "CP1252"],
        [0x0488, "wo-SN", "CP1252"],
        [0x0485, "sah-RU", "CP1251"],
        [0x0478, "ii-CN", "UNICODE"],
        [0x046a, "yo-NG", "UNICODE"],
    ]
  end
end
