"""
font data tables for truetype and afm computer modern fonts
"""

# this dict maps symbol names to fontnames, glyphindex.  To get the
# glyph index from the character code, you have to use get_charmap
"""
from matplotlib.ft2font import FT2Font
font = FT2Font('/usr/local/share/matplotlib/cmr10.ttf')
items = font.get_charmap().items()
items.sort()

for charcode, glyphind in items:
    print charcode, glyphind
"""

latex_to_bakoma = {

    r'\oint'                : ('cmex10',  45),
    r'\bigodot'             : ('cmex10',  50),
    r'\bigoplus'            : ('cmex10',  55),
    r'\bigotimes'           : ('cmex10',  59),
    r'\sum'                 : ('cmex10',  51),
    r'\prod'                : ('cmex10',  24),
    r'\int'                 : ('cmex10',  56),
    r'\bigcup'              : ('cmex10',  28),
    r'\bigcap'              : ('cmex10',  60),
    r'\biguplus'            : ('cmex10',  32),
    r'\bigwedge'            : ('cmex10',   4),
    r'\bigvee'              : ('cmex10',  37),
    r'\coprod'              : ('cmex10',  42),
    r'\Leftbracket'         : ('cmex10',  29),
    r'\Rightbracket'        : ('cmex10',  61),
    r'\Leftbrace'           : ('cmex10',  43),
    r'\Rightbrace'          : ('cmex10',  16),
    r'\sqrt'                : ('cmex10',  48),
    r'\Sqrt'                : ('cmex10',  21),
    r'\SQRT'                : ('cmex10',  53),
    r'\leftbrace'           : ('cmex10',  92),
    r'{'                    : ('cmex10',  92),
    r'\rightbrace'          : ('cmex10', 130),
    r'}'                    : ('cmex10', 130),
    r'\leftangle'           : ('cmex10',  97),
    r'\rightangle'          : ('cmex10',  64),
    r'\Leftparen'           : ('cmex10', 112),
    r'\Rightparen'          : ('cmex10',  81),
    r'\LEFTparen'           : ('cmex10', 119),
    r'\RIGHTparen'          : ('cmex10',  87),
    r'\LEFTbracket'         : ('cmex10', 125),
    r'\RIGHTbracket'        : ('cmex10',  93),
    r'\LEFTbrace'           : ('cmex10',  70),
    r'\RIGHTbrace'          : ('cmex10', 107),
    r'\LEFTangle'           : ('cmex10',  76),
    r'\RIGHTangle'          : ('cmex10', 113),
    
    r'\omega'               : ('cmmi10',  29),
    r'\varepsilon'          : ('cmmi10',  20),
    r'\vartheta'            : ('cmmi10',  22),
    r'\varrho'              : ('cmmi10',  61),
    r'\varsigma'            : ('cmmi10',  41),
    r'\varphi'              : ('cmmi10',   6),
    r'\leftharpoonup'       : ('cmmi10', 108),
    r'\leftharpoondown'     : ('cmmi10',  68),
    r'\rightharpoonup'      : ('cmmi10', 117),
    r'\rightharpoondown'    : ('cmmi10',  77),
    r'\triangleright'       : ('cmmi10', 130),
    r'\triangleleft'        : ('cmmi10',  89),
    r'.'                    : ('cmmi10',  51),
    r','                    : ('cmmi10',  44),
    r'<'                    : ('cmmi10',  99),
    r'/'                    : ('cmmi10',  98),
    r'>'                    : ('cmmi10', 107),
    r'\flat'                : ('cmmi10', 131),
    r'\natural'             : ('cmmi10',  90),
    r'\sharp'               : ('cmmi10',  50),
    r'\smile'               : ('cmmi10',  97),
    r'\frown'               : ('cmmi10',  58),
    r'\ell'                 : ('cmmi10', 102),
    r'\imath'               : ('cmmi10',   8),
    r'\jmath'               : ('cmmi10',  65),
    r'\wp'                  : ('cmmi10',  14),
    r'\Gamma'               : ('cmmi10',  37),
    r'\Delta'               : ('cmmi10',  11),
    r'\Theta'               : ('cmmi10',  12),
    r'\Lambda'              : ('cmmi10',  26),
    r'\Xi'                  : ('cmmi10',   4),
    r'\Pi'                  : ('cmmi10',  33),
    r'\Sigma'               : ('cmmi10',  16),
    r'\Upsilon'             : ('cmmi10',  19),
    r'\Phi'                 : ('cmmi10',  15),
    r'\Psi'                 : ('cmmi10',  27),
    r'\Omega'               : ('cmmi10',  23),
    r'\alpha'               : ('cmmi10',  13),
    r'\beta'                : ('cmmi10',  35),
    r'\gamma'               : ('cmmi10',  24),
    r'\delta'               : ('cmmi10',  38),
    r'\epsilon'             : ('cmmi10',  54),
    r'\zeta'                : ('cmmi10',  10),
    r'\eta'                 : ('cmmi10',   5),
    r'\theta'               : ('cmmi10',  18),
    r'\iota'                : ('cmmi10',  28),
    r'\lambda'              : ('cmmi10',   9),
    r'\mu'                  : ('cmmi10',  32),
    r'\nu'                  : ('cmmi10',  34),
    r'\xi'                  : ('cmmi10',   7),
    r'\pi'                  : ('cmmi10',  36),
    r'\kappa'               : ('cmmi10',  30),    
    r'\rho'                 : ('cmmi10',  39),
    r'\sigma'               : ('cmmi10',  21),
    r'\tau'                 : ('cmmi10',  43),
    r'\upsilon'             : ('cmmi10',  25),
    r'\phi'                 : ('cmmi10',  42),
    r'\chi'                 : ('cmmi10',  17),
    r'\psi'                 : ('cmmi10',  31),

    r'('                    : ('cmr10',  119),
    r'\leftparen'           : ('cmr10',  119),
    r'\rightparen'          : ('cmr10',   68),
    r')'                    : ('cmr10',   68),
    r'+'                    : ('cmr10',   76),
    r'0'                    : ('cmr10',   40),
    r'1'                    : ('cmr10',  100),
    r'2'                    : ('cmr10',   49),
    r'3'                    : ('cmr10',  110),
    r'4'                    : ('cmr10',   59),
    r'5'                    : ('cmr10',  120),
    r'6'                    : ('cmr10',   69),
    r'7'                    : ('cmr10',  127),
    r'8'                    : ('cmr10',   77),
    r'9'                    : ('cmr10',   22),
    r':'                    : ('cmr10',   85),
    r';'                    : ('cmr10',   31),
    r'='                    : ('cmr10',   41),
    r'\leftbracket'         : ('cmr10',   62),
    r'['                    : ('cmr10',   62),
    r'\rightbracket'        : ('cmr10',   72),
    r']'                    : ('cmr10',   72),

    # these are mathml names, I think.  I'm just using them for the
    # tex methods noted
    r'\circumflexaccent'    : ('cmr10',   124), # for \hat
    r'\combiningbreve'      : ('cmr10',   81),  # for \breve
    r'\combiningoverline'   : ('cmr10',   131),  # for \bar
    r'\combininggraveaccent' : ('cmr10', 114), # for \grave
    r'\combiningacuteaccent' : ('cmr10', 63), # for \accute
    r'\combiningdiaeresis' : ('cmr10', 91), # for \ddot
    r'\combiningtilde' : ('cmr10', 75), # for \tilde
    r'\combiningrightarrowabove' : ('cmmi10', 110), # for \vec
    r'\combiningdotabove' : ('cmr10', 26), # for \dot

    r'\leftarrow'           : ('cmsy10',  10),
    r'\uparrow'             : ('cmsy10',  25),
    r'\downarrow'           : ('cmsy10',  28),
    r'\leftrightarrow'      : ('cmsy10',  24),
    r'\nearrow'             : ('cmsy10',  99),
    r'\searrow'             : ('cmsy10',  57),
    r'\simeq'               : ('cmsy10', 108),
    r'\Leftarrow'           : ('cmsy10', 104),
    r'\Rightarrow'          : ('cmsy10', 112),
    r'\Uparrow'             : ('cmsy10',  60),
    r'\Downarrow'           : ('cmsy10',  68),
    r'\Leftrightarrow'      : ('cmsy10',  51),
    r'\nwarrow'             : ('cmsy10',  65),
    r'\swarrow'             : ('cmsy10', 116),
    r'\propto'              : ('cmsy10',  15),
    r'\prime'               : ('cmsy10',  73),
    r'\infty'               : ('cmsy10',  32),
    r'\in'                  : ('cmsy10',  59),
    r'\ni'                  : ('cmsy10', 122),
    r'\bigtriangleup'       : ('cmsy10',  80),
    r'\bigtriangledown'     : ('cmsy10', 132),
    r'\slash'               : ('cmsy10',  87),
    r'\forall'              : ('cmsy10',  21),
    r'\exists'              : ('cmsy10',   5),
    r'\neg'                 : ('cmsy10',  20),
    r'\emptyset'            : ('cmsy10',  33),
    r'\Re'                  : ('cmsy10',  95),
    r'\Im'                  : ('cmsy10',  52),
    r'\top'                 : ('cmsy10', 100),
    r'\bot'                 : ('cmsy10',  11),
    r'\aleph'               : ('cmsy10',  26),
    r'\cup'                 : ('cmsy10',   6),
    r'\cap'                 : ('cmsy10',  19),
    r'\uplus'               : ('cmsy10',  58),
    r'\wedge'               : ('cmsy10',  43),
    r'\vee'                 : ('cmsy10',  96),
    r'\vdash'               : ('cmsy10', 109),
    r'\dashv'               : ('cmsy10',  66),
    r'\lfloor'              : ('cmsy10', 117),
    r'\rfloor'              : ('cmsy10',  74),
    r'\lceil'               : ('cmsy10', 123),
    r'\rceil'               : ('cmsy10',  81),
    r'\lbrace'              : ('cmsy10',  92),
    r'\rbrace'              : ('cmsy10', 105),
    r'\langle'              : ('cmsy10',   3),
    r'\rangle'              : ('cmsy10',  88),
    r'\mid'                 : ('cmsy10',  47),
    r'\vert'                : ('cmsy10',  47),
    r'\Vert'                : ('cmsy10',  44),
    r'\updownarrow'         : ('cmsy10',  94),
    r'\Updownarrow'         : ('cmsy10',  53),
    r'\backslash'           : ('cmsy10', 126),
    r'\wr'                  : ('cmsy10', 101),
    r'\nabla'               : ('cmsy10', 110),
    r'\sqcup'               : ('cmsy10',  67),
    r'\sqcap'               : ('cmsy10', 118),
    r'\sqsubseteq'          : ('cmsy10',  75),
    r'\sqsupseteq'          : ('cmsy10', 124),
    r'\S'                   : ('cmsy10', 129),
    r'\dag'                 : ('cmsy10',  71),
    r'\ddag'                : ('cmsy10', 127),
    r'\P'                   : ('cmsy10', 130),
    r'\clubsuit'            : ('cmsy10',  18),
    r'\diamondsuit'         : ('cmsy10',  34),
    r'\heartsuit'           : ('cmsy10',  22),
    r'-'                    : ('cmsy10',  17),
    r'\cdot'                : ('cmsy10',  78),
    r'\times'               : ('cmsy10',  13),
    r'*'                    : ('cmsy10',   9),
    r'\ast'                 : ('cmsy10',   9),
    r'\div'                 : ('cmsy10',  31),
    r'\diamond'             : ('cmsy10',  48),
    r'\pm'                  : ('cmsy10',   8),
    r'\mp'                  : ('cmsy10',  98),
    r'\oplus'               : ('cmsy10',  16),
    r'\ominus'              : ('cmsy10',  56),
    r'\otimes'              : ('cmsy10',  30),
    r'\oslash'              : ('cmsy10', 107),
    r'\odot'                : ('cmsy10',  64),
    r'\bigcirc'             : ('cmsy10', 115),
    r'\circ'                : ('cmsy10',  72),
    r'\bullet'              : ('cmsy10',  84),
    r'\asymp'               : ('cmsy10', 121),
    r'\equiv'               : ('cmsy10',  35),
    r'\subseteq'            : ('cmsy10', 103),
    r'\supseteq'            : ('cmsy10',  42),
    r'\leq'                 : ('cmsy10',  14),
    r'\geq'                 : ('cmsy10',  29),
    r'\preceq'              : ('cmsy10',  79),
    r'\succeq'              : ('cmsy10', 131),
    r'\sim'                 : ('cmsy10',  27),
    r'\approx'              : ('cmsy10',  23),
    r'\subset'              : ('cmsy10',  50),
    r'\supset'              : ('cmsy10',  86),
    r'\ll'                  : ('cmsy10',  85),
    r'\gg'                  : ('cmsy10',  40),
    r'\prec'                : ('cmsy10',  93),
    r'\succ'                : ('cmsy10',  49),
    r'\rightarrow'          : ('cmsy10',  12),
    r'\spadesuit'           : ('cmsy10',   7),
    }

# the kerning dictionary in design space units
cmkern = {
    'cmr10' :
    {
        ('A', 't') : -0.027779,
        ('A', 'C') : -0.027779,
        ('A', 'O') : -0.027779,
        ('A', 'G') : -0.027779,
        ('A', 'U') : -0.027779,
        ('A', 'Q') : -0.027779,
        ('A', 'T') : -0.083334,
        ('A', 'Y') : -0.083334,
        ('A', 'V') : -0.111112,
        ('A', 'W') : -0.111112,
        ('D', 'X') : -0.027779,
        ('D', 'W') : -0.027779,
        ('D', 'A') : -0.027779,
        ('D', 'V') : -0.027779,
        ('D', 'Y') : -0.027779,
        ('F', 'o') : -0.083334,
        ('F', 'e') : -0.083334,
        ('F', 'u') : -0.083334,
        ('F', 'r') : -0.083334,
        ('F', 'a') : -0.083334,
        ('F', 'A') : -0.111112,
        ('F', 'O') : -0.027779,
        ('F', 'C') : -0.027779,
        ('F', 'G') : -0.027779,
        ('F', 'Q') : -0.027779,
        ('I', 'I') : 0.027779,
        ('K', 'O') : -0.027779,
        ('K', 'C') : -0.027779,
        ('K', 'G') : -0.027779,
        ('K', 'Q') : -0.027779,
        ('L', 'T') : -0.083334,
        ('L', 'Y') : -0.083334,
        ('L', 'V') : -0.111112,
        ('L', 'W') : -0.111112,
        ('O', 'X') : -0.027779,
        ('O', 'W') : -0.027779,
        ('O', 'A') : -0.027779,
        ('O', 'V') : -0.027779,
        ('O', 'Y') : -0.027779,
        ('P', 'A') : -0.083334,
        ('P', 'o') : -0.027779,
        ('P', 'e') : -0.027779,
        ('P', 'a') : -0.027779,
        ('R', 't') : -0.027779,
        ('R', 'C') : -0.027779,
        ('R', 'O') : -0.027779,
        ('R', 'G') : -0.027779,
        ('R', 'U') : -0.027779,
        ('R', 'Q') : -0.027779,
        ('R', 'T') : -0.083334,
        ('R', 'Y') : -0.083334,
        ('R', 'V') : -0.111112,
        ('R', 'W') : -0.111112,
        ('T', 'y') : -0.027779,
        ('T', 'e') : -0.083334,
        ('T', 'o') : -0.083334,
        ('T', 'r') : -0.083334,
        ('T', 'a') : -0.083334,
        ('T', 'A') : -0.083334,
        ('T', 'u') : -0.083334,
        ('V', 'o') : -0.083334,
        ('V', 'e') : -0.083334,
        ('V', 'u') : -0.083334,
        ('V', 'r') : -0.083334,
        ('V', 'a') : -0.083334,
        ('V', 'A') : -0.111112,
        ('V', 'O') : -0.027779,
        ('V', 'C') : -0.027779,
        ('V', 'G') : -0.027779,
        ('V', 'Q') : -0.027779,
        ('W', 'o') : -0.083334,
        ('W', 'e') : -0.083334,
        ('W', 'u') : -0.083334,
        ('W', 'r') : -0.083334,
        ('W', 'a') : -0.083334,
        ('W', 'A') : -0.111112,
        ('W', 'O') : -0.027779,
        ('W', 'C') : -0.027779,
        ('W', 'G') : -0.027779,
        ('W', 'Q') : -0.027779,
        ('X', 'O') : -0.027779,
        ('X', 'C') : -0.027779,
        ('X', 'G') : -0.027779,
        ('X', 'Q') : -0.027779,
        ('Y', 'e') : -0.083334,
        ('Y', 'o') : -0.083334,
        ('Y', 'r') : -0.083334,
        ('Y', 'a') : -0.083334,
        ('Y', 'A') : -0.083334,
        ('Y', 'u') : -0.083334,
        ('a', 'v') : -0.027779,
        ('a', 'j') : 0.055555,
        ('a', 'y') : -0.027779,
        ('a', 'w') : -0.027779,
        ('b', 'e') : 0.027779,
        ('b', 'o') : 0.027779,
        ('b', 'x') : -0.027779,
        ('b', 'd') : 0.027779,
        ('b', 'c') : 0.027779,
        ('b', 'q') : 0.027779,
        ('b', 'v') : -0.027779,
        ('b', 'j') : 0.055555,
        ('b', 'y') : -0.027779,
        ('b', 'w') : -0.027779,
        ('c', 'h') : -0.027779,
        ('c', 'k') : -0.027779,
        ('g', 'j') : 0.027779,
        ('h', 't') : -0.027779,
        ('h', 'u') : -0.027779,
        ('h', 'b') : -0.027779,
        ('h', 'y') : -0.027779,
        ('h', 'v') : -0.027779,
        ('h', 'w') : -0.027779,
        ('k', 'a') : -0.055555,
        ('k', 'e') : -0.027779,
        ('k', 'a') : -0.027779,
        ('k', 'o') : -0.027779,
        ('k', 'c') : -0.027779,
        ('m', 't') : -0.027779,
        ('m', 'u') : -0.027779,
        ('m', 'b') : -0.027779,
        ('m', 'y') : -0.027779,
        ('m', 'v') : -0.027779,
        ('m', 'w') : -0.027779,
        ('n', 't') : -0.027779,
        ('n', 'u') : -0.027779,
        ('n', 'b') : -0.027779,
        ('n', 'y') : -0.027779,
        ('n', 'v') : -0.027779,
        ('n', 'w') : -0.027779,
        ('o', 'e') : 0.027779,
        ('o', 'o') : 0.027779,
        ('o', 'x') : -0.027779,
        ('o', 'd') : 0.027779,
        ('o', 'c') : 0.027779,
        ('o', 'q') : 0.027779,
        ('o', 'v') : -0.027779,
        ('o', 'j') : 0.055555,
        ('o', 'y') : -0.027779,
        ('o', 'w') : -0.027779,
        ('p', 'e') : 0.027779,
        ('p', 'o') : 0.027779,
        ('p', 'x') : -0.027779,
        ('p', 'd') : 0.027779,
        ('p', 'c') : 0.027779,
        ('p', 'q') : 0.027779,
        ('p', 'v') : -0.027779,
        ('p', 'j') : 0.055555,
        ('p', 'y') : -0.027779,
        ('p', 'w') : -0.027779,
        ('t', 'y') : -0.027779,
        ('t', 'w') : -0.027779,
        ('u', 'w') : -0.027779,
        ('v', 'a') : -0.055555,
        ('v', 'e') : -0.027779,
        ('v', 'a') : -0.027779,
        ('v', 'o') : -0.027779,
        ('v', 'c') : -0.027779,
        ('w', 'e') : -0.027779,
        ('w', 'a') : -0.027779,
        ('w', 'o') : -0.027779,
        ('w', 'c') : -0.027779,
        ('y', 'o') : -0.027779,
        ('y', 'e') : -0.027779,
        ('y', 'a') : -0.027779,
        },
    'cmex10' : {},
    'cmtt10' : {},
    'cmsy10' : {},
    'cmmi10' :
    {
    ('9', 'A') : -0.055555,
    ('9', 'M') : -0.055555,
    ('9', 'N') : -0.055555,
    ('9', 'Y') : 0.055555,
    ('9', 'Z') : -0.055555,
    ('d', 'Y') : 0.055555,
    ('d', 'Z') : -0.055555,
    ('d', 'j') : -0.111112,
    ('d', 'f') : -0.166667,
    },
    }
ams_type1 = {
    r'\Leftbracket'       : ( 'cmex10', '02'),
    r'\Rightbracket'      : ( 'cmex10', '03'),
    r'\Leftbrace'         : ( 'cmex10', '08'),
    r'\leftbrace'         : ( 'cmex10', '08'),
    '{'                   : ( 'cmex10', '08'),
    r'\Rightbrace'        : ( 'cmex10', '09'),
    r'\rightbrace'        : ( 'cmex10', '09'),
    '}'                   : ( 'cmex10', '09'),
    r'\Leftparen'         : ( 'cmex10', '10'),
    r'\Rightparen'        : ( 'cmex10', '11'),
    r'\LEFTparen'         : ( 'cmex10', '20'),
    r'\RIGHTparen'        : ( 'cmex10', '21'),
    r'\LEFTbracket'       : ( 'cmex10', '22'),
    r'\RIGHTbracket'      : ( 'cmex10', '23'),
    '6'                   : ( 'cmex10', '26'),
    '('                   : ( 'cmex10', '28'),
    r'\LEFTbrace'         : ( 'cmex10', '28'),
    r'\leftparen'         : ( 'cmex10', '28'),
    ')'                   : ( 'cmex10', '29'),
    r'\RIGHTbrace'        : ( 'cmex10', '29'),
    r'\rightparen'        : ( 'cmex10', '29'),
    r'\LEFTangle'         : ( 'cmex10', '2A'),
    '+'                   : ( 'cmex10', '2B'),
    '0'                   : ( 'cmex10', '30'),
    '1'                   : ( 'cmex10', '31'),
    '2'                   : ( 'cmex10', '32'),
    '3'                   : ( 'cmex10', '33'),
    '4'                   : ( 'cmex10', '34'),
    '5'                   : ( 'cmex10', '35'),
    '7'                   : ( 'cmex10', '37'),
    '8'                   : ( 'cmex10', '38'),
    '9'                   : ( 'cmex10', '39'),
    ':'                   : ( 'cmex10', '3A'),
    ';'                   : ( 'cmex10', '3B'),
    '='                   : ( 'cmex10', '3D'),
    r'\leftangle'         : ( 'cmex10', '44'),
    r'\rightangle'        : ( 'cmex10', '45'),
    r'\oint'              : ( 'cmex10', '49'),
    r'\bigodot'           : ( 'cmex10', '4B'),
    r'\bigoplus'          : ( 'cmex10', '4D'),
    r'\bigotimes'         : ( 'cmex10', '4F'),
    r'\sum'               : ( 'cmex10', '58'),
    r'\prod'              : ( 'cmex10', '59'),
    r'\int'               : ( 'cmex10', '5A'),
    '['                   : ( 'cmex10', '5B'),
    r'\bigcup'            : ( 'cmex10', '5B'),
    r'\leftbracket'       : ( 'cmex10', '5B'),
    r'\bigcap'            : ( 'cmex10', '5C'),
    r'\biguplus'          : ( 'cmex10', '5D'),
    r'\rightbracket'      : ( 'cmex10', '5D'),
    ']'                   : ( 'cmex10', '5D'),
    r'\bigwedge'          : ( 'cmex10', '5E'),
    r'\bigvee'            : ( 'cmex10', '5F'),
    r'\coprod'            : ( 'cmex10', '61'),
    r'\Sqrt'              : ( 'cmex10', '70'),
    r'\sqrt'              : ( 'cmex10', '70'),
    r'\SQRT'              : ( 'cmex10', '72'),
    r'\Sigma'             : ( 'cmmi10', '06'),
    r'\Upsilon'           : ( 'cmmi10', '07'),
    r'\Phi'               : ( 'cmmi10', '08'),
    r'\Psi'               : ( 'cmmi10', '09'),
    r'\alpha'             : ( 'cmmi10', '0B'),
    r'\beta'              : ( 'cmmi10', '0C'),
    r'\gamma'             : ( 'cmmi10', '0D'),
    r'\delta'             : ( 'cmmi10', '0E'),
    r'\epsilon'           : ( 'cmmi10', '0F'),
    r'\zeta'              : ( 'cmmi10', '10'),
    r'\eta'               : ( 'cmmi10', '11'),
    r'\theta'             : ( 'cmmi10', '12'),
    r'\iota'              : ( 'cmmi10', '13'),
    r'\lambda'            : ( 'cmmi10', '15'),
    r'\mu'                : ( 'cmmi10', '16'),
    r'\nu'                : ( 'cmmi10', '17'),
    r'\xi'                : ( 'cmmi10', '18'),
    r'\pi'                : ( 'cmmi10', '19'),
    r'\kappa'             : ( 'cmmi10', '19'),    
    r'\rho'               : ( 'cmmi10', '1A'),
    r'\sigma'             : ( 'cmmi10', '1B'),
    r'\tau'               : ( 'cmmi10', '1C'),
    r'\upsilon'           : ( 'cmmi10', '1D'),
    r'\phi'               : ( 'cmmi10', '1E'),
    r'\chi'               : ( 'cmmi10', '1F'),
    r'\psi'               : ( 'cmmi10', '20'),
    r'\omega'             : ( 'cmmi10', '21'),
    r'\varepsilon'        : ( 'cmmi10', '22'),
    r'\vartheta'          : ( 'cmmi10', '23'),
    r'\varrho'            : ( 'cmmi10', '25'),
    r'\varsigma'          : ( 'cmmi10', '26'),    
    r'\varphi'            : ( 'cmmi10', '27'),
    r'\leftharpoonup'     : ( 'cmmi10', '28'),
    r'\leftharpoondown'   : ( 'cmmi10', '29'),
    r'\rightharpoonup'    : ( 'cmmi10', '2A'),
    r'\rightharpoondown'  : ( 'cmmi10', '2B'),
    r'\triangleright'     : ( 'cmmi10', '2E'),
    r'\triangleleft'      : ( 'cmmi10', '2F'),
    '.'                   : ( 'cmmi10', '3A'),
    ','                   : ( 'cmmi10', '3B'),
    '<'                   : ( 'cmmi10', '3C'),
    '/'                   : ( 'cmmi10', '3D'),
    '>'                   : ( 'cmmi10', '3E'),
    r'\flat'              : ( 'cmmi10', '5B'),
    r'\natural'           : ( 'cmmi10', '5C'),
    r'\sharp'             : ( 'cmmi10', '5D'),
    r'\smile'             : ( 'cmmi10', '5E'),
    r'\frown'             : ( 'cmmi10', '5F'),
    r'\ell'               : ( 'cmmi10', '60'),
    r'\imath'             : ( 'cmmi10', '7B'),    
    r'\jmath'             : ( 'cmmi10', '7C'),
    r'\wp'                : ( 'cmmi10', '7D'),    
    r'\Gamma'             : ( 'cmr10', '00'),
    r'\Delta'             : ( 'cmr10', '01'),
    r'\Theta'             : ( 'cmr10', '02'),
    r'\Lambda'            : ( 'cmr10', '03'),
    r'\Xi'                : ( 'cmr10', '04'),
    r'\Pi'                : ( 'cmr10', '05'),
    r'\Omega'             : ( 'cmr10', '0A'),
    '-'                   : ( 'cmsy10', '00'),
    r'\cdot'              : ( 'cmsy10', '01'),        
    r'\times'             : ( 'cmsy10', '02'),
    '*'                   : ( 'cmsy10', '03'),
    r'\ast'               : ( 'cmsy10', '03'),        
    r'\div'               : ( 'cmsy10', '04'),
    r'\diamond'           : ( 'cmsy10', '05'),
    r'\pm'                : ( 'cmsy10', '06'),
    r'\mp'                : ( 'cmsy10', '07'),    
    r'\oplus'             : ( 'cmsy10', '08'),
    r'\ominus'            : ( 'cmsy10', '09'),
    r'\otimes'            : ( 'cmsy10', '0A'),
    r'\oslash'            : ( 'cmsy10', '0B'),
    r'\odot'              : ( 'cmsy10', '0C'),
    r'\bigcirc'           : ( 'cmsy10', '0D'),
    r'\circ'              : ( 'cmsy10', '0E'),    
    r'\bullet'            : ( 'cmsy10', '0F'),
    r'\simeq'             : ( 'cmsy10', '10'),
    r'\asymp'             : ( 'cmsy10', '11'),
    r'\subseteq'          : ( 'cmsy10', '12'),
    r'\supseteq'          : ( 'cmsy10', '13'),
    r'\leq'               : ( 'cmsy10', '14'),
    r'\geq'               : ( 'cmsy10', '15'),
    r'\preceq'            : ( 'cmsy10', '16'),
    r'\succeq'            : ( 'cmsy10', '17'),
    r'\sim'               : ( 'cmsy10', '18'),
    r'\approx'            : ( 'cmsy10', '19'),    
    r'\subset'            : ( 'cmsy10', '1A'),
    r'\supset'            : ( 'cmsy10', '1B'),
    r'\ll'                : ( 'cmsy10', '1C'),
    r'\gg'                : ( 'cmsy10', '1D'),
    r'\prec'              : ( 'cmsy10', '1E'),
    r'\succ'              : ( 'cmsy10', '1F'),
    r'\rightarrow'        : ( 'cmsy10', '20'),
    r'\leftarrow'         : ( 'cmsy10', '21'),
    r'\uparrow'           : ( 'cmsy10', '22'),
    r'\downarrow'         : ( 'cmsy10', '23'),
    r'\leftrightarrow'    : ( 'cmsy10', '24'),
    r'\nearrow'           : ( 'cmsy10', '25'),
    r'\searrow'           : ( 'cmsy10', '26'),
    r'\Leftarrow'         : ( 'cmsy10', '28'),
    r'\Rightarrow'        : ( 'cmsy10', '29'),
    r'\Uparrow'           : ( 'cmsy10', '2A'),
    r'\Downarrow'         : ( 'cmsy10', '2B'),
    r'\Leftrightarrow'    : ( 'cmsy10', '2C'),
    r'\nwarrow'           : ( 'cmsy10', '2D'),
    r'\swarrow'           : ( 'cmsy10', '2E'),
    r'\propto'            : ( 'cmsy10', '2F'),
    r'\prime'             : ( 'cmsy10', '30'),
    r'\infty'             : ( 'cmsy10', '31'),
    r'\in'                : ( 'cmsy10', '32'),
    r'\ni'                : ( 'cmsy10', '33'),
    r'\bigtriangleup'     : ( 'cmsy10', '34'),
    r'\bigtriangledown'   : ( 'cmsy10', '35'),
    r'\slash'             : ( 'cmsy10', '36'),
    r'\forall'            : ( 'cmsy10', '38'),
    r'\exists'            : ( 'cmsy10', '39'),
    r'\neg'               : ( 'cmsy10', '3A'),
    r'\emptyset'          : ( 'cmsy10', '3B'),
    r'\Re'                : ( 'cmsy10', '3C'),
    r'\Im'                : ( 'cmsy10', '3D'),
    r'\top'               : ( 'cmsy10', '3E'),
    r'\bot'               : ( 'cmsy10', '3F'),    
    r'\aleph'             : ( 'cmsy10', '40'),
    r'\cup'               : ( 'cmsy10', '5B'),
    r'\cap'               : ( 'cmsy10', '5C'),
    r'\uplus'             : ( 'cmsy10', '5D'),
    r'\wedge'             : ( 'cmsy10', '5E'),
    r'\vee'               : ( 'cmsy10', '5F'),
    r'\vdash'             : ( 'cmsy10', '60'),
    r'\dashv'             : ( 'cmsy10', '61'),
    r'\lfloor'            : ( 'cmsy10', '62'),
    r'\rfloor'            : ( 'cmsy10', '63'),
    r'\lceil'             : ( 'cmsy10', '64'),
    r'\rceil'             : ( 'cmsy10', '65'),
    r'\lbrace'            : ( 'cmsy10', '66'),
    r'\rbrace'            : ( 'cmsy10', '67'),
    r'\langle'            : ( 'cmsy10', '68'),
    r'\rangle'            : ( 'cmsy10', '69'),
    r'\mid'               : ( 'cmsy10', '6A'),
    r'\vert'              : ( 'cmsy10', '6A'),
    r'\Vert'              : ( 'cmsy10', '6B'),
    r'\updownarrow'       : ( 'cmsy10', '6C'),
    r'\Updownarrow'       : ( 'cmsy10', '6D'),
    r'\backslash'         : ( 'cmsy10', '6E'),
    r'\wr'                : ( 'cmsy10', '6F'),
    r'\nabla'             : ( 'cmsy10', '72'),    
    r'\sqcup'             : ( 'cmsy10', '74'),
    r'\sqcap'             : ( 'cmsy10', '75'),
    r'\sqsubseteq'        : ( 'cmsy10', '76'),
    r'\sqsupseteq'        : ( 'cmsy10', '77'),
    r'\S'                 : ( 'cmsy10', '78'),
    r'\dag'               : ( 'cmsy10', '79'),
    r'\ddag'              : ( 'cmsy10', '7A'),
    r'\P'                 : ( 'cmsy10', '7B'),    
    r'\clubsuit'          : ( 'cmsy10', '7C'),
    r'\diamondsuit'       : ( 'cmsy10', '7D'),
    r'\heartsuit'         : ( 'cmsy10', '7E'),
    r'\spadesuit'         : ( 'cmsy10', '7F'),
}

"""
no mlname for \RIGHTangle
no type1 key \equiv      # could not find in ASM
no type1 key \kappa      # could not find kappa
no type1 key \RIGHTangle # could not find
"""

latex_to_standard = {
    r'\cong'            : ('psyr', 64),
    r'\Delta'           : ('psyr', 68),
    r'\Phi'             : ('psyr', 70),
    r'\Gamma'           : ('psyr', 89),
    r'\alpha'           : ('psyr', 97),
    r'\beta'            : ('psyr', 98),
    r'\chi'             : ('psyr', 99),
    r'\delta'           : ('psyr', 100),
    r'\varepsilon'      : ('psyr', 101),
    r'\phi'             : ('psyr', 102),
    r'\gamma'           : ('psyr', 103),
    r'\eta'             : ('psyr', 104),
    r'\iota'            : ('psyr', 105),
    r'\varpsi'          : ('psyr', 106),
    r'\kappa'           : ('psyr', 108),
    r'\nu'              : ('psyr', 110),
    r'\pi'              : ('psyr', 112),
    r'\theta'           : ('psyr', 113),
    r'\rho'             : ('psyr', 114),
    r'\sigma'           : ('psyr', 115),
    r'\tau'             : ('psyr', 116),
    r'\upsilon'         : ('psyr', 117),
    r'\varpi'           : ('psyr', 118),
    r'\omega'           : ('psyr', 119),
    r'\xi'              : ('psyr', 120),
    r'\psi'             : ('psyr', 121),
    r'\zeta'            : ('psyr', 122),
    r'\sim'             : ('psyr', 126),
    r'\leq'             : ('psyr', 163),
    r'\infty'           : ('psyr', 165),
    r'\clubsuit'        : ('psyr', 167),
    r'\diamondsuit'     : ('psyr', 168),
    r'\heartsuit'       : ('psyr', 169),
    r'\spadesuit'       : ('psyr', 170),
    r'\leftrightarrow'  : ('psyr', 171),
    r'\leftarrow'       : ('psyr', 172),
    r'\uparrow'         : ('psyr', 173),
    r'\rightarrow'      : ('psyr', 174),
    r'\downarrow'       : ('psyr', 175),
    r'\pm'              : ('psyr', 176),
    r'\geq'             : ('psyr', 179),
    r'\times'           : ('psyr', 180),
    r'\propto'          : ('psyr', 181),
    r'\partial'         : ('psyr', 182),
    r'\bullet'          : ('psyr', 183),
    r'\div'             : ('psyr', 184),
    r'\neq'             : ('psyr', 185),
    r'\equiv'           : ('psyr', 186),
    r'\approx'          : ('psyr', 187),
    r'\ldots'           : ('psyr', 188),
    r'\aleph'           : ('psyr', 192),
    r'\Im'              : ('psyr', 193),
    r'\Re'              : ('psyr', 194),
    r'\wp'              : ('psyr', 195),
    r'\otimes'          : ('psyr', 196),
    r'\oplus'           : ('psyr', 197),
    r'\oslash'          : ('psyr', 198),
    r'\cap'             : ('psyr', 199),
    r'\cup'             : ('psyr', 200),
    r'\supset'          : ('psyr', 201),
    r'\supseteq'        : ('psyr', 202),
    r'\subset'          : ('psyr', 204),
    r'\subseteq'        : ('psyr', 205),
    r'\in'              : ('psyr', 206),
    r'\notin'           : ('psyr', 207),
    r'\angle'           : ('psyr', 208),
    r'\nabla'           : ('psyr', 209),
    r'\textregistered'  : ('psyr', 210),
    r'\copyright'       : ('psyr', 211),
    r'\texttrademark'   : ('psyr', 212),
    r'\Pi'              : ('psyr', 213),
    r'\prod'            : ('psyr', 213),
    r'\surd'            : ('psyr', 214),
    r'\sqrt'            : ('psyr', 214),
    r'\cdot'            : ('psyr', 215),
    r'\urcorner'        : ('psyr', 216),
    r'\vee'             : ('psyr', 217),
    r'\wedge'           : ('psyr', 218),
    r'\Leftrightarrow'  : ('psyr', 219),
    r'\Leftarrow'       : ('psyr', 220),
    r'\Uparrow'         : ('psyr', 221),
    r'\Rightarrow'      : ('psyr', 222),
    r'\Downarrow'       : ('psyr', 223),
    r'\Diamond'         : ('psyr', 224),
    r'\langle'          : ('psyr', 225),
    r'\Sigma'           : ('psyr', 229),
    r'\sum'             : ('psyr', 229),

}

# Automatically generated.

type12uni = {'uni24C8': 9416,
'aring': 229,
'uni22A0': 8864,
'uni2292': 8850,
'quotedblright': 8221,
'uni03D2': 978,
'uni2215': 8725,
'uni03D0': 976,
'V': 86,
'dollar': 36,
'uni301E': 12318,
'uni03D5': 981,
'four': 52,
'uni25A0': 9632,
'uni013C': 316,
'uni013B': 315,
'uni013E': 318,
'Yacute': 221,
'uni25DE': 9694,
'uni013F': 319,
'uni255A': 9562,
'uni2606': 9734,
'uni0180': 384,
'uni22B7': 8887,
'uni044F': 1103,
'uni22B5': 8885,
'uni22B4': 8884,
'uni22AE': 8878,
'uni22B2': 8882,
'uni22B1': 8881,
'uni22B0': 8880,
'uni25CD': 9677,
'uni03CE': 974,
'uni03CD': 973,
'uni03CC': 972,
'uni03CB': 971,
'uni03CA': 970,
'uni22B8': 8888,
'uni22C9': 8905,
'uni0449': 1097,
'uni20DD': 8413,
'uni20DC': 8412,
'uni20DB': 8411,
'uni2231': 8753,
'uni25CF': 9679,
'uni306E': 12398,
'uni03D1': 977,
'uni01A1': 417,
'uni20D7': 8407,
'uni03D6': 982,
'uni2233': 8755,
'uni20D2': 8402,
'uni20D1': 8401,
'uni20D0': 8400,
'P': 80,
'uni22BE': 8894,
'uni22BD': 8893,
'uni22BC': 8892,
'uni22BB': 8891,
'underscore': 95,
'uni03C8': 968,
'uni03C7': 967,
'uni0328': 808,
'uni03C5': 965,
'uni03C4': 964,
'uni03C3': 963,
'uni03C2': 962,
'uni03C1': 961,
'uni03C0': 960,
'uni2010': 8208,
'uni0130': 304,
'uni0133': 307,
'uni0132': 306,
'uni0135': 309,
'uni0134': 308,
'uni0137': 311,
'uni0136': 310,
'uni0139': 313,
'uni0138': 312,
'uni2244': 8772,
'uni229A': 8858,
'uni2571': 9585,
'uni0278': 632,
'uni2239': 8761,
'p': 112,
'uni3019': 12313,
'uni25CB': 9675,
'uni03DB': 987,
'uni03DC': 988,
'uni03DA': 986,
'uni03DF': 991,
'uni03DD': 989,
'uni013D': 317,
'uni220A': 8714,
'uni220C': 8716,
'uni220B': 8715,
'uni220E': 8718,
'uni220D': 8717,
'uni220F': 8719,
'uni22CC': 8908,
'Otilde': 213,
'uni25E5': 9701,
'uni2736': 10038,
'perthousand': 8240,
'zero': 48,
'uni279B': 10139,
'dotlessi': 305,
'uni2279': 8825,
'Scaron': 352,
'zcaron': 382,
'uni21D8': 8664,
'egrave': 232,
'uni0271': 625,
'uni01AA': 426,
'uni2332': 9010,
'section': 167,
'uni25E4': 9700,
'Icircumflex': 206,
'ntilde': 241,
'uni041E': 1054,
'ampersand': 38,
'uni041C': 1052,
'uni041A': 1050,
'uni22AB': 8875,
'uni21DB': 8667,
'dotaccent': 729,
'uni0416': 1046,
'uni0417': 1047,
'uni0414': 1044,
'uni0415': 1045,
'uni0412': 1042,
'uni0413': 1043,
'degree': 176,
'uni0411': 1041,
'K': 75,
'uni25EB': 9707,
'uni25EF': 9711,
'uni0418': 1048,
'uni0419': 1049,
'uni2263': 8803,
'uni226E': 8814,
'uni2251': 8785,
'uni02C8': 712,
'uni2262': 8802,
'acircumflex': 226,
'uni22B3': 8883,
'uni2261': 8801,
'uni2394': 9108,
'Aring': 197,
'uni2260': 8800,
'uni2254': 8788,
'uni0436': 1078,
'uni2267': 8807,
'k': 107,
'uni22C8': 8904,
'uni226A': 8810,
'uni231F': 8991,
'smalltilde': 732,
'uni2201': 8705,
'uni2200': 8704,
'uni2203': 8707,
'uni02BD': 701,
'uni2205': 8709,
'uni2204': 8708,
'Agrave': 192,
'uni2206': 8710,
'uni2209': 8713,
'uni2208': 8712,
'uni226D': 8813,
'uni2264': 8804,
'uni263D': 9789,
'uni2258': 8792,
'uni02D3': 723,
'uni02D2': 722,
'uni02D1': 721,
'uni02D0': 720,
'uni25E1': 9697,
'divide': 247,
'uni02D5': 725,
'uni02D4': 724,
'ocircumflex': 244,
'uni2524': 9508,
'uni043A': 1082,
'uni24CC': 9420,
'asciitilde': 126,
'uni22B9': 8889,
'uni24D2': 9426,
'uni211E': 8478,
'uni211D': 8477,
'uni24DD': 9437,
'uni211A': 8474,
'uni211C': 8476,
'uni211B': 8475,
'uni25C6': 9670,
'uni017F': 383,
'uni017A': 378,
'uni017C': 380,
'uni017B': 379,
'uni0346': 838,
'uni22F1': 8945,
'uni22F0': 8944,
'two': 50,
'uni2298': 8856,
'uni24D1': 9425,
'E': 69,
'uni025D': 605,
'scaron': 353,
'uni2322': 8994,
'uni25E3': 9699,
'uni22BF': 8895,
'F': 70,
'uni0440': 1088,
'uni255E': 9566,
'uni22BA': 8890,
'uni0175': 373,
'uni0174': 372,
'uni0177': 375,
'uni0176': 374,
'bracketleft': 91,
'uni0170': 368,
'uni0173': 371,
'uni0172': 370,
'asciicircum': 94,
'uni0179': 377,
'uni2590': 9616,
'uni25E2': 9698,
'uni2119': 8473,
'uni2118': 8472,
'uni25CC': 9676,
'f': 102,
'ordmasculine': 186,
'uni229B': 8859,
'uni22A1': 8865,
'uni2111': 8465,
'uni2110': 8464,
'uni2113': 8467,
'uni2112': 8466,
'mu': 181,
'uni2281': 8833,
'paragraph': 182,
'nine': 57,
'uni25EC': 9708,
'v': 118,
'uni040C': 1036,
'uni0113': 275,
'uni22D0': 8912,
'uni21CC': 8652,
'uni21CB': 8651,
'uni21CA': 8650,
'uni22A5': 8869,
'uni21CF': 8655,
'uni21CE': 8654,
'uni21CD': 8653,
'guilsinglleft': 8249,
'backslash': 92,
'uni2284': 8836,
'uni224E': 8782,
'uni224D': 8781,
'uni224F': 8783,
'uni224A': 8778,
'uni2287': 8839,
'uni224C': 8780,
'uni224B': 8779,
'uni21BD': 8637,
'uni2286': 8838,
'uni030F': 783,
'uni030D': 781,
'uni030E': 782,
'uni030B': 779,
'uni030C': 780,
'uni030A': 778,
'uni026E': 622,
'uni026D': 621,
'six': 54,
'uni026A': 618,
'uni026C': 620,
'uni25C1': 9665,
'uni20D6': 8406,
'uni045B': 1115,
'uni045C': 1116,
'uni256B': 9579,
'uni045A': 1114,
'uni045F': 1119,
'uni045E': 1118,
'A': 65,
'uni2569': 9577,
'uni0458': 1112,
'uni0459': 1113,
'uni0452': 1106,
'uni0453': 1107,
'uni2562': 9570,
'uni0451': 1105,
'uni0456': 1110,
'uni0457': 1111,
'uni0454': 1108,
'uni0455': 1109,
'icircumflex': 238,
'uni0307': 775,
'uni0304': 772,
'uni0305': 773,
'uni0269': 617,
'uni0268': 616,
'uni0300': 768,
'uni0301': 769,
'uni0265': 613,
'uni0264': 612,
'uni0267': 615,
'uni0266': 614,
'uni0261': 609,
'uni0260': 608,
'uni0263': 611,
'uni0262': 610,
'a': 97,
'uni2207': 8711,
'uni2247': 8775,
'uni2246': 8774,
'uni2241': 8769,
'uni2240': 8768,
'uni2243': 8771,
'uni2242': 8770,
'uni2312': 8978,
'ogonek': 731,
'uni2249': 8777,
'uni2248': 8776,
'uni3030': 12336,
'q': 113,
'uni21C2': 8642,
'uni21C1': 8641,
'uni21C0': 8640,
'uni21C7': 8647,
'uni21C6': 8646,
'uni21C5': 8645,
'uni21C4': 8644,
'uni225F': 8799,
'uni212C': 8492,
'uni21C8': 8648,
'uni2467': 9319,
'oacute': 243,
'uni028F': 655,
'uni028E': 654,
'uni026F': 623,
'uni028C': 652,
'uni028B': 651,
'uni028A': 650,
'uni2510': 9488,
'ograve': 242,
'edieresis': 235,
'uni22CE': 8910,
'uni22CF': 8911,
'uni219F': 8607,
'comma': 44,
'uni22CA': 8906,
'uni0429': 1065,
'uni03C6': 966,
'uni0427': 1063,
'uni0426': 1062,
'uni0425': 1061,
'uni0424': 1060,
'uni0423': 1059,
'uni0422': 1058,
'uni0421': 1057,
'uni0420': 1056,
'uni2465': 9317,
'uni24D0': 9424,
'uni2464': 9316,
'uni0430': 1072,
'otilde': 245,
'uni2661': 9825,
'uni24D6': 9430,
'uni2466': 9318,
'uni24D5': 9429,
'uni219A': 8602,
'uni2518': 9496,
'uni22B6': 8886,
'uni2461': 9313,
'uni24D4': 9428,
'uni2460': 9312,
'uni24EA': 9450,
'guillemotright': 187,
'ecircumflex': 234,
'greater': 62,
'uni2011': 8209,
'uacute': 250,
'uni2462': 9314,
'L': 76,
'bullet': 8226,
'uni02A4': 676,
'uni02A7': 679,
'cedilla': 184,
'uni02A2': 674,
'uni2015': 8213,
'uni22C4': 8900,
'uni22C5': 8901,
'uni22AD': 8877,
'uni22C7': 8903,
'uni22C0': 8896,
'uni2016': 8214,
'uni22C2': 8898,
'uni22C3': 8899,
'uni24CF': 9423,
'uni042F': 1071,
'uni042E': 1070,
'uni042D': 1069,
'ydieresis': 255,
'l': 108,
'logicalnot': 172,
'uni24CA': 9418,
'uni0287': 647,
'uni0286': 646,
'uni0285': 645,
'uni0284': 644,
'uni0283': 643,
'uni0282': 642,
'uni0281': 641,
'uni027C': 636,
'uni2664': 9828,
'exclamdown': 161,
'uni25C4': 9668,
'uni0289': 649,
'uni0288': 648,
'uni039A': 922,
'endash': 8211,
'uni2640': 9792,
'uni20E4': 8420,
'uni0473': 1139,
'uni20E1': 8417,
'uni2642': 9794,
'uni03B8': 952,
'uni03B9': 953,
'agrave': 224,
'uni03B4': 948,
'uni03B5': 949,
'uni03B6': 950,
'uni03B7': 951,
'uni03B0': 944,
'uni03B1': 945,
'uni03B2': 946,
'uni03B3': 947,
'uni2555': 9557,
'Adieresis': 196,
'germandbls': 223,
'Odieresis': 214,
'space': 32,
'uni0126': 294,
'uni0127': 295,
'uni0124': 292,
'uni0125': 293,
'uni0122': 290,
'uni0123': 291,
'uni0120': 288,
'uni0121': 289,
'quoteright': 8217,
'uni2560': 9568,
'uni2556': 9558,
'ucircumflex': 251,
'uni2561': 9569,
'uni2551': 9553,
'uni25B2': 9650,
'uni2550': 9552,
'uni2563': 9571,
'uni2553': 9555,
'G': 71,
'uni2564': 9572,
'uni2552': 9554,
'quoteleft': 8216,
'uni2565': 9573,
'uni2572': 9586,
'uni2568': 9576,
'uni2566': 9574,
'W': 87,
'uni214A': 8522,
'uni012F': 303,
'uni012D': 301,
'uni012E': 302,
'uni012B': 299,
'uni012C': 300,
'uni255C': 9564,
'uni012A': 298,
'uni2289': 8841,
'Q': 81,
'uni2320': 8992,
'uni2321': 8993,
'g': 103,
'uni03BD': 957,
'uni03BE': 958,
'uni03BF': 959,
'uni2282': 8834,
'uni2285': 8837,
'uni03BA': 954,
'uni03BB': 955,
'uni03BC': 956,
'uni2128': 8488,
'uni25B7': 9655,
'w': 119,
'uni0302': 770,
'uni03DE': 990,
'uni25DA': 9690,
'uni0303': 771,
'uni0463': 1123,
'uni0462': 1122,
'uni3018': 12312,
'uni2514': 9492,
'question': 63,
'uni25B3': 9651,
'uni24E1': 9441,
'one': 49,
'uni200A': 8202,
'uni2278': 8824,
'ring': 730,
'uni0195': 405,
'figuredash': 8210,
'uni22EC': 8940,
'uni0339': 825,
'uni0338': 824,
'uni0337': 823,
'uni0336': 822,
'uni0335': 821,
'uni0333': 819,
'uni0332': 818,
'uni0331': 817,
'uni0330': 816,
'uni01C1': 449,
'uni01C0': 448,
'uni01C3': 451,
'uni01C2': 450,
'uni2353': 9043,
'uni0308': 776,
'uni2218': 8728,
'uni2219': 8729,
'uni2216': 8726,
'uni2217': 8727,
'uni2214': 8724,
'uni0309': 777,
'uni2609': 9737,
'uni2213': 8723,
'uni2210': 8720,
'uni2211': 8721,
'uni2245': 8773,
'B': 66,
'uni25D6': 9686,
'iacute': 237,
'uni02E6': 742,
'uni02E7': 743,
'uni02E8': 744,
'uni02E9': 745,
'uni221D': 8733,
'uni221E': 8734,
'Ydieresis': 376,
'uni221C': 8732,
'uni22D7': 8919,
'uni221A': 8730,
'R': 82,
'uni24DC': 9436,
'uni033F': 831,
'uni033E': 830,
'uni033C': 828,
'uni033B': 827,
'uni033A': 826,
'b': 98,
'uni228A': 8842,
'uni22DB': 8923,
'uni2554': 9556,
'uni046B': 1131,
'uni046A': 1130,
'r': 114,
'uni24DB': 9435,
'Ccedilla': 199,
'minus': 8722,
'uni24DA': 9434,
'uni03F0': 1008,
'uni03F1': 1009,
'uni20AC': 8364,
'uni2276': 8822,
'uni24C0': 9408,
'uni0162': 354,
'uni0163': 355,
'uni011E': 286,
'uni011D': 285,
'uni011C': 284,
'uni011B': 283,
'uni0164': 356,
'uni0165': 357,
'Lslash': 321,
'uni0168': 360,
'uni0169': 361,
'uni25C9': 9673,
'uni02E5': 741,
'uni21C3': 8643,
'uni24C4': 9412,
'uni24E2': 9442,
'uni2277': 8823,
'uni013A': 314,
'uni2102': 8450,
'Uacute': 218,
'uni2317': 8983,
'uni2107': 8455,
'uni221F': 8735,
'yacute': 253,
'uni3012': 12306,
'Ucircumflex': 219,
'uni015D': 349,
'quotedbl': 34,
'uni25D9': 9689,
'uni2280': 8832,
'uni22AF': 8879,
'onehalf': 189,
'uni221B': 8731,
'Thorn': 222,
'uni2226': 8742,
'M': 77,
'uni25BA': 9658,
'uni2463': 9315,
'uni2336': 9014,
'eight': 56,
'uni2236': 8758,
'multiply': 215,
'uni210C': 8460,
'uni210A': 8458,
'uni21C9': 8649,
'grave': 96,
'uni210E': 8462,
'uni0117': 279,
'uni016C': 364,
'uni0115': 277,
'uni016A': 362,
'uni016F': 367,
'uni0112': 274,
'uni016D': 365,
'uni016E': 366,
'Ocircumflex': 212,
'uni2305': 8965,
'm': 109,
'uni24DF': 9439,
'uni0119': 281,
'uni0118': 280,
'uni20A3': 8355,
'uni20A4': 8356,
'uni20A7': 8359,
'uni2288': 8840,
'uni24C3': 9411,
'uni251C': 9500,
'uni228D': 8845,
'uni222F': 8751,
'uni222E': 8750,
'uni222D': 8749,
'uni222C': 8748,
'uni222B': 8747,
'uni222A': 8746,
'uni255B': 9563,
'Ugrave': 217,
'uni24DE': 9438,
'guilsinglright': 8250,
'uni250A': 9482,
'Ntilde': 209,
'uni0279': 633,
'questiondown': 191,
'uni256C': 9580,
'Atilde': 195,
'uni0272': 626,
'uni0273': 627,
'uni0270': 624,
'ccedilla': 231,
'uni0276': 630,
'uni0277': 631,
'uni0274': 628,
'uni0275': 629,
'uni2252': 8786,
'uni041F': 1055,
'uni2250': 8784,
'Z': 90,
'uni2256': 8790,
'uni2257': 8791,
'copyright': 169,
'uni2255': 8789,
'uni043D': 1085,
'uni043E': 1086,
'uni043F': 1087,
'yen': 165,
'uni041D': 1053,
'uni043B': 1083,
'uni043C': 1084,
'uni21B0': 8624,
'uni21B1': 8625,
'uni21B2': 8626,
'uni21B3': 8627,
'uni21B4': 8628,
'uni21B5': 8629,
'uni21B6': 8630,
'uni21B7': 8631,
'uni21B8': 8632,
'Eacute': 201,
'uni2311': 8977,
'uni2310': 8976,
'uni228F': 8847,
'uni25DB': 9691,
'uni21BA': 8634,
'uni21BB': 8635,
'uni21BC': 8636,
'uni2017': 8215,
'uni21BE': 8638,
'uni21BF': 8639,
'uni231C': 8988,
'H': 72,
'uni0293': 659,
'uni2202': 8706,
'uni22A4': 8868,
'uni231E': 8990,
'uni2232': 8754,
'uni225B': 8795,
'uni225C': 8796,
'uni24D9': 9433,
'uni225A': 8794,
'uni0438': 1080,
'uni0439': 1081,
'uni225D': 8797,
'uni225E': 8798,
'uni0434': 1076,
'X': 88,
'uni007F': 127,
'uni0437': 1079,
'Idieresis': 207,
'uni0431': 1073,
'uni0432': 1074,
'uni0433': 1075,
'uni22AC': 8876,
'uni22CD': 8909,
'uni25A3': 9635,
'bar': 124,
'uni24BB': 9403,
'uni037E': 894,
'uni027B': 635,
'h': 104,
'uni027A': 634,
'uni027F': 639,
'uni027D': 637,
'uni027E': 638,
'uni2227': 8743,
'uni2004': 8196,
'uni2225': 8741,
'uni2224': 8740,
'uni2223': 8739,
'uni2222': 8738,
'uni2221': 8737,
'uni2220': 8736,
'x': 120,
'uni2323': 8995,
'uni2559': 9561,
'uni2558': 9560,
'uni2229': 8745,
'uni2228': 8744,
'udieresis': 252,
'uni029D': 669,
'ordfeminine': 170,
'uni22CB': 8907,
'uni233D': 9021,
'uni0428': 1064,
'uni24C6': 9414,
'uni22DD': 8925,
'uni24C7': 9415,
'uni015C': 348,
'uni015B': 347,
'uni015A': 346,
'uni22AA': 8874,
'uni015F': 351,
'uni015E': 350,
'braceleft': 123,
'uni24C5': 9413,
'uni0410': 1040,
'uni03AA': 938,
'uni24C2': 9410,
'uni03AC': 940,
'uni03AB': 939,
'macron': 175,
'uni03AD': 941,
'uni03AF': 943,
'uni0294': 660,
'uni0295': 661,
'uni0296': 662,
'uni0297': 663,
'uni0290': 656,
'uni0291': 657,
'uni0292': 658,
'atilde': 227,
'Acircumflex': 194,
'uni2370': 9072,
'uni24C1': 9409,
'uni0298': 664,
'uni0299': 665,
'Oslash': 216,
'uni029E': 670,
'C': 67,
'quotedblleft': 8220,
'uni029B': 667,
'uni029C': 668,
'uni03A9': 937,
'uni03A8': 936,
'S': 83,
'uni24C9': 9417,
'uni03A1': 929,
'uni03A0': 928,
'exclam': 33,
'uni03A5': 933,
'uni03A4': 932,
'uni03A7': 935,
'Zcaron': 381,
'uni2133': 8499,
'uni2132': 8498,
'uni0159': 345,
'uni0158': 344,
'uni2137': 8503,
'uni2005': 8197,
'uni2135': 8501,
'uni2134': 8500,
'uni02BA': 698,
'uni2033': 8243,
'uni0151': 337,
'uni0150': 336,
'uni0157': 343,
'equal': 61,
'uni0155': 341,
'uni0154': 340,
's': 115,
'uni233F': 9023,
'eth': 240,
'uni24BE': 9406,
'uni21E9': 8681,
'uni2060': 8288,
'Egrave': 200,
'uni255D': 9565,
'uni24CD': 9421,
'uni21E1': 8673,
'uni21B9': 8633,
'hyphen': 45,
'uni01BE': 446,
'uni01BB': 443,
'period': 46,
'igrave': 236,
'uni01BA': 442,
'uni2296': 8854,
'uni2297': 8855,
'uni2294': 8852,
'uni2295': 8853,
'colon': 58,
'uni2293': 8851,
'uni2290': 8848,
'uni2291': 8849,
'uni032D': 813,
'uni032E': 814,
'uni032F': 815,
'uni032A': 810,
'uni032B': 811,
'uni032C': 812,
'uni231D': 8989,
'Ecircumflex': 202,
'uni24D7': 9431,
'uni25DD': 9693,
'trademark': 8482,
'Aacute': 193,
'cent': 162,
'uni0445': 1093,
'uni266E': 9838,
'uni266D': 9837,
'uni266B': 9835,
'uni03C9': 969,
'uni2003': 8195,
'uni2047': 8263,
'lslash': 322,
'uni03A6': 934,
'uni2043': 8259,
'uni250C': 9484,
'uni2040': 8256,
'uni255F': 9567,
'uni24CB': 9419,
'uni0472': 1138,
'uni0446': 1094,
'uni0474': 1140,
'uni0475': 1141,
'uni2508': 9480,
'uni2660': 9824,
'uni2506': 9478,
'uni2502': 9474,
'c': 99,
'uni2500': 9472,
'N': 78,
'uni22A6': 8870,
'uni21E7': 8679,
'uni2130': 8496,
'uni2002': 8194,
'breve': 728,
'uni0442': 1090,
'Oacute': 211,
'uni229F': 8863,
'uni25C7': 9671,
'uni229D': 8861,
'uni229E': 8862,
'guillemotleft': 171,
'uni0329': 809,
'uni24E5': 9445,
'uni011F': 287,
'uni0324': 804,
'uni0325': 805,
'uni0326': 806,
'uni0327': 807,
'uni0321': 801,
'uni0322': 802,
'n': 110,
'uni2032': 8242,
'uni2269': 8809,
'uni2268': 8808,
'uni0306': 774,
'uni226B': 8811,
'uni21EA': 8682,
'uni0166': 358,
'uni203B': 8251,
'uni01B5': 437,
'idieresis': 239,
'uni02BC': 700,
'uni01B0': 432,
'braceright': 125,
'seven': 55,
'uni02BB': 699,
'uni011A': 282,
'uni29FB': 10747,
'brokenbar': 166,
'uni2036': 8246,
'uni25C0': 9664,
'uni0156': 342,
'uni22D5': 8917,
'uni0258': 600,
'ugrave': 249,
'uni22D6': 8918,
'uni22D1': 8913,
'uni2034': 8244,
'uni22D3': 8915,
'uni22D2': 8914,
'uni203C': 8252,
'uni223E': 8766,
'uni02BF': 703,
'uni22D9': 8921,
'uni22D8': 8920,
'uni25BD': 9661,
'uni25BE': 9662,
'uni25BF': 9663,
'uni041B': 1051,
'periodcentered': 183,
'uni25BC': 9660,
'uni019E': 414,
'uni019B': 411,
'uni019A': 410,
'uni2007': 8199,
'uni0391': 913,
'uni0390': 912,
'uni0393': 915,
'uni0392': 914,
'uni0395': 917,
'uni0394': 916,
'uni0397': 919,
'uni0396': 918,
'uni0399': 921,
'uni0398': 920,
'uni25C8': 9672,
'uni2468': 9320,
'sterling': 163,
'uni22EB': 8939,
'uni039C': 924,
'uni039B': 923,
'uni039E': 926,
'uni039D': 925,
'uni039F': 927,
'I': 73,
'uni03E1': 993,
'uni03E0': 992,
'uni2319': 8985,
'uni228B': 8843,
'uni25B5': 9653,
'uni25B6': 9654,
'uni22EA': 8938,
'uni24B9': 9401,
'uni044E': 1102,
'uni0199': 409,
'uni2266': 8806,
'Y': 89,
'uni22A2': 8866,
'Eth': 208,
'uni266F': 9839,
'emdash': 8212,
'uni263B': 9787,
'uni24BD': 9405,
'uni22DE': 8926,
'uni0360': 864,
'uni2557': 9559,
'uni22DF': 8927,
'uni22DA': 8922,
'uni22DC': 8924,
'uni0361': 865,
'i': 105,
'uni24BF': 9407,
'uni0362': 866,
'uni263E': 9790,
'uni028D': 653,
'uni2259': 8793,
'uni0323': 803,
'uni2265': 8805,
'daggerdbl': 8225,
'y': 121,
'uni010A': 266,
'plusminus': 177,
'less': 60,
'uni21AE': 8622,
'uni0315': 789,
'uni230B': 8971,
'uni21AF': 8623,
'uni21AA': 8618,
'uni21AC': 8620,
'uni21AB': 8619,
'uni01FB': 507,
'uni01FC': 508,
'uni223A': 8762,
'uni01FA': 506,
'uni01FF': 511,
'uni01FD': 509,
'uni01FE': 510,
'uni2567': 9575,
'uni25E0': 9696,
'uni0104': 260,
'uni0105': 261,
'uni0106': 262,
'uni0107': 263,
'uni0100': 256,
'uni0101': 257,
'uni0102': 258,
'uni0103': 259,
'uni2038': 8248,
'uni2009': 8201,
'uni2008': 8200,
'uni0108': 264,
'uni0109': 265,
'uni02A1': 673,
'uni223B': 8763,
'uni226C': 8812,
'uni25AC': 9644,
'uni24D3': 9427,
'uni21E0': 8672,
'uni21E3': 8675,
'Udieresis': 220,
'uni21E2': 8674,
'D': 68,
'uni21E5': 8677,
'uni2621': 9761,
'uni21D1': 8657,
'uni203E': 8254,
'uni22C6': 8902,
'uni21E4': 8676,
'uni010D': 269,
'uni010E': 270,
'uni010F': 271,
'five': 53,
'T': 84,
'uni010B': 267,
'uni010C': 268,
'uni2605': 9733,
'uni2663': 9827,
'uni21E6': 8678,
'uni24B6': 9398,
'uni22C1': 8897,
'oslash': 248,
'acute': 180,
'uni01F0': 496,
'd': 100,
'OE': 338,
'uni22E3': 8931,
'Igrave': 204,
'uni2308': 8968,
'uni2309': 8969,
'uni21A9': 8617,
't': 116,
'uni2313': 8979,
'uni03A3': 931,
'uni21A4': 8612,
'uni21A7': 8615,
'uni21A6': 8614,
'uni21A1': 8609,
'uni21A0': 8608,
'uni21A3': 8611,
'uni21A2': 8610,
'parenright': 41,
'uni256A': 9578,
'uni25DC': 9692,
'uni24CE': 9422,
'uni042C': 1068,
'uni24E0': 9440,
'uni042B': 1067,
'uni0409': 1033,
'uni0408': 1032,
'uni24E7': 9447,
'uni25B4': 9652,
'uni042A': 1066,
'uni228E': 8846,
'uni0401': 1025,
'adieresis': 228,
'uni0403': 1027,
'quotesingle': 39,
'uni0405': 1029,
'uni0404': 1028,
'uni0407': 1031,
'uni0406': 1030,
'uni229C': 8860,
'uni2306': 8966,
'uni2253': 8787,
'twodotenleader': 8229,
'uni2131': 8497,
'uni21DA': 8666,
'uni2234': 8756,
'uni2235': 8757,
'uni01A5': 421,
'uni2237': 8759,
'uni2230': 8752,
'uni02CC': 716,
'slash': 47,
'uni01A0': 416,
'ellipsis': 8230,
'uni2299': 8857,
'uni2238': 8760,
'numbersign': 35,
'uni21A8': 8616,
'uni223D': 8765,
'uni01AF': 431,
'uni223F': 8767,
'uni01AD': 429,
'uni01AB': 427,
'odieresis': 246,
'uni223C': 8764,
'uni227D': 8829,
'uni0280': 640,
'O': 79,
'uni227E': 8830,
'uni21A5': 8613,
'uni22D4': 8916,
'uni25D4': 9684,
'uni227F': 8831,
'uni0435': 1077,
'uni2302': 8962,
'uni2669': 9833,
'uni24E3': 9443,
'uni2720': 10016,
'uni22A8': 8872,
'uni22A9': 8873,
'uni040A': 1034,
'uni22A7': 8871,
'oe': 339,
'uni040B': 1035,
'uni040E': 1038,
'uni22A3': 8867,
'o': 111,
'uni040F': 1039,
'Edieresis': 203,
'uni25D5': 9685,
'plus': 43,
'uni044D': 1101,
'uni263C': 9788,
'uni22E6': 8934,
'uni2283': 8835,
'uni258C': 9612,
'uni219E': 8606,
'uni24E4': 9444,
'uni2136': 8502,
'dagger': 8224,
'uni24B7': 9399,
'uni219B': 8603,
'uni22E5': 8933,
'three': 51,
'uni210B': 8459,
'uni2534': 9524,
'uni24B8': 9400,
'uni230A': 8970,
'hungarumlaut': 733,
'parenleft': 40,
'uni0148': 328,
'uni0149': 329,
'uni2124': 8484,
'uni2125': 8485,
'uni2126': 8486,
'uni2127': 8487,
'uni0140': 320,
'uni2129': 8489,
'uni25C5': 9669,
'uni0143': 323,
'uni0144': 324,
'uni0145': 325,
'uni0146': 326,
'uni0147': 327,
'uni210D': 8461,
'fraction': 8260,
'uni2031': 8241,
'uni2196': 8598,
'uni2035': 8245,
'uni24E6': 9446,
'uni016B': 363,
'uni24BA': 9402,
'uni266A': 9834,
'uni0116': 278,
'uni2115': 8469,
'registered': 174,
'J': 74,
'uni25DF': 9695,
'uni25CE': 9678,
'uni273D': 10045,
'dieresis': 168,
'uni212B': 8491,
'uni0114': 276,
'uni212D': 8493,
'uni212E': 8494,
'uni212F': 8495,
'uni014A': 330,
'uni014B': 331,
'uni014C': 332,
'uni014D': 333,
'uni014E': 334,
'uni014F': 335,
'uni025E': 606,
'uni24E8': 9448,
'uni0111': 273,
'uni24E9': 9449,
'Ograve': 210,
'j': 106,
'uni2195': 8597,
'uni2194': 8596,
'uni2197': 8599,
'uni2037': 8247,
'uni2191': 8593,
'uni2190': 8592,
'uni2193': 8595,
'uni2192': 8594,
'uni29FA': 10746,
'uni2713': 10003,
'z': 122,
'uni2199': 8601,
'uni2198': 8600,
'uni2667': 9831,
'ae': 230,
'uni0448': 1096,
'semicolon': 59,
'uni2666': 9830,
'uni038F': 911,
'uni0444': 1092,
'uni0447': 1095,
'uni038E': 910,
'uni0441': 1089,
'uni038C': 908,
'uni0443': 1091,
'uni038A': 906,
'uni0250': 592,
'uni0251': 593,
'uni0252': 594,
'uni0253': 595,
'uni0254': 596,
'at': 64,
'uni0256': 598,
'uni0257': 599,
'uni0167': 359,
'uni0259': 601,
'uni228C': 8844,
'uni2662': 9826,
'uni0319': 793,
'uni0318': 792,
'uni24BC': 9404,
'uni0402': 1026,
'uni22EF': 8943,
'Iacute': 205,
'uni22ED': 8941,
'uni22EE': 8942,
'uni0311': 785,
'uni0310': 784,
'uni21E8': 8680,
'uni0312': 786,
'percent': 37,
'uni0317': 791,
'uni0316': 790,
'uni21D6': 8662,
'uni21D7': 8663,
'uni21D4': 8660,
'uni21D5': 8661,
'uni21D2': 8658,
'uni21D3': 8659,
'uni21D0': 8656,
'uni2138': 8504,
'uni2270': 8816,
'uni2271': 8817,
'uni2272': 8818,
'uni2273': 8819,
'uni2274': 8820,
'uni2275': 8821,
'bracketright': 93,
'uni21D9': 8665,
'uni21DF': 8671,
'uni21DD': 8669,
'uni21DE': 8670,
'AE': 198,
'uni03AE': 942,
'uni227A': 8826,
'uni227B': 8827,
'uni227C': 8828,
'asterisk': 42,
'aacute': 225,
'uni226F': 8815,
'uni22E2': 8930,
'uni0386': 902,
'uni22E0': 8928,
'uni22E1': 8929,
'U': 85,
'uni22E7': 8935,
'uni22E4': 8932,
'uni0387': 903,
'uni031A': 794,
'eacute': 233,
'uni22E8': 8936,
'uni22E9': 8937,
'uni24D8': 9432,
'uni025A': 602,
'uni025B': 603,
'uni025C': 604,
'e': 101,
'uni0128': 296,
'uni025F': 607,
'uni2665': 9829,
'thorn': 254,
'uni0129': 297,
'uni253C': 9532,
'uni25D7': 9687,
'u': 117,
'uni0388': 904,
'uni0389': 905,
'uni0255': 597,
'uni0171': 369,
'uni0384': 900,
'uni0385': 901,
'uni044A': 1098,
'uni252C': 9516,
'uni044C': 1100,
'uni044B': 1099}

uni2type1 = dict([(v,k) for k,v in type12uni.items()])

tex2uni = {'doteq': 8784,
'partial': 8706,
'gg': 8811,
'asymp': 8781,
'blacktriangledown': 9662,
'otimes': 8855,
'nearrow': 8599,
'varpi': 982,
'vee': 8744,
'vec': 8407,
'smile': 8995,
'succnsim': 8937,
'gimel': 8503,
'vert': 124,
'varrho': 1009,
'P': 182,
'approxident': 8779,
'Swarrow': 8665,
'textasciicircum': 94,
'imageof': 8887,
'ntriangleleft': 8938,
'nleq': 8816,
'div': 247,
'nparallel': 8742,
'Leftarrow': 8656,
'lll': 8920,
'oiint': 8751,
'ngeq': 8817,
'Theta': 920,
'origof': 8886,
'blacksquare': 9632,
'hspace': 8202,
'solbar': 9023,
'neg': 172,
'sum': 8721,
'Vdash': 8873,
'coloneq': 8788,
'degree': 176,
'bowtie': 8904,
'blacktriangleright': 9654,
'varsigma': 962,
'leq': 8804,
'ggg': 8921,
'lneqq': 8808,
'scurel': 8881,
'stareq': 8795,
'BbbN': 8469,
'nLeftarrow': 8653,
'nLeftrightarrow': 8654,
'k': 808,
'bot': 8869,
'BbbC': 8450,
'Lsh': 8624,
'leftleftarrows': 8647,
'BbbZ': 8484,
'digamma': 989,
'BbbR': 8477,
'BbbP': 8473,
'BbbQ': 8474,
'vartriangleright': 8883,
'succsim': 8831,
'wedge': 8743,
'lessgtr': 8822,
'veebar': 8891,
'mapsdown': 8615,
'Rsh': 8625,
'chi': 967,
'prec': 8826,
'nsubseteq': 8840,
'therefore': 8756,
'eqcirc': 8790,
'textexclamdown': 161,
'nRightarrow': 8655,
'flat': 9837,
'notin': 8713,
'llcorner': 8990,
'varepsilon': 949,
'bigtriangleup': 9651,
'aleph': 8501,
'dotminus': 8760,
'upsilon': 965,
'Lambda': 923,
'cap': 8745,
'barleftarrow': 8676,
'mu': 956,
'boxplus': 8862,
'mp': 8723,
'circledast': 8859,
'tau': 964,
'in': 8712,
'backslash': 92,
'varnothing': 8709,
'sharp': 9839,
'eqsim': 8770,
'gnsim': 8935,
'Searrow': 8664,
'updownarrows': 8645,
'heartsuit': 9825,
'trianglelefteq': 8884,
'ddagger': 8225,
'sqsubseteq': 8849,
'mapsfrom': 8612,
'boxbar': 9707,
'sim': 8764,
'Nwarrow': 8662,
'nequiv': 8802,
'succ': 8827,
'vdash': 8866,
'Leftrightarrow': 8660,
'parallel': 8741,
'invnot': 8976,
'natural': 9838,
'ss': 223,
'uparrow': 8593,
'nsim': 8769,
'hookrightarrow': 8618,
'Equiv': 8803,
'approx': 8776,
'Vvdash': 8874,
'nsucc': 8833,
'leftrightharpoons': 8651,
'Re': 8476,
'boxminus': 8863,
'equiv': 8801,
'Lleftarrow': 8666,
'thinspace': 8201,
'll': 8810,
'Cup': 8915,
'measeq': 8798,
'upharpoonleft': 8639,
'lq': 8216,
'Upsilon': 978,
'subsetneq': 8842,
'greater': 62,
'supsetneq': 8843,
'Cap': 8914,
'L': 321,
'spadesuit': 9824,
'lrcorner': 8991,
'not': 824,
'bar': 772,
'rightharpoonaccent': 8401,
'boxdot': 8865,
'l': 322,
'leftharpoondown': 8637,
'bigcup': 8899,
'iint': 8748,
'bigwedge': 8896,
'downharpoonleft': 8643,
'textasciitilde': 126,
'subset': 8834,
'leqq': 8806,
'mapsup': 8613,
'nvDash': 8877,
'looparrowleft': 8619,
'nless': 8814,
'rightarrowbar': 8677,
'Vert': 8214,
'downdownarrows': 8650,
'uplus': 8846,
'simeq': 8771,
'napprox': 8777,
'ast': 8727,
'twoheaduparrow': 8607,
'doublebarwedge ?': 8966,
'Sigma': 931,
'leftharpoonaccent': 8400,
'ntrianglelefteq': 8940,
'nexists': 8708,
'times': 215,
'measuredangle': 8737,
'bumpeq': 8783,
'carriagereturn': 8629,
'adots': 8944,
'checkmark': 10003,
'lambda': 955,
'xi': 958,
'rbrace': 125,
'rbrack': 93,
'Nearrow': 8663,
'maltese': 10016,
'clubsuit': 9827,
'top': 8868,
'overarc': 785,
'varphi': 966,
'Delta': 916,
'iota': 953,
'nleftarrow': 8602,
'candra': 784,
'supset': 8835,
'triangleleft': 9665,
'gtreqless': 8923,
'ntrianglerighteq': 8941,
'quad': 8195,
'Xi': 926,
'gtrdot': 8919,
'leftthreetimes': 8907,
'minus': 8722,
'preccurlyeq': 8828,
'nleftrightarrow': 8622,
'lambdabar': 411,
'blacktriangle': 9652,
'kernelcontraction': 8763,
'Phi': 934,
'angle': 8736,
'spadesuitopen': 9828,
'eqless': 8924,
'mid': 8739,
'varkappa': 1008,
'Ldsh': 8626,
'updownarrow': 8597,
'beta': 946,
'textquotedblleft': 8220,
'rho': 961,
'alpha': 945,
'intercal': 8890,
'beth': 8502,
'grave': 768,
'acwopencirclearrow': 8634,
'nmid': 8740,
'nsupset': 8837,
'sigma': 963,
'dot': 775,
'Rightarrow': 8658,
'turnednot': 8985,
'backsimeq': 8909,
'leftarrowtail': 8610,
'approxeq': 8778,
'curlyeqsucc': 8927,
'rightarrowtail': 8611,
'Psi': 936,
'copyright': 169,
'yen': 165,
'vartriangleleft': 8882,
'rasp': 700,
'triangleright': 9655,
'precsim': 8830,
'infty': 8734,
'geq': 8805,
'updownarrowbar': 8616,
'precnsim': 8936,
'H': 779,
'ulcorner': 8988,
'looparrowright': 8620,
'ncong': 8775,
'downarrow': 8595,
'circeq': 8791,
'subseteq': 8838,
'bigstar': 9733,
'prime': 8242,
'lceil': 8968,
'Rrightarrow': 8667,
'oiiint': 8752,
'curlywedge': 8911,
'vDash': 8872,
'lfloor': 8970,
'ddots': 8945,
'exists': 8707,
'underbar': 817,
'Pi': 928,
'leftrightarrows': 8646,
'sphericalangle': 8738,
'coprod': 8720,
'circledcirc': 8858,
'gtrsim': 8819,
'gneqq': 8809,
'between': 8812,
'theta': 952,
'complement': 8705,
'arceq': 8792,
'nVdash': 8878,
'S': 167,
'wr': 8768,
'wp': 8472,
'backcong': 8780,
'lasp': 701,
'c': 807,
'nabla': 8711,
'dotplus': 8724,
'eta': 951,
'forall': 8704,
'eth': 240,
'colon': 58,
'sqcup': 8852,
'rightrightarrows': 8649,
'sqsupset': 8848,
'mapsto': 8614,
'bigtriangledown': 9661,
'sqsupseteq': 8850,
'propto': 8733,
'pi': 960,
'pm': 177,
'dots': 8230,
'nrightarrow': 8603,
'textasciiacute': 180,
'Doteq': 8785,
'breve': 774,
'sqcap': 8851,
'twoheadrightarrow': 8608,
'kappa': 954,
'vartriangle': 9653,
'diamondsuit': 9826,
'pitchfork': 8916,
'blacktriangleleft': 9664,
'nprec': 8832,
'vdots': 8942,
'curvearrowright': 8631,
'barwedge': 8892,
'multimap': 8888,
'textquestiondown': 191,
'cong': 8773,
'rtimes': 8906,
'rightzigzagarrow': 8669,
'rightarrow': 8594,
'leftarrow': 8592,
'sqrt': 8730,
'twoheaddownarrow': 8609,
'oint': 8750,
'bigvee': 8897,
'eqdef': 8797,
'sterling': 163,
'phi': 981,
'Updownarrow': 8661,
'backprime': 8245,
'emdash': 8212,
'Gamma': 915,
'i': 305,
'rceil': 8969,
'leftharpoonup': 8636,
'Im': 8465,
'curvearrowleft': 8630,
'wedgeq': 8793,
'fallingdotseq': 8786,
'curlyeqprec': 8926,
'questeq': 8799,
'less': 60,
'upuparrows': 8648,
'tilde': 771,
'textasciigrave': 96,
'smallsetminus': 8726,
'ell': 8467,
'cup': 8746,
'danger': 9761,
'nVDash': 8879,
'cdotp': 183,
'cdots': 8943,
'hat': 770,
'eqgtr': 8925,
'enspace': 8194,
'psi': 968,
'frown': 8994,
'acute': 769,
'downzigzagarrow': 8623,
'ntriangleright': 8939,
'cupdot': 8845,
'circleddash': 8861,
'oslash': 8856,
'mho': 8487,
'd': 803,
'sqsubset': 8847,
'cdot': 8901,
'Omega': 937,
'OE': 338,
'veeeq': 8794,
'Finv': 8498,
't': 865,
'leftrightarrow': 8596,
'swarrow': 8601,
'rightthreetimes': 8908,
'rightleftharpoons': 8652,
'lesssim': 8818,
'searrow': 8600,
'because': 8757,
'gtrless': 8823,
'star': 8902,
'nsubset': 8836,
'zeta': 950,
'dddot': 8411,
'bigcirc': 9675,
'Supset': 8913,
'circ': 8728,
'slash': 8725,
'ocirc': 778,
'prod': 8719,
'twoheadleftarrow': 8606,
'daleth': 8504,
'upharpoonright': 8638,
'odot': 8857,
'Uparrow': 8657,
'O': 216,
'hookleftarrow': 8617,
'trianglerighteq': 8885,
'nsime': 8772,
'oe': 339,
'nwarrow': 8598,
'o': 248,
'ddddot': 8412,
'downharpoonright': 8642,
'succcurlyeq': 8829,
'gamma': 947,
'scrR': 8475,
'dagger': 8224,
'thickspace': 8197,
'frakZ': 8488,
'lessdot': 8918,
'triangledown': 9663,
'ltimes': 8905,
'scrB': 8492,
'endash': 8211,
'scrE': 8496,
'scrF': 8497,
'scrH': 8459,
'scrI': 8464,
'rightharpoondown': 8641,
'scrL': 8466,
'scrM': 8499,
'frakC': 8493,
'nsupseteq': 8841,
'circledR': 174,
'circledS': 9416,
'ngtr': 8815,
'bigcap': 8898,
'scre': 8495,
'Downarrow': 8659,
'scrg': 8458,
'overleftrightarrow': 8417,
'scro': 8500,
'lnsim': 8934,
'eqcolon': 8789,
'curlyvee': 8910,
'urcorner': 8989,
'lbrace': 123,
'Bumpeq': 8782,
'delta': 948,
'boxtimes': 8864,
'overleftarrow': 8406,
'prurel': 8880,
'clubsuitopen': 9831,
'cwopencirclearrow': 8635,
'geqq': 8807,
'rightleftarrows': 8644,
'ac': 8766,
'ae': 230,
'int': 8747,
'rfloor': 8971,
'risingdotseq': 8787,
'nvdash': 8876,
'diamond': 8900,
'ddot': 776,
'backsim': 8765,
'oplus': 8853,
'triangleq': 8796,
'check': 780,
'ni': 8715,
'iiint': 8749,
'ne': 8800,
'lesseqgtr': 8922,
'obar': 9021,
'supseteq': 8839,
'nu': 957,
'AA': 8491,
'AE': 198,
'models': 8871,
'ominus': 8854,
'dashv': 8867,
'omega': 969,
'rq': 8217,
'Subset': 8912,
'rightharpoonup': 8640,
'Rdsh': 8627,
'bullet': 8729,
'divideontimes': 8903,
'lbrack': 91,
'textquotedblright': 8221,
'Colon': 8759}

uni2tex = dict([(v,k) for k,v in tex2uni.items()])

tex2type1 = {'doteq': 'uni2250',
'partial': 'uni2202',
'gg': 'uni226B',
'asymp': 'uni224D',
'blacktriangledown': 'uni25BE',
'otimes': 'uni2297',
'nearrow': 'uni2197',
'varpi': 'uni03D6',
'vee': 'uni2228',
'vec': 'uni20D7',
'smile': 'uni2323',
'succnsim': 'uni22E9',
'gimel': 'uni2137',
'vert': 'bar',
'varrho': 'uni03F1',
'P': 'paragraph',
'approxident': 'uni224B',
'Swarrow': 'uni21D9',
'textasciicircum': 'asciicircum',
'imageof': 'uni22B7',
'ntriangleleft': 'uni22EA',
'nleq': 'uni2270',
'div': 'divide',
'nparallel': 'uni2226',
'Leftarrow': 'uni21D0',
'lll': 'uni22D8',
'oiint': 'uni222F',
'ngeq': 'uni2271',
'Theta': 'uni0398',
'origof': 'uni22B6',
'blacksquare': 'uni25A0',
'hspace': 'uni200A',
'solbar': 'uni233F',
'neg': 'logicalnot',
'sum': 'uni2211',
'Vdash': 'uni22A9',
'coloneq': 'uni2254',
'degree': 'degree',
'bowtie': 'uni22C8',
'blacktriangleright': 'uni25B6',
'varsigma': 'uni03C2',
'leq': 'uni2264',
'ggg': 'uni22D9',
'lneqq': 'uni2268',
'scurel': 'uni22B1',
'stareq': 'uni225B',
'BbbN': 'uni2115',
'nLeftarrow': 'uni21CD',
'nLeftrightarrow': 'uni21CE',
'k': 'uni0328',
'bot': 'uni22A5',
'BbbC': 'uni2102',
'Lsh': 'uni21B0',
'leftleftarrows': 'uni21C7',
'BbbZ': 'uni2124',
'digamma': 'uni03DD',
'BbbR': 'uni211D',
'BbbP': 'uni2119',
'BbbQ': 'uni211A',
'vartriangleright': 'uni22B3',
'succsim': 'uni227F',
'wedge': 'uni2227',
'lessgtr': 'uni2276',
'veebar': 'uni22BB',
'mapsdown': 'uni21A7',
'Rsh': 'uni21B1',
'chi': 'uni03C7',
'prec': 'uni227A',
'nsubseteq': 'uni2288',
'therefore': 'uni2234',
'eqcirc': 'uni2256',
'textexclamdown': 'exclamdown',
'nRightarrow': 'uni21CF',
'flat': 'uni266D',
'notin': 'uni2209',
'llcorner': 'uni231E',
'varepsilon': 'uni03B5',
'bigtriangleup': 'uni25B3',
'aleph': 'uni2135',
'dotminus': 'uni2238',
'upsilon': 'uni03C5',
'Lambda': 'uni039B',
'cap': 'uni2229',
'barleftarrow': 'uni21E4',
'mu': 'uni03BC',
'boxplus': 'uni229E',
'mp': 'uni2213',
'circledast': 'uni229B',
'tau': 'uni03C4',
'in': 'uni2208',
'backslash': 'backslash',
'varnothing': 'uni2205',
'sharp': 'uni266F',
'eqsim': 'uni2242',
'gnsim': 'uni22E7',
'Searrow': 'uni21D8',
'updownarrows': 'uni21C5',
'heartsuit': 'uni2661',
'trianglelefteq': 'uni22B4',
'ddagger': 'daggerdbl',
'sqsubseteq': 'uni2291',
'mapsfrom': 'uni21A4',
'boxbar': 'uni25EB',
'sim': 'uni223C',
'Nwarrow': 'uni21D6',
'nequiv': 'uni2262',
'succ': 'uni227B',
'vdash': 'uni22A2',
'Leftrightarrow': 'uni21D4',
'parallel': 'uni2225',
'invnot': 'uni2310',
'natural': 'uni266E',
'ss': 'germandbls',
'uparrow': 'uni2191',
'nsim': 'uni2241',
'hookrightarrow': 'uni21AA',
'Equiv': 'uni2263',
'approx': 'uni2248',
'Vvdash': 'uni22AA',
'nsucc': 'uni2281',
'leftrightharpoons': 'uni21CB',
'Re': 'uni211C',
'boxminus': 'uni229F',
'equiv': 'uni2261',
'Lleftarrow': 'uni21DA',
'thinspace': 'uni2009',
'll': 'uni226A',
'Cup': 'uni22D3',
'measeq': 'uni225E',
'upharpoonleft': 'uni21BF',
'lq': 'quoteleft',
'Upsilon': 'uni03D2',
'subsetneq': 'uni228A',
'greater': 'greater',
'supsetneq': 'uni228B',
'Cap': 'uni22D2',
'L': 'Lslash',
'spadesuit': 'uni2660',
'lrcorner': 'uni231F',
'not': 'uni0338',
'bar': 'uni0304',
'rightharpoonaccent': 'uni20D1',
'boxdot': 'uni22A1',
'l': 'lslash',
'leftharpoondown': 'uni21BD',
'bigcup': 'uni22C3',
'iint': 'uni222C',
'bigwedge': 'uni22C0',
'downharpoonleft': 'uni21C3',
'textasciitilde': 'asciitilde',
'subset': 'uni2282',
'leqq': 'uni2266',
'mapsup': 'uni21A5',
'nvDash': 'uni22AD',
'looparrowleft': 'uni21AB',
'nless': 'uni226E',
'rightarrowbar': 'uni21E5',
'Vert': 'uni2016',
'downdownarrows': 'uni21CA',
'uplus': 'uni228E',
'simeq': 'uni2243',
'napprox': 'uni2249',
'ast': 'uni2217',
'twoheaduparrow': 'uni219F',
'doublebarwedge ?': 'uni2306',
'Sigma': 'uni03A3',
'leftharpoonaccent': 'uni20D0',
'ntrianglelefteq': 'uni22EC',
'nexists': 'uni2204',
'times': 'multiply',
'measuredangle': 'uni2221',
'bumpeq': 'uni224F',
'carriagereturn': 'uni21B5',
'adots': 'uni22F0',
'checkmark': 'uni2713',
'lambda': 'uni03BB',
'xi': 'uni03BE',
'rbrace': 'braceright',
'rbrack': 'bracketright',
'Nearrow': 'uni21D7',
'maltese': 'uni2720',
'clubsuit': 'uni2663',
'top': 'uni22A4',
'overarc': 'uni0311',
'varphi': 'uni03C6',
'Delta': 'uni0394',
'iota': 'uni03B9',
'nleftarrow': 'uni219A',
'candra': 'uni0310',
'supset': 'uni2283',
'triangleleft': 'uni25C1',
'gtreqless': 'uni22DB',
'ntrianglerighteq': 'uni22ED',
'quad': 'uni2003',
'Xi': 'uni039E',
'gtrdot': 'uni22D7',
'leftthreetimes': 'uni22CB',
'minus': 'minus',
'preccurlyeq': 'uni227C',
'nleftrightarrow': 'uni21AE',
'lambdabar': 'uni019B',
'blacktriangle': 'uni25B4',
'kernelcontraction': 'uni223B',
'Phi': 'uni03A6',
'angle': 'uni2220',
'spadesuitopen': 'uni2664',
'eqless': 'uni22DC',
'mid': 'uni2223',
'varkappa': 'uni03F0',
'Ldsh': 'uni21B2',
'updownarrow': 'uni2195',
'beta': 'uni03B2',
'textquotedblleft': 'quotedblleft',
'rho': 'uni03C1',
'alpha': 'uni03B1',
'intercal': 'uni22BA',
'beth': 'uni2136',
'grave': 'uni0300',
'acwopencirclearrow': 'uni21BA',
'nmid': 'uni2224',
'nsupset': 'uni2285',
'sigma': 'uni03C3',
'dot': 'uni0307',
'Rightarrow': 'uni21D2',
'turnednot': 'uni2319',
'backsimeq': 'uni22CD',
'leftarrowtail': 'uni21A2',
'approxeq': 'uni224A',
'curlyeqsucc': 'uni22DF',
'rightarrowtail': 'uni21A3',
'Psi': 'uni03A8',
'copyright': 'copyright',
'yen': 'yen',
'vartriangleleft': 'uni22B2',
'rasp': 'uni02BC',
'triangleright': 'uni25B7',
'precsim': 'uni227E',
'infty': 'uni221E',
'geq': 'uni2265',
'updownarrowbar': 'uni21A8',
'precnsim': 'uni22E8',
'H': 'uni030B',
'ulcorner': 'uni231C',
'looparrowright': 'uni21AC',
'ncong': 'uni2247',
'downarrow': 'uni2193',
'circeq': 'uni2257',
'subseteq': 'uni2286',
'bigstar': 'uni2605',
'prime': 'uni2032',
'lceil': 'uni2308',
'Rrightarrow': 'uni21DB',
'oiiint': 'uni2230',
'curlywedge': 'uni22CF',
'vDash': 'uni22A8',
'lfloor': 'uni230A',
'ddots': 'uni22F1',
'exists': 'uni2203',
'underbar': 'uni0331',
'Pi': 'uni03A0',
'leftrightarrows': 'uni21C6',
'sphericalangle': 'uni2222',
'coprod': 'uni2210',
'circledcirc': 'uni229A',
'gtrsim': 'uni2273',
'gneqq': 'uni2269',
'between': 'uni226C',
'theta': 'uni03B8',
'complement': 'uni2201',
'arceq': 'uni2258',
'nVdash': 'uni22AE',
'S': 'section',
'wr': 'uni2240',
'wp': 'uni2118',
'backcong': 'uni224C',
'lasp': 'uni02BD',
'c': 'uni0327',
'nabla': 'uni2207',
'dotplus': 'uni2214',
'eta': 'uni03B7',
'forall': 'uni2200',
'eth': 'eth',
'colon': 'colon',
'sqcup': 'uni2294',
'rightrightarrows': 'uni21C9',
'sqsupset': 'uni2290',
'mapsto': 'uni21A6',
'bigtriangledown': 'uni25BD',
'sqsupseteq': 'uni2292',
'propto': 'uni221D',
'pi': 'uni03C0',
'pm': 'plusminus',
'dots': 'ellipsis',
'nrightarrow': 'uni219B',
'textasciiacute': 'acute',
'Doteq': 'uni2251',
'breve': 'uni0306',
'sqcap': 'uni2293',
'twoheadrightarrow': 'uni21A0',
'kappa': 'uni03BA',
'vartriangle': 'uni25B5',
'diamondsuit': 'uni2662',
'pitchfork': 'uni22D4',
'blacktriangleleft': 'uni25C0',
'nprec': 'uni2280',
'vdots': 'uni22EE',
'curvearrowright': 'uni21B7',
'barwedge': 'uni22BC',
'multimap': 'uni22B8',
'textquestiondown': 'questiondown',
'cong': 'uni2245',
'rtimes': 'uni22CA',
'rightzigzagarrow': 'uni21DD',
'rightarrow': 'uni2192',
'leftarrow': 'uni2190',
'sqrt': 'uni221A',
'twoheaddownarrow': 'uni21A1',
'oint': 'uni222E',
'bigvee': 'uni22C1',
'eqdef': 'uni225D',
'sterling': 'sterling',
'phi': 'uni03D5',
'Updownarrow': 'uni21D5',
'backprime': 'uni2035',
'emdash': 'emdash',
'Gamma': 'uni0393',
'i': 'dotlessi',
'rceil': 'uni2309',
'leftharpoonup': 'uni21BC',
'Im': 'uni2111',
'curvearrowleft': 'uni21B6',
'wedgeq': 'uni2259',
'fallingdotseq': 'uni2252',
'curlyeqprec': 'uni22DE',
'questeq': 'uni225F',
'less': 'less',
'upuparrows': 'uni21C8',
'tilde': 'uni0303',
'textasciigrave': 'grave',
'smallsetminus': 'uni2216',
'ell': 'uni2113',
'cup': 'uni222A',
'danger': 'uni2621',
'nVDash': 'uni22AF',
'cdotp': 'periodcentered',
'cdots': 'uni22EF',
'hat': 'uni0302',
'eqgtr': 'uni22DD',
'enspace': 'uni2002',
'psi': 'uni03C8',
'frown': 'uni2322',
'acute': 'uni0301',
'downzigzagarrow': 'uni21AF',
'ntriangleright': 'uni22EB',
'cupdot': 'uni228D',
'circleddash': 'uni229D',
'oslash': 'uni2298',
'mho': 'uni2127',
'd': 'uni0323',
'sqsubset': 'uni228F',
'cdot': 'uni22C5',
'Omega': 'uni03A9',
'OE': 'OE',
'veeeq': 'uni225A',
'Finv': 'uni2132',
't': 'uni0361',
'leftrightarrow': 'uni2194',
'swarrow': 'uni2199',
'rightthreetimes': 'uni22CC',
'rightleftharpoons': 'uni21CC',
'lesssim': 'uni2272',
'searrow': 'uni2198',
'because': 'uni2235',
'gtrless': 'uni2277',
'star': 'uni22C6',
'nsubset': 'uni2284',
'zeta': 'uni03B6',
'dddot': 'uni20DB',
'bigcirc': 'uni25CB',
'Supset': 'uni22D1',
'circ': 'uni2218',
'slash': 'uni2215',
'ocirc': 'uni030A',
'prod': 'uni220F',
'twoheadleftarrow': 'uni219E',
'daleth': 'uni2138',
'upharpoonright': 'uni21BE',
'odot': 'uni2299',
'Uparrow': 'uni21D1',
'O': 'Oslash',
'hookleftarrow': 'uni21A9',
'trianglerighteq': 'uni22B5',
'nsime': 'uni2244',
'oe': 'oe',
'nwarrow': 'uni2196',
'o': 'oslash',
'ddddot': 'uni20DC',
'downharpoonright': 'uni21C2',
'succcurlyeq': 'uni227D',
'gamma': 'uni03B3',
'scrR': 'uni211B',
'dagger': 'dagger',
'thickspace': 'uni2005',
'frakZ': 'uni2128',
'lessdot': 'uni22D6',
'triangledown': 'uni25BF',
'ltimes': 'uni22C9',
'scrB': 'uni212C',
'endash': 'endash',
'scrE': 'uni2130',
'scrF': 'uni2131',
'scrH': 'uni210B',
'scrI': 'uni2110',
'rightharpoondown': 'uni21C1',
'scrL': 'uni2112',
'scrM': 'uni2133',
'frakC': 'uni212D',
'nsupseteq': 'uni2289',
'circledR': 'registered',
'circledS': 'uni24C8',
'ngtr': 'uni226F',
'bigcap': 'uni22C2',
'scre': 'uni212F',
'Downarrow': 'uni21D3',
'scrg': 'uni210A',
'overleftrightarrow': 'uni20E1',
'scro': 'uni2134',
'lnsim': 'uni22E6',
'eqcolon': 'uni2255',
'curlyvee': 'uni22CE',
'urcorner': 'uni231D',
'lbrace': 'braceleft',
'Bumpeq': 'uni224E',
'delta': 'uni03B4',
'boxtimes': 'uni22A0',
'overleftarrow': 'uni20D6',
'prurel': 'uni22B0',
'clubsuitopen': 'uni2667',
'cwopencirclearrow': 'uni21BB',
'geqq': 'uni2267',
'rightleftarrows': 'uni21C4',
'ac': 'uni223E',
'ae': 'ae',
'int': 'uni222B',
'rfloor': 'uni230B',
'risingdotseq': 'uni2253',
'nvdash': 'uni22AC',
'diamond': 'uni22C4',
'ddot': 'uni0308',
'backsim': 'uni223D',
'oplus': 'uni2295',
'triangleq': 'uni225C',
'check': 'uni030C',
'ni': 'uni220B',
'iiint': 'uni222D',
'ne': 'uni2260',
'lesseqgtr': 'uni22DA',
'obar': 'uni233D',
'supseteq': 'uni2287',
'nu': 'uni03BD',
'AA': 'uni212B',
'AE': 'AE',
'models': 'uni22A7',
'ominus': 'uni2296',
'dashv': 'uni22A3',
'omega': 'uni03C9',
'rq': 'quoteright',
'Subset': 'uni22D0',
'rightharpoonup': 'uni21C0',
'Rdsh': 'uni21B3',
'bullet': 'uni2219',
'divideontimes': 'uni22C7',
'lbrack': 'bracketleft',
'textquotedblright': 'quotedblright',
'Colon': 'uni2237'}

type12tex = dict([(v,k) for k,v in tex2type1.items()])

