/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.Document;

public class BinaryGraphicsDocument
implements Document {
    private static final int BUFFERSIZE = 1024;
    private String docName;
    private byte[] data;
    private int nOff;
    private int nLen;
    private String sFileExtension;
    private String sMimeType;

    public BinaryGraphicsDocument(String string, String string2, String string3) {
        this.sFileExtension = string2;
        this.sMimeType = string3;
        this.docName = this.trimDocumentName(string);
    }

    public void read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("No input stream to convert");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.data = byteArrayOutputStream.toByteArray();
    }

    public void read(byte[] byArray) {
        this.read(byArray, 0, byArray.length);
    }

    public void read(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.nOff = n;
        this.nLen = n2;
    }

    private String trimDocumentName(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(this.getFileExtension())) {
            int n = string.length();
            int n2 = n - this.getFileExtension().length();
            string = string.substring(0, n2);
        }
        return string;
    }

    public String getName() {
        return this.docName;
    }

    public String getFileName() {
        return new String(this.docName + this.getFileExtension());
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.data, this.nOff, this.nLen);
    }

    public String getFileExtension() {
        return this.sFileExtension;
    }

    public String getDocumentMIMEType() {
        return this.sMimeType;
    }
}

