/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Kit;

public class WrappedException
extends EvaluatorException {
    private static Method initCauseMethod = null;
    private Throwable exception;

    public WrappedException(Throwable throwable) {
        super(throwable.getMessage());
        this.exception = throwable;
        if (initCauseMethod != null) {
            try {
                initCauseMethod.invoke((Object)this, throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getMessage() {
        return "WrappedException of " + this.exception.toString();
    }

    public String getLocalizedMessage() {
        return "WrappedException of " + this.exception.getLocalizedMessage();
    }

    public Throwable getWrappedException() {
        return this.exception;
    }

    public Object unwrap() {
        return this.getWrappedException();
    }

    static {
        try {
            Class clazz = Kit.classOrNull("java.lang.Throwable");
            initCauseMethod = clazz.getMethod("initCause", clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

