/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class NativeWith
implements Scriptable,
IdFunctionMaster {
    private static final int Id_constructor = 1;
    private Scriptable prototype;
    private Scriptable parent;
    private Scriptable constructor;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeWith nativeWith = new NativeWith();
        nativeWith.prototypeFlag = true;
        IdFunction idFunction = new IdFunction(nativeWith, "constructor", 1);
        idFunction.initAsConstructor(scriptable, nativeWith);
        if (bl) {
            idFunction.sealObject();
        }
        nativeWith.setParentScope(idFunction);
        nativeWith.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        ScriptableObject.defineProperty(scriptable, "With", idFunction, 2);
    }

    private NativeWith() {
    }

    NativeWith(Scriptable scriptable, Scriptable scriptable2) {
        this.parent = scriptable;
        this.prototype = scriptable2;
    }

    public String getClassName() {
        return "With";
    }

    public boolean has(String string, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        return this.prototype.has(string, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        return this.prototype.has(n, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        return this.prototype.get(string, scriptable);
    }

    public Object get(int n, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        return this.prototype.get(n, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        this.prototype.put(string, scriptable, object);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        this.prototype.put(n, scriptable, object);
    }

    public void delete(String string) {
        this.prototype.delete(string);
    }

    public void delete(int n) {
        this.prototype.delete(n);
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public Object[] getIds() {
        return this.prototype.getIds();
    }

    public Object getDefaultValue(Class clazz) {
        return this.prototype.getDefaultValue(clazz);
    }

    public boolean hasInstance(Scriptable scriptable) {
        return this.prototype.hasInstance(scriptable);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag && n == 1) {
            throw Context.reportRuntimeError1("msg.cant.call.indirect", "With");
        }
        throw IdFunction.onBadMethodId(this, n);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag && n == 1) {
            return 0;
        }
        return -1;
    }

    static boolean isWithFunction(Object object) {
        if (object instanceof IdFunction) {
            IdFunction idFunction = (IdFunction)object;
            if (idFunction.master instanceof NativeWith && idFunction.getMethodId() == 1) {
                return true;
            }
        }
        return false;
    }

    static Object newWithSpecial(Context context, Scriptable scriptable, Object[] objectArray) {
        ScriptRuntime.checkDeprecated(context, "With");
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        NativeWith nativeWith = new NativeWith();
        nativeWith.setPrototype(objectArray.length == 0 ? ScriptableObject.getClassPrototype(scriptable, "Object") : ScriptRuntime.toObject(context, scriptable, objectArray[0]));
        nativeWith.setParentScope(scriptable);
        return nativeWith;
    }
}

