/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeCallPrototype
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;

    NativeCallPrototype(Context context, Scriptable scriptable, boolean bl) {
        this.addAsPrototype(1, context, scriptable, bl);
    }

    public String getClassName() {
        return "Call";
    }

    public int methodArity(int n) {
        if (n == 1) {
            return 1;
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (n == 1) {
            if (scriptable2 != null) {
                throw Context.reportRuntimeError1("msg.only.from.new", "Call");
            }
            ScriptRuntime.checkDeprecated(context, "Call");
            NativeCall nativeCall = new NativeCall();
            nativeCall.setPrototype(NativeCallPrototype.getObjectPrototype(scriptable));
            return nativeCall;
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    protected String getIdName(int n) {
        if (n == 1) {
            return "constructor";
        }
        return null;
    }

    protected int mapNameToId(String string) {
        return string.equals("constructor") ? 1 : 0;
    }
}

