/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JIFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;

public final class JavaAdapter {
    private static final String IFGLUE_BASE = IFGlue.class.getName();

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        JIFunction jIFunction = new JIFunction("JavaAdapter", 1){

            public Scriptable createObject(Context context, Scriptable scriptable) {
                return null;
            }

            public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                return JavaAdapter.js_createAdpter(context, scriptable, objectArray);
            }
        };
        jIFunction.defineAsProperty(scriptable);
    }

    public static Object convertResult(Object object, Class clazz) {
        if (object == Undefined.instance && clazz != ScriptRuntime.ObjectClass && clazz != ScriptRuntime.StringClass) {
            return null;
        }
        return NativeJavaObject.coerceType(clazz, object, true);
    }

    public static Scriptable createAdapterWrapper(Scriptable scriptable, Object object) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        NativeJavaObject nativeJavaObject = new NativeJavaObject(scriptable2, object, null);
        nativeJavaObject.setPrototype(scriptable);
        return nativeJavaObject;
    }

    public static Object getAdapterSelf(Class clazz, Object object) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField("self");
        return field.get(object);
    }

    static Object js_createAdpter(Context context, Scriptable scriptable, Object[] objectArray) {
        Class clazz;
        Object object;
        int n = objectArray.length;
        if (n == 0) {
            throw ScriptRuntime.typeError0("msg.adapter.zero.args");
        }
        Class clazz2 = null;
        Class[] classArray = new Class[n - 1];
        int n2 = 0;
        for (int i = 0; i != n - 1; ++i) {
            object = objectArray[i];
            if (!(object instanceof NativeJavaClass)) {
                throw ScriptRuntime.typeError2("msg.not.java.class.arg", String.valueOf(i), ScriptRuntime.toString(object));
            }
            clazz = ((NativeJavaClass)object).getClassObject();
            if (!clazz.isInterface()) {
                if (clazz2 != null) {
                    throw ScriptRuntime.typeError2("msg.only.one.super", clazz2.getName(), clazz.getName());
                }
                clazz2 = clazz;
                continue;
            }
            classArray[n2++] = clazz;
        }
        if (clazz2 == null) {
            clazz2 = ScriptRuntime.ObjectClass;
        }
        Class[] classArray2 = new Class[n2];
        System.arraycopy(classArray, 0, classArray2, 0, n2);
        object = ScriptRuntime.toObject(context, scriptable, objectArray[n - 1]);
        clazz = JavaAdapter.getAdapterClass(scriptable, clazz2, classArray2, (Scriptable)object);
        Class[] classArray3 = new Class[]{ScriptRuntime.ScriptableClass};
        Object[] objectArray2 = new Object[]{object};
        try {
            Object t = clazz.getConstructor(classArray3).newInstance(objectArray2);
            return JavaAdapter.getAdapterSelf(clazz, t);
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    public static void writeAdapterObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        Class<?> clazz = object.getClass();
        objectOutputStream.writeObject(clazz.getSuperclass().getName());
        Class<?>[] classArray = clazz.getInterfaces();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        objectOutputStream.writeObject(stringArray);
        try {
            Object object2 = clazz.getField("delegee").get(object);
            objectOutputStream.writeObject(object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        throw new IOException();
    }

    public static Object readAdapterObject(Scriptable scriptable, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName((String)objectInputStream.readObject());
        String[] stringArray = (String[])objectInputStream.readObject();
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i]);
        }
        Scriptable scriptable2 = (Scriptable)objectInputStream.readObject();
        Class clazz2 = JavaAdapter.getAdapterClass(scriptable, clazz, classArray, scriptable2);
        Class[] classArray2 = new Class[]{ScriptRuntime.ScriptableClass, ScriptRuntime.ScriptableClass};
        Object[] objectArray = new Object[]{scriptable2, scriptable};
        try {
            return clazz2.getConstructor(classArray2).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    private static ObjToIntMap getObjectFunctionNames(Scriptable scriptable) {
        Object[] objectArray = ScriptableObject.getPropertyIds(scriptable);
        ObjToIntMap objToIntMap = new ObjToIntMap(objectArray.length);
        for (int i = 0; i != objectArray.length; ++i) {
            String string;
            Object object;
            if (!(objectArray[i] instanceof String) || !((object = ScriptableObject.getProperty(scriptable, string = (String)objectArray[i])) instanceof Function)) continue;
            Function function = (Function)object;
            int n = ScriptRuntime.toInt32(ScriptableObject.getProperty((Scriptable)function, "length"));
            if (n < 0) {
                n = 0;
            }
            objToIntMap.put(string, n);
        }
        return objToIntMap;
    }

    private static Class getAdapterClass(Scriptable scriptable, Class clazz, Class[] classArray, Scriptable scriptable2) {
        ClassCache classCache = ClassCache.get(scriptable);
        Hashtable hashtable = classCache.javaAdapterGeneratedClasses;
        ObjToIntMap objToIntMap = JavaAdapter.getObjectFunctionNames(scriptable2);
        JavaAdapterSignature javaAdapterSignature = new JavaAdapterSignature(clazz, classArray, objToIntMap);
        Class clazz2 = (Class)hashtable.get(javaAdapterSignature);
        if (clazz2 == null) {
            String string = "adapter" + classCache.newClassSerialNumber();
            byte[] byArray = JavaAdapter.createAdapterCode(objToIntMap, string, clazz, classArray, null);
            clazz2 = JavaAdapter.loadAdapterClass(string, byArray);
            if (classCache.isCachingEnabled()) {
                hashtable.put(javaAdapterSignature, clazz2);
            }
        }
        return clazz2;
    }

    public static byte[] createAdapterCode(ObjToIntMap objToIntMap, String string, Class clazz, Class[] classArray, String string2) {
        String string3;
        String string4;
        Class[] classArray2;
        String string5;
        int n;
        ClassFileWriter classFileWriter = new ClassFileWriter(string, clazz.getName(), "<adapter>");
        classFileWriter.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        classFileWriter.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int n2 = classArray == null ? 0 : classArray.length;
        for (int i = 0; i < n2; ++i) {
            if (classArray[i] == null) continue;
            classFileWriter.addInterface(classArray[i].getName());
        }
        String string6 = clazz.getName().replace('.', '/');
        JavaAdapter.generateCtor(classFileWriter, string, string6);
        JavaAdapter.generateSerialCtor(classFileWriter, string, string6);
        if (string2 != null) {
            JavaAdapter.generateEmptyCtor(classFileWriter, string, string6, string2);
        }
        ObjToIntMap objToIntMap2 = new ObjToIntMap();
        ObjToIntMap objToIntMap3 = new ObjToIntMap();
        for (int i = 0; i < n2; ++i) {
            Method[] methodArray = classArray[i].getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Method method = methodArray[j];
                n = method.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isFinal(n)) continue;
                string5 = method.getName();
                classArray2 = method.getParameterTypes();
                if (!objToIntMap.has(string5)) {
                    try {
                        clazz.getMethod(string5, classArray2);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                string4 = JavaAdapter.getMethodSignature(method, classArray2);
                string3 = string5 + string4;
                if (objToIntMap2.has(string3)) continue;
                JavaAdapter.generateMethod(classFileWriter, string, string5, classArray2, method.getReturnType());
                objToIntMap2.put(string3, 0);
                objToIntMap3.put(string5, 0);
            }
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n3 = method.getModifiers();
            if (Modifier.isStatic(n3) || Modifier.isFinal(n3)) continue;
            n = Modifier.isAbstract(n3) ? 1 : 0;
            string5 = method.getName();
            if (n == 0 && !objToIntMap.has(string5)) continue;
            classArray2 = method.getParameterTypes();
            string4 = JavaAdapter.getMethodSignature(method, classArray2);
            string3 = string5 + string4;
            if (!objToIntMap2.has(string3)) {
                JavaAdapter.generateMethod(classFileWriter, string, string5, classArray2, method.getReturnType());
                objToIntMap2.put(string3, 0);
                objToIntMap3.put(string5, 0);
            }
            if (n != 0) continue;
            JavaAdapter.generateSuper(classFileWriter, string, string6, string5, string4, classArray2, method.getReturnType());
        }
        ObjToIntMap.Iterator iterator = new ObjToIntMap.Iterator(objToIntMap);
        iterator.start();
        while (!iterator.done()) {
            String string7 = (String)iterator.getKey();
            if (!objToIntMap3.has(string7)) {
                int n4 = iterator.getValue();
                Class[] classArray3 = new Class[n4];
                for (int i = 0; i < n4; ++i) {
                    classArray3[i] = ScriptRuntime.ObjectClass;
                }
                JavaAdapter.generateMethod(classFileWriter, string, string7, classArray3, ScriptRuntime.ObjectClass);
            }
            iterator.next();
        }
        return classFileWriter.toByteArray();
    }

    public static IFGlue makeIFGlue(Class clazz, Function function) {
        ClassCache classCache = ClassCache.get(function);
        Hashtable hashtable = classCache.javaAdapterIFGlueMasters;
        IFGlue iFGlue = (IFGlue)hashtable.get(clazz);
        if (iFGlue == null) {
            Object[] objectArray;
            if (!clazz.isInterface()) {
                return null;
            }
            Method[] methodArray = clazz.getMethods();
            if (methodArray.length == 0) {
                return null;
            }
            Class[] classArray = methodArray[0].getParameterTypes();
            for (int i = 1; i != methodArray.length; ++i) {
                objectArray = methodArray[i].getParameterTypes();
                if (objectArray.length != classArray.length) {
                    return null;
                }
                for (int j = 0; j != classArray.length; ++j) {
                    if (objectArray[j] == classArray[j]) continue;
                    return null;
                }
            }
            String string = "ifglue" + classCache.newClassSerialNumber();
            objectArray = JavaAdapter.createIFGlueCode(clazz, methodArray, classArray, string);
            Class clazz2 = JavaAdapter.loadAdapterClass(string, objectArray);
            try {
                iFGlue = (IFGlue)clazz2.newInstance();
            }
            catch (Exception exception) {
                throw Context.throwAsScriptRuntimeEx(exception);
            }
            int[] nArray = JavaAdapter.getArgsToConvert(classArray);
            iFGlue.ifglue_initMaster(nArray);
            if (classCache.isCachingEnabled()) {
                hashtable.put(clazz, iFGlue);
            }
        }
        return iFGlue.ifglue_make(function);
    }

    private static byte[] createIFGlueCode(Class clazz, Method[] methodArray, Class[] classArray, String string) {
        String string2 = IFGLUE_BASE;
        ClassFileWriter classFileWriter = new ClassFileWriter(string, string2, "<ifglue>");
        classFileWriter.addInterface(clazz.getName());
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.add((byte)42);
        classFileWriter.addInvoke((byte)-73, string2, "<init>", "()V");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)1, null);
        for (int i = 0; i != methodArray.length; ++i) {
            Method method = methodArray[i];
            Class<?> clazz2 = method.getReturnType();
            StringBuffer stringBuffer = new StringBuffer();
            int n = JavaAdapter.appendMethodSignature(classArray, clazz2, stringBuffer);
            String string3 = stringBuffer.toString();
            classFileWriter.startMethod(method.getName(), string3, (short)1);
            classFileWriter.addLoadThis();
            JavaAdapter.generatePushWrappedArgs(classFileWriter, classArray, classArray.length + 1);
            classFileWriter.add((byte)89);
            classFileWriter.addPush(classArray.length);
            classFileWriter.addPush(method.getName());
            classFileWriter.add((byte)83);
            classFileWriter.addInvoke((byte)-73, string2, "ifglue_call", "([Ljava/lang/Object;)Ljava/lang/Object;");
            JavaAdapter.generateReturnResult(classFileWriter, clazz2);
            classFileWriter.stopMethod((short)n, null);
        }
        return classFileWriter.toByteArray();
    }

    private static Class loadAdapterClass(String string, byte[] byArray) {
        GeneratedClassLoader generatedClassLoader = SecurityController.createLoader(null, null);
        Class clazz = generatedClassLoader.defineClass(string, byArray);
        generatedClassLoader.linkClass(clazz);
        return clazz;
    }

    public static Function getFunction(Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(object instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", string);
        }
        return (Function)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callMethod(Scriptable scriptable, Scriptable scriptable2, Function function, Object[] objectArray, long l) {
        if (function == null) {
            return Undefined.instance;
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Context context = Context.getCurrentContext();
        if (context != null) {
            return JavaAdapter.doCall(context, scriptable, scriptable2, function, objectArray, l);
        }
        context = Context.enter();
        try {
            Object object = JavaAdapter.doCall(context, scriptable, scriptable2, function, objectArray, l);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    private static Object doCall(Context context, Scriptable scriptable, Scriptable scriptable2, Function function, Object[] objectArray, long l) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object;
            if (0L == (l & (long)(1 << i)) || (object = objectArray[i]) instanceof Scriptable) continue;
            objectArray[i] = context.getWrapFactory().wrap(context, scriptable, object, null);
        }
        try {
            return function.call(context, scriptable, scriptable2, objectArray);
        }
        catch (JavaScriptException javaScriptException) {
            throw Context.throwAsScriptRuntimeEx(javaScriptException);
        }
    }

    private static void generateCtor(ClassFileWriter classFileWriter, String string, String string2) {
        classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        classFileWriter.add((byte)42);
        classFileWriter.addInvoke((byte)-73, string2, "<init>", "()V");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)42);
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-75, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)3, null);
    }

    private static void generateSerialCtor(ClassFileWriter classFileWriter, String string, String string2) {
        classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        classFileWriter.add((byte)42);
        classFileWriter.addInvoke((byte)-73, string2, "<init>", "()V");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)44);
        classFileWriter.add((byte)-75, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)20, null);
    }

    private static void generateEmptyCtor(ClassFileWriter classFileWriter, String string, String string2, String string3) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.add((byte)42);
        classFileWriter.addInvoke((byte)-73, string2, "<init>", "()V");
        classFileWriter.add((byte)-69, string3);
        classFileWriter.add((byte)89);
        classFileWriter.addInvoke((byte)-73, string3, "<init>", "()V");
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", "runScript", "(Lorg/mozilla/javascript/Script;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)76);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)42);
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-75, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)2, null);
    }

    private static void generatePushWrappedArgs(ClassFileWriter classFileWriter, Class[] classArray, int n) {
        classFileWriter.addPush(n);
        classFileWriter.add((byte)-67, "java/lang/Object");
        int n2 = 1;
        for (int i = 0; i != classArray.length; ++i) {
            classFileWriter.add((byte)89);
            classFileWriter.addPush(i);
            n2 += JavaAdapter.generateWrapArg(classFileWriter, n2, classArray[i]);
            classFileWriter.add((byte)83);
        }
    }

    private static int generateWrapArg(ClassFileWriter classFileWriter, int n, Class clazz) {
        int n2 = 1;
        if (!clazz.isPrimitive()) {
            classFileWriter.add((byte)25, n);
        } else if (clazz == Boolean.TYPE) {
            classFileWriter.add((byte)-69, "java/lang/Boolean");
            classFileWriter.add((byte)89);
            classFileWriter.add((byte)21, n);
            classFileWriter.addInvoke((byte)-73, "java/lang/Boolean", "<init>", "(Z)V");
        } else if (clazz == Character.TYPE) {
            classFileWriter.add((byte)21, n);
            classFileWriter.addInvoke((byte)-72, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
        } else {
            classFileWriter.add((byte)-69, "java/lang/Double");
            classFileWriter.add((byte)89);
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    classFileWriter.add((byte)21, n);
                    classFileWriter.add((byte)-121);
                    break;
                }
                case 'l': {
                    classFileWriter.add((byte)22, n);
                    classFileWriter.add((byte)-118);
                    n2 = 2;
                    break;
                }
                case 'f': {
                    classFileWriter.add((byte)23, n);
                    classFileWriter.add((byte)-115);
                    break;
                }
                case 'd': {
                    classFileWriter.add((byte)24, n);
                    n2 = 2;
                }
            }
            classFileWriter.addInvoke((byte)-73, "java/lang/Double", "<init>", "(D)V");
        }
        return n2;
    }

    private static void generateReturnResult(ClassFileWriter classFileWriter, Class clazz) {
        if (clazz == Void.TYPE) {
            classFileWriter.add((byte)87);
            classFileWriter.add((byte)-79);
        } else if (clazz == Boolean.TYPE) {
            classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)Z");
            classFileWriter.add((byte)-84);
        } else if (clazz == Character.TYPE) {
            classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
            classFileWriter.add((byte)3);
            classFileWriter.addInvoke((byte)-74, "java/lang/String", "charAt", "(I)C");
            classFileWriter.add((byte)-84);
        } else if (clazz.isPrimitive()) {
            classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)D");
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    classFileWriter.add((byte)-114);
                    classFileWriter.add((byte)-84);
                    break;
                }
                case 'l': {
                    classFileWriter.add((byte)-113);
                    classFileWriter.add((byte)-83);
                    break;
                }
                case 'f': {
                    classFileWriter.add((byte)-112);
                    classFileWriter.add((byte)-82);
                    break;
                }
                case 'd': {
                    classFileWriter.add((byte)-81);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + clazz.toString());
                }
            }
        } else {
            String string = clazz.getName();
            classFileWriter.addLoadConstant(string);
            classFileWriter.addInvoke((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            classFileWriter.add((byte)-64, string.replace('.', '/'));
            classFileWriter.add((byte)-80);
        }
    }

    private static void generateMethod(ClassFileWriter classFileWriter, String string, String string2, Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = JavaAdapter.appendMethodSignature(classArray, clazz, stringBuffer);
        String string3 = stringBuffer.toString();
        classFileWriter.startMethod(string2, string3, (short)1);
        int n2 = n;
        int n3 = n + 1;
        int n4 = n + 2;
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-76, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)89);
        classFileWriter.addAStore(n2);
        classFileWriter.addPush(string2);
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "getFunction", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Function;");
        classFileWriter.add((byte)89);
        classFileWriter.addAStore(n3);
        classFileWriter.addALoad(n2);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-76, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addALoad(n3);
        JavaAdapter.generatePushWrappedArgs(classFileWriter, classArray, classArray.length);
        if (classArray.length > 64) {
            throw Context.reportRuntimeError0("JavaAdapter can not subclass methods with more then 64 arguments.");
        }
        long l = 0L;
        for (int i = 0; i != classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            l |= (long)(1 << i);
        }
        classFileWriter.addPush(l);
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Function;[Ljava/lang/Object;J)Ljava/lang/Object;");
        JavaAdapter.generateReturnResult(classFileWriter, clazz);
        classFileWriter.stopMethod((short)n4, null);
    }

    private static int generatePushParam(ClassFileWriter classFileWriter, int n, Class clazz) {
        if (!clazz.isPrimitive()) {
            classFileWriter.addALoad(n);
            return 1;
        }
        String string = clazz.getName();
        switch (string.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                classFileWriter.addILoad(n);
                return 1;
            }
            case 'l': {
                classFileWriter.addLLoad(n);
                return 2;
            }
            case 'f': {
                classFileWriter.addFLoad(n);
                return 1;
            }
            case 'd': {
                classFileWriter.addDLoad(n);
                return 2;
            }
        }
        throw Kit.codeBug();
    }

    private static void generatePopResult(ClassFileWriter classFileWriter, Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    classFileWriter.add((byte)-84);
                    break;
                }
                case 'l': {
                    classFileWriter.add((byte)-83);
                    break;
                }
                case 'f': {
                    classFileWriter.add((byte)-82);
                    break;
                }
                case 'd': {
                    classFileWriter.add((byte)-81);
                }
            }
        } else {
            classFileWriter.add((byte)-80);
        }
    }

    private static void generateSuper(ClassFileWriter classFileWriter, String string, String string2, String string3, String string4, Class[] classArray, Class clazz) {
        classFileWriter.startMethod("super$" + string3, string4, (short)1);
        classFileWriter.add((byte)25, 0);
        int n = 1;
        for (int i = 0; i < classArray.length; ++i) {
            n += JavaAdapter.generatePushParam(classFileWriter, n, classArray[i]);
        }
        classFileWriter.addInvoke((byte)-73, string2, string3, string4);
        Class clazz2 = clazz;
        if (!clazz2.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(classFileWriter, clazz2);
        } else {
            classFileWriter.add((byte)-79);
        }
        classFileWriter.stopMethod((short)(n + 1), null);
    }

    private static String getMethodSignature(Method method, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        JavaAdapter.appendMethodSignature(classArray, method.getReturnType(), stringBuffer);
        return stringBuffer.toString();
    }

    private static int appendMethodSignature(Class[] classArray, Class clazz, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        int n = 1 + classArray.length;
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            JavaAdapter.appendTypeString(stringBuffer, clazz2);
            if (clazz2 != Long.TYPE && clazz2 != Double.TYPE) continue;
            ++n;
        }
        stringBuffer.append(')');
        JavaAdapter.appendTypeString(stringBuffer, clazz);
        return n;
    }

    private static StringBuffer appendTypeString(StringBuffer stringBuffer, Class clazz) {
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            char c;
            if (clazz == Boolean.TYPE) {
                c = 'Z';
            } else if (clazz == Long.TYPE) {
                c = 'J';
            } else {
                String string = clazz.getName();
                c = Character.toUpperCase(string.charAt(0));
            }
            stringBuffer.append(c);
        } else {
            stringBuffer.append('L');
            stringBuffer.append(clazz.getName().replace('.', '/'));
            stringBuffer.append(';');
        }
        return stringBuffer;
    }

    private static int[] getArgsToConvert(Class[] classArray) {
        int n = 0;
        for (int i = 0; i != classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i != classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    static class JavaAdapterSignature {
        Class superClass;
        Class[] interfaces;
        ObjToIntMap names;

        JavaAdapterSignature(Class clazz, Class[] classArray, ObjToIntMap objToIntMap) {
            this.superClass = clazz;
            this.interfaces = classArray;
            this.names = objToIntMap;
        }

        public boolean equals(Object object) {
            if (!(object instanceof JavaAdapterSignature)) {
                return false;
            }
            JavaAdapterSignature javaAdapterSignature = (JavaAdapterSignature)object;
            if (this.superClass != javaAdapterSignature.superClass) {
                return false;
            }
            if (this.interfaces != javaAdapterSignature.interfaces) {
                if (this.interfaces.length != javaAdapterSignature.interfaces.length) {
                    return false;
                }
                for (int i = 0; i < this.interfaces.length; ++i) {
                    if (this.interfaces[i] == javaAdapterSignature.interfaces[i]) continue;
                    return false;
                }
            }
            if (this.names.size() != javaAdapterSignature.names.size()) {
                return false;
            }
            ObjToIntMap.Iterator iterator = new ObjToIntMap.Iterator(this.names);
            iterator.start();
            while (!iterator.done()) {
                String string = (String)iterator.getKey();
                int n = iterator.getValue();
                if (n != this.names.get(string, n + 1)) {
                    return false;
                }
                iterator.next();
            }
            return true;
        }

        public int hashCode() {
            return this.superClass.hashCode() | -1640531527 * (this.names.size() | this.interfaces.length << 16);
        }
    }

    public static class IFGlue
    implements Cloneable,
    Callable {
        private Function function;
        private int[] argsToConvert;

        final IFGlue ifglue_make(Function function) {
            IFGlue iFGlue;
            if (function == null) {
                Kit.codeBug();
            }
            if (this.function != null) {
                Kit.codeBug();
            }
            try {
                iFGlue = (IFGlue)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                iFGlue = null;
            }
            iFGlue.function = function;
            return iFGlue;
        }

        final void ifglue_initMaster(int[] nArray) {
            if (this.function != null) {
                Kit.codeBug();
            }
            this.argsToConvert = nArray;
        }

        protected final Object ifglue_call(Object[] objectArray) throws JavaScriptException {
            Scriptable scriptable;
            Scriptable scriptable2 = scriptable = this.function.getParentScope();
            return Context.call(this, scriptable, scriptable2, objectArray);
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
            if (this.argsToConvert != null) {
                WrapFactory wrapFactory = context.getWrapFactory();
                int n = this.argsToConvert.length;
                for (int i = 0; i != n; ++i) {
                    int n2 = this.argsToConvert[i];
                    Object object = objectArray[n2];
                    if (object == null || object instanceof Scriptable) continue;
                    objectArray[n2] = wrapFactory.wrap(context, scriptable, object, null);
                }
            }
            return this.function.call(context, scriptable, scriptable2, objectArray);
        }
    }
}

