/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class FunctionObject
extends BaseFunction {
    static final long serialVersionUID = -4074285335521944312L;
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    public static final int JAVA_UNSUPPORTED_TYPE = 0;
    public static final int JAVA_STRING_TYPE = 1;
    public static final int JAVA_INT_TYPE = 2;
    public static final int JAVA_BOOLEAN_TYPE = 3;
    public static final int JAVA_DOUBLE_TYPE = 4;
    public static final int JAVA_SCRIPTABLE_TYPE = 5;
    public static final int JAVA_OBJECT_TYPE = 6;
    MemberBox member;
    private transient byte[] typeTags;
    private int parmsLength;
    private boolean hasVoidReturn;
    private boolean isStatic;

    public FunctionObject(String string, Member member, Scriptable scriptable) {
        ClassCache classCache = ClassCache.get(scriptable);
        if (member instanceof Constructor) {
            this.member = new MemberBox((Constructor)member, classCache);
            this.isStatic = true;
        } else {
            this.member = new MemberBox((Method)member, classCache);
            this.isStatic = this.member.isStatic();
        }
        String string2 = this.member.getName();
        this.functionName = string;
        Class[] classArray = this.member.argTypes;
        int n = classArray.length;
        if (n == 4 && (classArray[1].isArray() || classArray[2].isArray())) {
            if (classArray[1].isArray()) {
                if (!this.isStatic || classArray[0] != ScriptRuntime.ContextClass || classArray[1].getComponentType() != ScriptRuntime.ObjectClass || classArray[2] != ScriptRuntime.FunctionClass || classArray[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", string2);
                }
                this.parmsLength = -2;
            } else {
                if (!this.isStatic || classArray[0] != ScriptRuntime.ContextClass || classArray[1] != ScriptRuntime.ScriptableClass || classArray[2].getComponentType() != ScriptRuntime.ObjectClass || classArray[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", string2);
                }
                this.parmsLength = -1;
            }
        } else {
            this.parmsLength = n;
            if (n > 0) {
                this.typeTags = new byte[n];
                for (int i = 0; i != n; ++i) {
                    int n2 = FunctionObject.getTypeTag(classArray[i]);
                    if (n2 == 0) {
                        throw Context.reportRuntimeError2("msg.bad.parms", classArray[i].getName(), string2);
                    }
                    this.typeTags[i] = (byte)n2;
                }
            }
        }
        if (this.member.isMethod()) {
            Method method = this.member.method();
            Class<?> clazz = method.getReturnType();
            if (clazz == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                int n3 = FunctionObject.getTypeTag(clazz);
                if (n3 == 0) {
                    throw Context.reportRuntimeError2("msg.bad.method.return", clazz.getName(), string2);
                }
            }
            this.member.prepareInvokerOptimization();
        } else {
            Class clazz = this.member.getDeclaringClass();
            if (!ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
                throw Context.reportRuntimeError1("msg.bad.ctor.return", clazz.getName());
            }
        }
        ScriptRuntime.setFunctionProtoAndParent(scriptable, this);
    }

    public static int getTypeTag(Class clazz) {
        if (clazz == ScriptRuntime.StringClass) {
            return 1;
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            return 2;
        }
        if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
            return 3;
        }
        if (clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return 4;
        }
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            return 5;
        }
        if (clazz == ScriptRuntime.ObjectClass) {
            return 6;
        }
        return 0;
    }

    public static Object convertArg(Context context, Scriptable scriptable, Object object, int n) {
        switch (n) {
            case 1: {
                if (object instanceof String) {
                    return object;
                }
                return ScriptRuntime.toString(object);
            }
            case 2: {
                if (object instanceof Integer) {
                    return object;
                }
                return new Integer(ScriptRuntime.toInt32(object));
            }
            case 3: {
                if (object instanceof Boolean) {
                    return object;
                }
                return ScriptRuntime.toBoolean(object) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Double(((Number)object).doubleValue());
                }
                return new Double(ScriptRuntime.toNumber(object));
            }
            case 5: {
                if (object instanceof Scriptable) {
                    return object;
                }
                return ScriptRuntime.toObject(context, scriptable, object);
            }
            case 6: {
                return object;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getArity() {
        return this.parmsLength < 0 ? 1 : this.parmsLength;
    }

    public int getLength() {
        return this.getArity();
    }

    public Member getMethodOrConstructor() {
        if (this.member.isMethod()) {
            return this.member.method();
        }
        return this.member.ctor();
    }

    static Method findSingleMethod(Method[] methodArray, String string) {
        Method method = null;
        int n = methodArray.length;
        for (int i = 0; i != n; ++i) {
            Method method2 = methodArray[i];
            if (method2 == null || !string.equals(method2.getName())) continue;
            if (method != null) {
                throw Context.reportRuntimeError2("msg.no.overload", string, method2.getDeclaringClass().getName());
            }
            method = method2;
        }
        return method;
    }

    static Method[] getMethodList(Class clazz) {
        Method[] methodArray = null;
        try {
            if (!sawSecurityException) {
                methodArray = clazz.getDeclaredMethods();
            }
        }
        catch (SecurityException securityException) {
            sawSecurityException = true;
        }
        if (methodArray == null) {
            methodArray = clazz.getMethods();
        }
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            if (sawSecurityException ? methodArray[i].getDeclaringClass() != clazz : !Modifier.isPublic(methodArray[i].getModifiers())) {
                methodArray[i] = null;
                continue;
            }
            ++n;
        }
        Method[] methodArray2 = new Method[n];
        int n2 = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i] == null) continue;
            methodArray2[n2++] = methodArray[i];
        }
        return methodArray2;
    }

    public void addAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        ScriptRuntime.setFunctionProtoAndParent(scriptable, this);
        this.setImmunePrototypeProperty(scriptable2);
        scriptable2.setParentScope(this);
        FunctionObject.defineProperty(scriptable2, "constructor", this, 7);
        String string = scriptable2.getClassName();
        FunctionObject.defineProperty(scriptable, string, this, 2);
        this.setParentScope(scriptable);
    }

    public static Object convertArg(Context context, Scriptable scriptable, Object object, Class clazz) {
        int n = FunctionObject.getTypeTag(clazz);
        if (n == 0) {
            throw Context.reportRuntimeError1("msg.cant.convert", clazz.getName());
        }
        return FunctionObject.convertArg(context, scriptable, object, n);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable object, Object[] objectArray) throws JavaScriptException {
        Object object2;
        int n;
        Object[] objectArray2;
        if (this.parmsLength < 0) {
            return this.callVarargs(context, (Scriptable)object, objectArray);
        }
        if (!this.isStatic && !(objectArray2 = this.member.getDeclaringClass()).isInstance(object)) {
            n = 0;
            if (object == scriptable && scriptable != (object2 = this.getParentScope()) && (n = (int)(objectArray2.isInstance(object2) ? 1 : 0)) != 0) {
                object = object2;
            }
            if (n == 0) {
                throw ScriptRuntime.typeError1("msg.incompat.call", this.functionName);
            }
        }
        if (this.parmsLength == objectArray.length) {
            objectArray2 = objectArray;
            for (n = 0; n != this.parmsLength; ++n) {
                object2 = objectArray[n];
                Object object3 = FunctionObject.convertArg(context, scriptable, object2, this.typeTags[n]);
                if (object2 == object3) continue;
                if (objectArray2 == objectArray) {
                    objectArray2 = (Object[])objectArray.clone();
                }
                objectArray2[n] = object3;
            }
        } else if (this.parmsLength == 0) {
            objectArray2 = ScriptRuntime.emptyArgs;
        } else {
            objectArray2 = new Object[this.parmsLength];
            for (n = 0; n != this.parmsLength; ++n) {
                object2 = n < objectArray.length ? objectArray[n] : Undefined.instance;
                objectArray2[n] = FunctionObject.convertArg(context, scriptable, object2, this.typeTags[n]);
            }
        }
        Object object4 = this.member.isMethod() ? this.member.invoke(object, objectArray2) : this.member.newInstance(objectArray2);
        return this.hasVoidReturn ? Undefined.instance : object4;
    }

    public Scriptable createObject(Context context, Scriptable scriptable) {
        Scriptable scriptable2;
        if (this.member.isCtor() || this.parmsLength == -2) {
            return null;
        }
        try {
            scriptable2 = (Scriptable)this.member.getDeclaringClass().newInstance();
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable2.setPrototype(this.getClassPrototype());
        scriptable2.setParentScope(this.getParentScope());
        return scriptable2;
    }

    private Object callVarargs(Context context, Scriptable scriptable, Object[] objectArray) {
        if (this.parmsLength == -1) {
            Object[] objectArray2 = new Object[]{context, scriptable, objectArray, this};
            Object object = this.member.invoke(null, objectArray2);
            return this.hasVoidReturn ? Undefined.instance : object;
        }
        boolean bl = scriptable == null;
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        Object[] objectArray3 = new Object[]{context, objectArray, this, bl2};
        return this.member.isCtor() ? this.member.newInstance(objectArray3) : this.member.invoke(null, objectArray3);
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.parmsLength > 0) {
            Class[] classArray = this.member.argTypes;
            this.typeTags = new byte[this.parmsLength];
            for (int i = 0; i != this.parmsLength; ++i) {
                this.typeTags[i] = (byte)FunctionObject.getTypeTag(classArray[i]);
            }
        }
    }
}

