/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class Delegator
implements Function {
    protected Scriptable obj = null;

    public Delegator() {
    }

    public Delegator(Scriptable scriptable) {
        this.obj = scriptable;
    }

    protected Delegator newInstance() {
        try {
            return (Delegator)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    public Scriptable getDelegee() {
        return this.obj;
    }

    public void setDelegee(Scriptable scriptable) {
        this.obj = scriptable;
    }

    public String getClassName() {
        return this.obj.getClassName();
    }

    public Object get(String string, Scriptable scriptable) {
        return this.obj.get(string, scriptable);
    }

    public Object get(int n, Scriptable scriptable) {
        return this.obj.get(n, scriptable);
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.obj.has(string, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        return this.obj.has(n, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        this.obj.put(string, scriptable, object);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        this.obj.put(n, scriptable, object);
    }

    public void delete(String string) {
        this.obj.delete(string);
    }

    public void delete(int n) {
        this.obj.delete(n);
    }

    public Scriptable getPrototype() {
        return this.obj.getPrototype();
    }

    public void setPrototype(Scriptable scriptable) {
        this.obj.setPrototype(scriptable);
    }

    public Scriptable getParentScope() {
        return this.obj.getParentScope();
    }

    public void setParentScope(Scriptable scriptable) {
        this.obj.setParentScope(scriptable);
    }

    public Object[] getIds() {
        return this.obj.getIds();
    }

    public Object getDefaultValue(Class clazz) {
        return clazz == null || clazz == ScriptRuntime.ScriptableClass || clazz == ScriptRuntime.FunctionClass ? this : this.obj.getDefaultValue(clazz);
    }

    public boolean hasInstance(Scriptable scriptable) {
        return this.obj.hasInstance(scriptable);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return ((Function)this.obj).call(context, scriptable, scriptable2, objectArray);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        if (this.obj == null) {
            Delegator delegator = this.newInstance();
            Scriptable scriptable2 = objectArray.length == 0 ? Undefined.instance : ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            delegator.setDelegee(scriptable2);
            return delegator;
        }
        return ((Function)this.obj).construct(context, scriptable, objectArray);
    }
}

