/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.fax;

import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.graphic.XGraphic;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.fax.CGFax;
import com.sun.star.wizards.fax.CGFaxWizard;
import com.sun.star.wizards.fax.FaxDocument;
import com.sun.star.wizards.fax.FaxWizardDialog;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.ui.PathSelection;
import com.sun.star.wizards.ui.XPathSelectionListener;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.RadioDataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import java.util.Vector;

public class FaxWizardDialogImpl
extends FaxWizardDialog {
    static FaxDocument myFaxDoc;
    static boolean running;
    XTextDocument xTextDocument;
    PathSelection myPathSelection;
    CGFaxWizard myConfig;
    Vector mainDA = new Vector();
    Vector faxDA = new Vector();
    String[][] BusinessFiles;
    String[][] PrivateFiles;
    String sTemplatePath;
    String sUserTemplatePath;
    String sBitmapPath;
    String sFaxPath;
    String sWorkPath;
    String sPath;
    boolean bEditTemplate;
    boolean bSaveSuccess = false;
    private boolean filenameChanged = false;
    static final int RM_TYPESTYLE = 1;
    static final int RM_ELEMENTS = 2;
    static final int RM_SENDERRECEIVER = 3;
    static final int RM_FOOTER = 4;
    static final int RM_FINALSETTINGS = 5;

    public FaxWizardDialogImpl(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    public static void main(String[] stringArray) {
        try {
            String string = "uno:socket,host=127.0.0.1,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.NamingService";
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect(string);
            FaxWizardDialogImpl faxWizardDialogImpl = new FaxWizardDialogImpl(xMultiServiceFactory);
            faxWizardDialogImpl.startWizard(xMultiServiceFactory, null);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startWizard(XMultiServiceFactory xMultiServiceFactory, Object[] objectArray) {
        running = true;
        try {
            this.setMaxStep(5);
            myFaxDoc = new FaxDocument(xMultiServiceFactory, this);
            this.drawNaviBar();
            this.buildStep1();
            this.buildStep2();
            this.buildStep3();
            this.buildStep4();
            this.buildStep5();
            this.initializeSalutation();
            this.initializeGreeting();
            this.initializeCommunication();
            this.initializePaths();
            this.insertPathSelectionControl();
            this.initConfiguration();
            this.initializeTemplates(xMultiServiceFactory);
            this.updateUI();
            if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
                this.myPathSelection.initializePath();
            }
            XWindow xWindow = FaxWizardDialogImpl.myFaxDoc.xFrame.getContainerWindow();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)XWindowPeer.class, (Object)xWindow);
            this.createWindowPeer(xWindowPeer);
            this.insertRoadmap();
            this.setConfiguration();
            this.setDefaultForGreetingAndSalutationAndCommunication();
            this.initializeElements();
            FaxWizardDialogImpl.myFaxDoc.xFrame.getComponentWindow().setEnable(false);
            this.executeDialog((XInterface)FaxWizardDialogImpl.myFaxDoc.xFrame);
            this.removeTerminateListener();
            this.closeDocument();
            running = false;
        }
        catch (com.sun.star.uno.Exception exception) {
            this.removeTerminateListener();
            exception.printStackTrace(System.out);
            running = false;
            return;
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
        running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishWizard() {
        this.switchToStep(this.getCurrentStep(), this.getMaxStep());
        myFaxDoc.setWizardTemplateDocInfo(this.resources.resFaxWizardDialog_title, this.resources.resTemplateDescription);
        try {
            int n;
            FileAccess fileAccess = new FileAccess(this.xMSF);
            this.sPath = this.myPathSelection.getSelectedPath();
            if (this.sPath.equals("")) {
                this.myPathSelection.triggerPathPicker();
                this.sPath = this.myPathSelection.getSelectedPath();
            }
            this.sPath = fileAccess.getURL(this.sPath);
            if (!this.filenameChanged && fileAccess.exists(this.sPath, true) && (n = SystemDialog.showMessageBox(this.xMSF, this.xControl.getPeer(), "MessBox", -2130706432, this.resources.resOverwriteWarning)) == 3) {
                return;
            }
            myFaxDoc.setWizardTemplateDocInfo(this.resources.resFaxWizardDialog_title, this.resources.resTemplateDescription);
            myFaxDoc.killEmptyUserFields();
            FaxWizardDialogImpl.myFaxDoc.keepLogoFrame = this.chkUseLogo.getState() != 0;
            FaxWizardDialogImpl.myFaxDoc.keepTypeFrame = this.chkUseCommunicationType.getState() != 0;
            myFaxDoc.killEmptyFrames();
            this.bSaveSuccess = OfficeDocument.store(this.xMSF, (XComponent)this.xTextDocument, this.sPath, "writer8_template", false, "Template could not be saved to" + this.sPath);
            if (this.bSaveSuccess) {
                this.saveConfiguration();
                XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface((Class)XInteractionHandler.class, (Object)this.xMSF.createInstance("com.sun.star.comp.uui.UUIInteractionHandler"));
                PropertyValue[] propertyValueArray = new PropertyValue[4];
                propertyValueArray[0] = new PropertyValue();
                propertyValueArray[0].Name = "AsTemplate";
                propertyValueArray[1] = new PropertyValue();
                propertyValueArray[1].Name = "MacroExecutionMode";
                propertyValueArray[1].Value = new Short(2);
                propertyValueArray[2] = new PropertyValue();
                propertyValueArray[2].Name = "UpdateDocMode";
                propertyValueArray[2].Value = new Short(3);
                propertyValueArray[3] = new PropertyValue();
                propertyValueArray[3].Name = "InteractionHandler";
                propertyValueArray[3].Value = xInteractionHandler;
                propertyValueArray[0].Value = this.bEditTemplate ? Boolean.FALSE : Boolean.TRUE;
                Object object = OfficeDocument.load((XInterface)Desktop.getDesktop(this.xMSF), this.sPath, "_default", propertyValueArray);
                XTextDocument xTextDocument = (XTextDocument)object;
                XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)XMultiServiceFactory.class, (Object)xTextDocument);
                ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, xTextDocument);
                viewHandler.setViewSetting("ZoomType", new Short(0));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.xDialog.endExecute();
            running = false;
        }
    }

    public void closeDocument() {
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)XCloseable.class, (Object)FaxWizardDialogImpl.myFaxDoc.xFrame);
            xCloseable.close(false);
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }

    public void insertRoadmap() {
        this.addRoadmap();
        int n = 0;
        n = this.insertRoadmapItem(0, true, this.resources.RoadmapLabels[1], 1);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[2], 2);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[3], 3);
        n = this.insertRoadmapItem(n, false, this.resources.RoadmapLabels[4], 4);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[5], 5);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    public void insertPathSelectionControl() {
        this.myPathSelection = new PathSelection(this.xMSF, this, 0, 1);
        this.myPathSelection.insert(5, 97, 70, 205, (short)45, this.resources.reslblTemplatePath_value, true, "HID:41153", "HID:41154");
        this.myPathSelection.sDefaultDirectory = this.sUserTemplatePath;
        this.myPathSelection.sDefaultName = "myFaxTemplate.ott";
        this.myPathSelection.sDefaultFilter = "writer8_template";
        this.myPathSelection.addSelectionListener(new myPathSelectionListener());
    }

    private void insertIcons() {
        try {
            Object object = this.xMSF.createInstance("com.sun.star.graphic.GraphicProvider");
            XGraphicProvider xGraphicProvider = (XGraphicProvider)UnoRuntime.queryInterface((Class)XGraphicProvider.class, (Object)object);
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "URL";
            propertyValueArray[0].Value = "private:resource/svx/imagelist/18000/18022";
            XGraphic xGraphic = xGraphicProvider.queryGraphic(propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateUI() {
        UnoDataAware.updateUI(this.mainDA);
        UnoDataAware.updateUI(this.faxDA);
    }

    private void initializePaths() {
        try {
            this.sTemplatePath = FileAccess.getOfficePath(this.xMSF, "Template", "share", "/wizard");
            this.sUserTemplatePath = FileAccess.getOfficePath(this.xMSF, "Template", "user", "");
            this.sBitmapPath = FileAccess.combinePaths(this.xMSF, this.sTemplatePath, "/wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
        }
    }

    public boolean initializeTemplates(XMultiServiceFactory xMultiServiceFactory) {
        try {
            String string = "/wizard/fax";
            this.sFaxPath = FileAccess.combinePaths(xMultiServiceFactory, this.sTemplatePath, string);
            this.sWorkPath = FileAccess.getOfficePath(xMultiServiceFactory, "Work", "", "");
            this.BusinessFiles = FileAccess.getFolderTitles(xMultiServiceFactory, "bus", this.sFaxPath);
            this.PrivateFiles = FileAccess.getFolderTitles(xMultiServiceFactory, "pri", this.sFaxPath);
            this.setControlProperty("lstBusinessStyle", "StringItemList", this.BusinessFiles[0]);
            this.setControlProperty("lstPrivateStyle", "StringItemList", this.PrivateFiles[0]);
            this.setControlProperty("lstBusinessStyle", "SelectedItems", new short[]{0});
            this.setControlProperty("lstPrivateStyle", "SelectedItems", new short[]{0});
            return true;
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
            return false;
        }
    }

    public void initializeElements() {
        this.setControlProperty("chkUseLogo", "Enabled", new Boolean(myFaxDoc.hasElement("Company Logo")));
        this.setControlProperty("chkUseSubject", "Enabled", new Boolean(myFaxDoc.hasElement("Subject Line")));
        this.setControlProperty("chkUseDate", "Enabled", new Boolean(myFaxDoc.hasElement("Date")));
        myFaxDoc.updateDateFields();
    }

    public void initializeSalutation() {
        this.setControlProperty("lstSalutation", "StringItemList", this.resources.SalutationLabels);
    }

    public void initializeGreeting() {
        this.setControlProperty("lstGreeting", "StringItemList", this.resources.GreetingLabels);
    }

    public void initializeCommunication() {
        this.setControlProperty("lstCommunicationType", "StringItemList", this.resources.CommunicationLabels);
    }

    private void setDefaultForGreetingAndSalutationAndCommunication() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstSalutation);
        if (xTextComponent.getText().equals("")) {
            xTextComponent.setText(this.resources.SalutationLabels[0]);
        }
        if ((xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstGreeting)).getText().equals("")) {
            xTextComponent.setText(this.resources.GreetingLabels[0]);
        }
        if ((xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstCommunicationType)).getText().equals("")) {
            xTextComponent.setText(this.resources.CommunicationLabels[0]);
        }
    }

    public void initConfiguration() {
        try {
            this.myConfig = new CGFaxWizard();
            Object object = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Fax", false);
            this.myConfig.readConfiguration(object, "cp_");
            this.mainDA.add(RadioDataAware.attachRadioButtons(this.myConfig, "cp_FaxType", new Object[]{this.optBusinessFax, this.optPrivateFax}, null, true));
            this.mainDA.add(UnoDataAware.attachListBox(this.myConfig.cp_BusinessFax, "cp_Style", this.lstBusinessStyle, null, true));
            this.mainDA.add(UnoDataAware.attachListBox(this.myConfig.cp_PrivateFax, "cp_Style", this.lstPrivateStyle, null, true));
            CGFax cGFax = this.myConfig.cp_BusinessFax;
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_PrintCompanyLogo", this.chkUseLogo, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_PrintSubjectLine", this.chkUseSubject, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_PrintSalutation", this.chkUseSalutation, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_PrintDate", this.chkUseDate, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_PrintCommunicationType", this.chkUseCommunicationType, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_PrintGreeting", this.chkUseGreeting, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_PrintFooter", this.chkUseFooter, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_Salutation", this.lstSalutation, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_Greeting", this.lstGreeting, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_CommunicationType", this.lstCommunicationType, null, true));
            this.faxDA.add(RadioDataAware.attachRadioButtons(cGFax, "cp_SenderAddressType", new Object[]{this.optSenderDefine, this.optSenderPlaceholder}, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_SenderCompanyName", this.txtSenderName, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_SenderStreet", this.txtSenderStreet, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_SenderPostCode", this.txtSenderPostCode, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_SenderState", this.txtSenderState, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_SenderCity", this.txtSenderCity, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_SenderFax", this.txtSenderFax, null, true));
            this.faxDA.add(RadioDataAware.attachRadioButtons(cGFax, "cp_ReceiverAddressType", new Object[]{this.optReceiverDatabase, this.optReceiverPlaceholder}, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_Footer", this.txtFooter, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_FooterOnlySecondPage", this.chkFooterNextPages, null, true));
            this.faxDA.add(UnoDataAware.attachCheckBox(cGFax, "cp_FooterPageNumbers", this.chkFooterPageNumbers, null, true));
            this.faxDA.add(RadioDataAware.attachRadioButtons(cGFax, "cp_CreationType", new Object[]{this.optCreateFax, this.optMakeChanges}, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_TemplateName", this.txtTemplateName, null, true));
            this.faxDA.add(UnoDataAware.attachEditControl(cGFax, "cp_TemplatePath", this.myPathSelection.xSaveTextBox, null, true));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveConfiguration() {
        try {
            Object object = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Fax", true);
            this.myConfig.writeConfiguration(object, "cp_");
            Configuration.commit(object);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setConfiguration() {
        if (this.optBusinessFax.getState()) {
            this.optBusinessFaxItemChanged();
        }
        if (this.optPrivateFax.getState()) {
            this.optPrivateFaxItemChanged();
        }
    }

    public void optBusinessFaxItemChanged() {
        DataAware.setDataObject(this.faxDA, this.myConfig.cp_BusinessFax, true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.FALSE);
        this.lstBusinessStyleItemChanged();
        this.enableSenderReceiver();
        this.setPossibleFooter(true);
    }

    public void lstBusinessStyleItemChanged() {
        this.xTextDocument = myFaxDoc.loadAsPreview(this.BusinessFiles[1][this.lstBusinessStyle.getSelectedItemPos()], false);
        this.initializeElements();
        this.setElements();
    }

    public void optPrivateFaxItemChanged() {
        DataAware.setDataObject(this.faxDA, this.myConfig.cp_PrivateFax, true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.TRUE);
        this.lstPrivateStyleItemChanged();
        this.disableSenderReceiver();
        this.setPossibleFooter(false);
    }

    public void lstPrivateStyleItemChanged() {
        this.xTextDocument = myFaxDoc.loadAsPreview(this.PrivateFiles[1][this.lstPrivateStyle.getSelectedItemPos()], false);
        this.initializeElements();
        this.setElements();
    }

    public void txtTemplateNameTextChanged() {
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface((Class)XDocumentInfoSupplier.class, (Object)this.xTextDocument);
        XDocumentInfo xDocumentInfo = xDocumentInfoSupplier.getDocumentInfo();
        String string = this.txtTemplateName.getText();
        Helper.setUnoPropertyValue(xDocumentInfo, "Title", string);
    }

    public void optSenderPlaceholderItemChanged() {
        this.setControlProperty("lblSenderName", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblSenderStreet", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPostCodeCity", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblSenderFax", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderName", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderStreet", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderPostCode", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderState", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderCity", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderFax", "Enabled", Boolean.FALSE);
        myFaxDoc.fillSenderWithUserData();
    }

    public void optSenderDefineItemChanged() {
        this.setControlProperty("lblSenderName", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblSenderStreet", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPostCodeCity", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblSenderFax", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderName", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderStreet", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderPostCode", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderState", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderCity", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderFax", "Enabled", Boolean.TRUE);
        this.txtSenderNameTextChanged();
        this.txtSenderStreetTextChanged();
        this.txtSenderPostCodeTextChanged();
        this.txtSenderStateTextChanged();
        this.txtSenderCityTextChanged();
        this.txtSenderFaxTextChanged();
    }

    public void optReceiverPlaceholderItemChanged() {
        OfficeDocument.attachEventCall((XComponent)this.xTextDocument, "OnNew", "StarBasic", "macro:///Template.Correspondence.Placeholder()");
    }

    public void optReceiverDatabaseItemChanged() {
        OfficeDocument.attachEventCall((XComponent)this.xTextDocument, "OnNew", "StarBasic", "macro:///Template.Correspondence.Database()");
    }

    public void optCreateFaxItemChanged() {
        this.bEditTemplate = false;
    }

    public void optMakeChangesItemChanged() {
        this.bEditTemplate = true;
    }

    public void txtSenderNameTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(FaxWizardDialogImpl.myFaxDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("Company", this.txtSenderName.getText());
    }

    public void txtSenderStreetTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(FaxWizardDialogImpl.myFaxDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("Street", this.txtSenderStreet.getText());
    }

    public void txtSenderCityTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(FaxWizardDialogImpl.myFaxDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("City", this.txtSenderCity.getText());
    }

    public void txtSenderPostCodeTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(FaxWizardDialogImpl.myFaxDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("PostCode", this.txtSenderPostCode.getText());
    }

    public void txtSenderStateTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(FaxWizardDialogImpl.myFaxDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("State", this.txtSenderState.getText());
    }

    public void txtSenderFaxTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(FaxWizardDialogImpl.myFaxDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("Fax", this.txtSenderFax.getText());
    }

    public void setElements() {
        if (this.optSenderDefine.getState()) {
            this.optSenderDefineItemChanged();
        }
        if (this.optSenderPlaceholder.getState()) {
            this.optSenderPlaceholderItemChanged();
        }
        this.chkUseLogoItemChanged();
        this.chkUseSubjectItemChanged();
        this.chkUseSalutationItemChanged();
        this.chkUseGreetingItemChanged();
        this.chkUseCommunicationItemChanged();
        this.chkUseDateItemChanged();
        this.chkUseFooterItemChanged();
        this.txtTemplateNameTextChanged();
        if (this.optReceiverDatabase.getState()) {
            this.optReceiverDatabaseItemChanged();
        }
        if (this.optReceiverPlaceholder.getState()) {
            this.optReceiverPlaceholderItemChanged();
        }
        if (this.optCreateFax.getState()) {
            this.optCreateFaxItemChanged();
        }
        if (this.optMakeChanges.getState()) {
            this.optMakeChangesItemChanged();
        }
    }

    public void chkUseLogoItemChanged() {
        if (myFaxDoc.hasElement("Company Logo")) {
            myFaxDoc.switchElement("Company Logo", this.chkUseLogo.getState() != 0);
        }
    }

    public void chkUseSubjectItemChanged() {
        if (myFaxDoc.hasElement("Subject Line")) {
            myFaxDoc.switchElement("Subject Line", this.chkUseSubject.getState() != 0);
        }
    }

    public void chkUseDateItemChanged() {
        if (myFaxDoc.hasElement("Date")) {
            myFaxDoc.switchElement("Date", this.chkUseDate.getState() != 0);
        }
    }

    public void chkUseFooterItemChanged() {
        try {
            boolean bl;
            boolean bl2 = bl = this.chkUseFooter.getState() != 0 && AnyConverter.toBoolean((Object)this.getControlProperty("chkUseFooter", "Enabled"));
            if (this.chkFooterNextPages.getState() != 0) {
                myFaxDoc.switchFooter("First Page", false, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
                myFaxDoc.switchFooter("Standard", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
            } else {
                myFaxDoc.switchFooter("First Page", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
                myFaxDoc.switchFooter("Standard", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
            }
            XInterface xInterface = this.getRoadmapItemByID(4);
            Helper.setUnoPropertyValue(xInterface, "Enabled", new Boolean(bl));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void chkFooterNextPagesItemChanged() {
        this.chkUseFooterItemChanged();
    }

    public void chkFooterPageNumbersItemChanged() {
        this.chkUseFooterItemChanged();
    }

    public void txtFooterTextChanged() {
        this.chkUseFooterItemChanged();
    }

    public void chkUseSalutationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstSalutation);
        myFaxDoc.switchUserField("Salutation", xTextComponent.getText(), this.chkUseSalutation.getState() != 0);
        this.setControlProperty("lstSalutation", "Enabled", new Boolean(this.chkUseSalutation.getState() != 0));
    }

    public void lstSalutationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstSalutation);
        myFaxDoc.switchUserField("Salutation", xTextComponent.getText(), this.chkUseSalutation.getState() != 0);
    }

    public void lstSalutationTextChanged() {
    }

    public void chkUseCommunicationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstCommunicationType);
        myFaxDoc.switchUserField("CommunicationType", xTextComponent.getText(), this.chkUseCommunicationType.getState() != 0);
        this.setControlProperty("lstCommunicationType", "Enabled", new Boolean(this.chkUseCommunicationType.getState() != 0));
    }

    public void lstCommunicationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstCommunicationType);
        myFaxDoc.switchUserField("CommunicationType", xTextComponent.getText(), this.chkUseCommunicationType.getState() != 0);
    }

    public void lstCommunicationTextChanged() {
    }

    public void chkUseGreetingItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstGreeting);
        myFaxDoc.switchUserField("Greeting", xTextComponent.getText(), this.chkUseGreeting.getState() != 0);
        this.setControlProperty("lstGreeting", "Enabled", new Boolean(this.chkUseGreeting.getState() != 0));
    }

    public void lstGreetingItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface((Class)XTextComponent.class, (Object)this.lstGreeting);
        myFaxDoc.switchUserField("Greeting", xTextComponent.getText(), this.chkUseGreeting.getState() != 0);
    }

    public void lstGreetingTextChanged() {
    }

    private void setPossibleFooter(boolean bl) {
        this.setControlProperty("chkUseFooter", "Enabled", new Boolean(bl));
        if (!bl) {
            this.chkUseFooter.setState((short)0);
        }
        this.chkUseFooterItemChanged();
    }

    private void enableSenderReceiver() {
        XInterface xInterface = this.getRoadmapItemByID(3);
        Helper.setUnoPropertyValue(xInterface, "Enabled", Boolean.TRUE);
    }

    private void disableSenderReceiver() {
        XInterface xInterface = this.getRoadmapItemByID(3);
        Helper.setUnoPropertyValue(xInterface, "Enabled", Boolean.FALSE);
    }

    private class myPathSelectionListener
    implements XPathSelectionListener {
        private myPathSelectionListener() {
        }

        public void validatePath() {
            if (FaxWizardDialogImpl.this.myPathSelection.usedPathPicker) {
                FaxWizardDialogImpl.this.filenameChanged = true;
            }
            FaxWizardDialogImpl.this.myPathSelection.usedPathPicker = false;
        }
    }
}

