/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class ReflectionCallback
implements Callback {
    private Method method;
    private Class type;
    private String methodName;
    private Class[] argumentTypes;
    private boolean isRestArgs;
    private Arity arity;
    private boolean isStaticMethod;
    private boolean fast;

    public ReflectionCallback(Class type, String methodName, Class[] argumentTypes, boolean isRestArgs, boolean isStaticMethod, Arity arity, boolean fast) {
        this.type = type;
        this.methodName = methodName;
        this.argumentTypes = argumentTypes;
        this.isRestArgs = isRestArgs;
        this.isStaticMethod = isStaticMethod;
        this.arity = arity;
        this.fast = fast;
        assert (type != null);
        assert (methodName != null);
        assert (arity != null);
        this.loadMethod(fast);
    }

    private void loadMethod(boolean fast) {
        Class[] args;
        Class[] types;
        if (this.isStaticMethod) {
            types = new Class[this.argumentTypes.length + 1];
            System.arraycopy(this.argumentTypes, 0, types, 1, this.argumentTypes.length);
            types[0] = IRubyObject.class;
            args = types;
        } else {
            args = this.argumentTypes;
        }
        if (!fast) {
            types = new Class[args.length + 1];
            System.arraycopy(args, 0, types, 0, args.length);
            types[args.length] = Block.class;
            args = types;
        }
        try {
            this.method = this.type.getMethod(this.methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("NoSuchMethodException: Cannot get method \"" + this.methodName + "\" in class \"" + this.type.getName() + "\" by Reflection.");
        }
        catch (SecurityException e) {
            throw new RuntimeException("SecurityException: Cannot get method \"" + this.methodName + "\" in class \"" + this.type.getName() + "\" by Reflection.");
        }
    }

    protected final Object[] packageRestArgumentsForReflection(Object[] originalArgs) {
        IRubyObject[] restArray = new IRubyObject[originalArgs.length - (this.argumentTypes.length - 1)];
        Object[] result = new Object[this.argumentTypes.length];
        try {
            System.arraycopy(originalArgs, this.argumentTypes.length - 1, restArray, 0, originalArgs.length - (this.argumentTypes.length - 1));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            assert (false) : e;
            return null;
        }
        System.arraycopy(originalArgs, 0, result, 0, this.argumentTypes.length - 1);
        result[this.argumentTypes.length - 1] = restArray;
        return result;
    }

    public IRubyObject execute(IRubyObject recv, IRubyObject[] oargs, Block block) {
        this.arity.checkArity(recv.getRuntime(), oargs);
        Object[] methodArgs = oargs;
        if (this.isRestArgs) {
            methodArgs = this.packageRestArgumentsForReflection(methodArgs);
        }
        try {
            IRubyObject receiver = recv;
            if (this.isStaticMethod) {
                Object[] args = new Object[methodArgs.length + (this.fast ? 1 : 2)];
                System.arraycopy(methodArgs, 0, args, 1, methodArgs.length);
                args[0] = recv;
                if (!this.fast) {
                    args[methodArgs.length + 1] = block;
                }
                receiver = null;
                methodArgs = args;
            } else {
                Object[] args = new Object[methodArgs.length + (this.fast ? 0 : 1)];
                System.arraycopy(methodArgs, 0, args, 0, methodArgs.length);
                if (!this.fast) {
                    args[methodArgs.length] = block;
                }
                methodArgs = args;
            }
            return (IRubyObject)this.method.invoke((Object)receiver, methodArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RaiseException) {
                throw (RaiseException)e.getTargetException();
            }
            if (e.getTargetException() instanceof JumpException) {
                throw (JumpException)e.getTargetException();
            }
            if (e.getTargetException() instanceof ThreadKill) {
                throw (ThreadKill)e.getTargetException();
            }
            if (e.getTargetException() instanceof Exception) {
                if (e.getTargetException() instanceof MainExitException) {
                    throw (RuntimeException)e.getTargetException();
                }
                recv.getRuntime().getJavaSupport().handleNativeException(e.getTargetException());
                return recv.getRuntime().getNil();
            }
            throw (Error)e.getTargetException();
        }
        catch (IllegalAccessException e) {
            StringBuilder message = new StringBuilder();
            message.append(e.getMessage());
            message.append(':');
            message.append(" methodName=").append(this.methodName);
            message.append(" recv=").append(recv.toString());
            message.append(" type=").append(this.type.getName());
            message.append(" methodArgs=[");
            for (int i = 0; i < methodArgs.length; ++i) {
                message.append(methodArgs[i]);
                message.append(' ');
            }
            message.append(']');
            assert (false) : message.toString();
            return null;
        }
        catch (IllegalArgumentException e) {
            assert (false) : e;
            return null;
        }
    }

    public Arity getArity() {
        return this.arity;
    }
}

