/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;
    private ISourcePosition position;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.restArg = argsNode.getRestArg();
        this.hasOptArgs = argsNode.getOptArgs() != null;
        this.position = position;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public Script getJITCompilerScript() {
        return this.jitCompiledScript;
    }

    public void setJITCompiledScript(Script jitCompiledScript) {
        this.jitCompiledScript = jitCompiledScript;
    }

    public CallConfiguration getJITCallConfig() {
        return this.jitCallConfig;
    }

    public void setJITCallConfig(CallConfiguration jitCallConfig) {
        this.jitCallConfig = jitCallConfig;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        Ruby runtime = context.getRuntime();
        if (runtime.getInstanceConfig().getCompileMode().shouldJIT()) {
            runtime.getJITCompiler().runJIT(this, context, name);
        }
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block);
                this.getArity().checkArity(runtime, args);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.interpretedCall(context, runtime, self, clazz, name, args, block);
    }

    public IRubyObject interpretedCall(ThreadContext context, Ruby runtime, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        try {
            RubyModule implementer = this.getImplementationClass();
            context.preMethodFrameAndScope(implementer, name, self, block, this.staticScope, this);
            if (this.argsNode.getBlockArgNode() != null) {
                context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(runtime, block), 0);
            }
            this.getArity().checkArity(runtime, args);
            this.prepareArguments(context, runtime, args);
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            IRubyObject iRubyObject = this.body.interpret(runtime, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
        finally {
            if (runtime.hasEventHooks()) {
                this.traceReturn(context, runtime, name);
            }
            context.postMethodFrameAndScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, args, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, IRubyObject.NULL_ARRAY, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2}, block);
    }

    private void jitPre(ThreadContext context, IRubyObject self, String name, Block block) {
        RubyModule implementer = this.getImplementationClass();
        this.jitCallConfig.pre(context, self, implementer, name, block, this.staticScope, this);
    }

    private void jitPost(Ruby runtime, ThreadContext context, String name) {
        if (runtime.hasEventHooks()) {
            this.traceReturn(context, runtime, name);
        }
        this.jitCallConfig.post(context);
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        if (this.requiredArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + this.requiredArgsCount + ")");
        }
        if (this.requiredArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime, args);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        int givenArgsCount = this.requiredArgsCount;
        int maximumArgs = this.requiredArgsCount;
        if (this.argsNode.getOptArgs() != null && this.restArg == -1 && (maximumArgs += this.argsNode.getOptArgs().size()) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + maximumArgs + ")");
        }
        if (this.hasOptArgs) {
            int i;
            ListNode optArgs = this.argsNode.getOptArgs();
            int j = 0;
            for (i = this.requiredArgsCount; i < args.length && j < optArgs.size(); ++i, ++j) {
                optArgs.get(j).assign(runtime, context, context.getFrameSelf(), args[i], Block.NULL_BLOCK, true);
                ++givenArgsCount;
            }
            i = 0;
            while (j < optArgs.size()) {
                optArgs.get(j).interpret(runtime, context, context.getFrameSelf(), Block.NULL_BLOCK);
                ++i;
                ++j;
            }
        }
        if (this.restArg != -1 && this.restArg >= 0) {
            RubyArray array = runtime.newArray(args.length - givenArgsCount);
            for (int i = givenArgsCount; i < args.length; ++i) {
                array.append(args[i]);
            }
            context.getCurrentScope().setValue(this.restArg, array, 0);
        }
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        runtime.callEventHooks(context, 4, context.getFile(), context.getLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        runtime.callEventHooks(context, 3, this.position.getFile(), this.position.getStartLine(), name, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

