/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.compiler.ASTInspector;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalAsgnNode
extends AssignableNode
implements INameNode {
    private String name;
    private final int location;

    public LocalAsgnNode(ISourcePosition position, String name, int location, Node valueNode) {
        super(position, NodeType.LOCALASGNNODE, valueNode);
        this.name = name;
        this.location = location;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitLocalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return LocalAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (ASTInspector.PRAGMAS.contains(this.name)) {
            return runtime.getNil();
        }
        return context.getCurrentScope().setValue(this.getIndex(), this.getValueNode().interpret(runtime, context, self, aBlock), this.getDepth());
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        context.getCurrentScope().setValue(this.getIndex(), value, this.getDepth());
        return runtime.getNil();
    }
}

