/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.InterpreterVariable;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Instruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionSequence;

public class Interpreter {
    private Instruction[] fInstructions;
    private int fInstructionCounter;
    private IRuntimeContext fContext;
    private Stack fStack;
    private IJavaValue fLastValue;
    private Map fInternalVariables;
    private boolean fStopped = false;

    public Interpreter(InstructionSequence instructions, IRuntimeContext context) {
        this.fInstructions = instructions.getInstructions();
        this.fContext = context;
        this.fInternalVariables = new HashMap();
    }

    public void execute() throws CoreException {
        this.reset();
        while (this.fInstructionCounter < this.fInstructions.length && !this.fStopped) {
            Instruction instruction = this.fInstructions[this.fInstructionCounter++];
            instruction.setInterpreter(this);
            instruction.execute();
            instruction.setInterpreter(null);
        }
    }

    public void stop() {
        this.fStopped = true;
    }

    private void reset() {
        this.fStack = new Stack();
        this.fInstructionCounter = 0;
    }

    public void jump(int offset) {
        this.fInstructionCounter += offset;
    }

    public void push(Object object) {
        this.fStack.push(object);
    }

    public Object peek() {
        return this.fStack.peek();
    }

    public Object pop() {
        return this.fStack.pop();
    }

    public IRuntimeContext getContext() {
        return this.fContext;
    }

    public IJavaValue getResult() {
        if (this.fStack == null || this.fStack.isEmpty()) {
            if (this.fLastValue == null) {
                return this.getContext().getVM().voidValue();
            }
            return this.fLastValue;
        }
        Object top = this.fStack.peek();
        if (top instanceof IJavaVariable) {
            try {
                return (IJavaValue)((IJavaVariable)top).getValue();
            }
            catch (CoreException exception) {
                return this.getContext().getVM().newValue(exception.getStatus().getMessage());
            }
        }
        if (top instanceof IJavaValue) {
            return (IJavaValue)top;
        }
        return null;
    }

    public void setLastValue(IJavaValue value) {
        this.fLastValue = value;
    }

    public IVariable createInternalVariable(String name, IJavaType referencType) {
        InterpreterVariable var = new InterpreterVariable(name, referencType, this.fContext.getVM());
        this.fInternalVariables.put(name, var);
        return var;
    }

    public IVariable getInternalVariable(String name) {
        return (IVariable)this.fInternalVariables.get(name);
    }
}

