/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitRuntimeClasspathEntry;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.util.Assert;
import org.osgi.framework.Bundle;

class ClasspathLocalizer {
    private boolean fInDevelopmentMode;

    protected ClasspathLocalizer() {
        this(false);
    }

    public ClasspathLocalizer(boolean inDevelopmentMode) {
        this.fInDevelopmentMode = inDevelopmentMode;
    }

    protected List localizeClasspath(ITestKind kind) {
        JUnitRuntimeClasspathEntry[] entries = kind.getClasspathEntries();
        ArrayList junitEntries = new ArrayList();
        int i = 0;
        while (i < entries.length) {
            try {
                this.addEntry(junitEntries, entries[i]);
            }
            catch (IOException iOException) {
                Assert.isTrue((boolean)false, (String)(String.valueOf(entries[i].getPluginId()) + " is available (required JAR)"));
            }
            ++i;
        }
        return junitEntries;
    }

    private void addEntry(List junitEntries, JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException {
        String entryString = this.entryString(entry);
        if (entryString != null) {
            junitEntries.add(entryString);
        }
    }

    private String entryString(JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException {
        if (this.inDevelopmentMode()) {
            try {
                return this.localURL(entry.developmentModeEntry());
            }
            catch (IOException iOException) {}
        }
        return this.localURL(entry);
    }

    private boolean inDevelopmentMode() {
        return this.fInDevelopmentMode;
    }

    private String localURL(JUnitRuntimeClasspathEntry jar) throws IOException, MalformedURLException {
        Bundle bundle = JUnitPlugin.getDefault().getBundle(jar.getPluginId());
        URL url = jar.getPluginRelativePath() == null ? bundle.getEntry("/") : bundle.getEntry(jar.getPluginRelativePath());
        if (url == null) {
            throw new IOException();
        }
        return FileLocator.toFileURL((URL)url).getFile();
    }
}

