/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.viewer;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroExtensionContent;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroInclude;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.IntroSeparator;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;

public class IntroModelLabelProvider
extends LabelProvider {
    static {
        ImageUtil.registerImage("container", "container_obj.gif");
        ImageUtil.registerImage("leaf", "topic.gif");
    }

    public Image getImage(Object element) {
        Image image = null;
        AbstractIntroElement introElement = null;
        if (element instanceof AbstractIntroElement) {
            introElement = (AbstractIntroElement)element;
        }
        if (introElement == null) {
            return null;
        }
        int elementType = introElement.getType();
        switch (elementType) {
            case 4: 
            case 8: 
            case 16: {
                image = ImageUtil.getImage("container");
                break;
            }
            default: {
                image = ImageUtil.getImage("leaf");
            }
        }
        return image;
    }

    public String getText(Object element) {
        String label = null;
        AbstractIntroElement introElement = null;
        if (element instanceof AbstractIntroElement) {
            introElement = (AbstractIntroElement)element;
        }
        if (introElement == null) {
            return null;
        }
        int elementType = introElement.getType();
        switch (elementType) {
            case 16: {
                label = "GROUP: " + ((IntroGroup)introElement).getLabel();
                break;
            }
            case 64: {
                label = "LINK: " + ((IntroLink)introElement).getLabel();
                break;
            }
            case 512: {
                label = "TEXT: " + ((IntroText)introElement).getText();
                break;
            }
            case 128: {
                label = "IMAGE: " + ((IntroImage)introElement).getId();
                break;
            }
            case 524288: {
                label = "HR: " + ((IntroSeparator)introElement).getId();
                break;
            }
            case 32: {
                label = "HTML: " + ((IntroHTML)introElement).getId();
                break;
            }
            case 256: {
                label = "Unresolved INCLUDE: " + ((IntroInclude)introElement).getPath();
                break;
            }
            case 8: {
                label = "PAGE: " + ((AbstractIntroPage)introElement).getId();
                break;
            }
            case 4: {
                label = "HOME PAGE: " + ((AbstractIntroPage)introElement).getTitle();
                break;
            }
            case 2: {
                label = "PRESENTATION: " + ((IntroPartPresentation)introElement).getImplementationKind();
                break;
            }
            case 16384: {
                label = "CONTENT PROVIDER: " + ((IntroContentProvider)introElement).getClassName();
                break;
            }
            case 1024: {
                label = "Unresolved ConfigExtension: " + ((IntroExtensionContent)introElement).getPath();
                break;
            }
            default: {
                label = super.getText(element);
            }
        }
        return label;
    }
}

