/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;

public class ExpressionManagerModelProxy
extends AbstractModelProxy
implements IExpressionsListener {
    public void init(IPresentationContext context) {
        super.init(context);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionsListener)this);
    }

    public synchronized void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionsListener)this);
    }

    public void expressionsAdded(IExpression[] expressions) {
        this.updateExpressions(expressions, 1);
    }

    public void expressionsRemoved(IExpression[] expressions) {
        this.updateExpressions(expressions, 2);
    }

    public void expressionsChanged(IExpression[] expressions) {
        this.updateExpressions(expressions, 3072);
    }

    private void updateExpressions(IExpression[] expressions, int flags) {
        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getExpressionManager(), 0);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            delta.addNode(expression, flags);
            ++i;
        }
        this.fireModelChanged(delta);
    }
}

