/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.accesscontrol;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Authorization Identifier</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier#getOwnedSchema <em>Owned Schema</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier#getReceivedRoleAuthorization <em>Received Role Authorization</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier#getGrantedRoleAuthorization <em>Granted Role Authorization</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier#getGrantedPrivilege <em>Granted Privilege</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier#getReceivedPrivilege <em>Received Privilege</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getAuthorizationIdentifier()
 * @model abstract="true"
 * @generated
 */
public interface AuthorizationIdentifier extends SQLObject{
	/**
	 * Returns the value of the '<em><b>Owned Schema</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.wst.rdb.internal.models.sql.schema.Schema}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.schema.Schema#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owned Schema</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owned Schema</em>' reference list.
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getAuthorizationIdentifier_OwnedSchema()
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.Schema#getOwner
	 * @model type="org.eclipse.wst.rdb.internal.models.sql.schema.Schema" opposite="owner"
	 * @generated
	 */
	EList getOwnedSchema();

	/**
	 * Returns the value of the '<em><b>Received Role Authorization</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization#getGrantee <em>Grantee</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Received Role Authorization</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Received Role Authorization</em>' reference list.
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getAuthorizationIdentifier_ReceivedRoleAuthorization()
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization#getGrantee
	 * @model type="org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization" opposite="grantee"
	 * @generated
	 */
	EList getReceivedRoleAuthorization();

	/**
	 * Returns the value of the '<em><b>Granted Role Authorization</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization#getGrantor <em>Grantor</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Granted Role Authorization</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Granted Role Authorization</em>' reference list.
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getAuthorizationIdentifier_GrantedRoleAuthorization()
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization#getGrantor
	 * @model type="org.eclipse.wst.rdb.internal.models.sql.accesscontrol.RoleAuthorization" opposite="grantor"
	 * @generated
	 */
	EList getGrantedRoleAuthorization();

	/**
	 * Returns the value of the '<em><b>Granted Privilege</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getGrantor <em>Grantor</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Granted Privilege</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Granted Privilege</em>' reference list.
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getAuthorizationIdentifier_GrantedPrivilege()
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getGrantor
	 * @model type="org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege" opposite="grantor"
	 * @generated
	 */
	EList getGrantedPrivilege();

	/**
	 * Returns the value of the '<em><b>Received Privilege</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Received Privilege</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Received Privilege</em>' containment reference list.
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getAuthorizationIdentifier_ReceivedPrivilege()
	 * @model type="org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege" containment="true"
	 * @generated
	 */
	EList getReceivedPrivilege();

} // AuthorizationIdentifier
