/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.saxparser;

import org.eclipse.wst.dtd.core.internal.saxparser.XMLCharacterProperties;

public class StringParser {
    String fData = null;
    int fEndOffset;
    int fMostRecentChar;
    int fCurrentOffset;
    boolean fCalledCharPropInit = false;
    public static final byte[] fgAsciiEntityValueChar;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 4;
        byArray[1] = 4;
        byArray[2] = 4;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 4;
        byArray[6] = 4;
        byArray[7] = 4;
        byArray[8] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 4;
        byArray[17] = 4;
        byArray[18] = 4;
        byArray[19] = 4;
        byArray[20] = 4;
        byArray[21] = 4;
        byArray[22] = 4;
        byArray[23] = 4;
        byArray[24] = 4;
        byArray[25] = 4;
        byArray[26] = 4;
        byArray[27] = 4;
        byArray[28] = 4;
        byArray[29] = 4;
        byArray[30] = 4;
        byArray[31] = 4;
        byArray[34] = 1;
        byArray[37] = 3;
        byArray[38] = 2;
        byArray[39] = 1;
        fgAsciiEntityValueChar = byArray;
    }

    public StringParser(String data) {
        this.fData = data;
        this.fCurrentOffset = 0;
        this.fEndOffset = this.fData.length();
        this.fMostRecentChar = this.fEndOffset == 0 ? -1 : (int)this.fData.charAt(0);
    }

    public String getString(int offset, int length) {
        if (length == 0) {
            return "";
        }
        return this.fData.substring(offset, offset + length);
    }

    public String getData() {
        return this.fData;
    }

    public String getRemainingString() {
        return this.fData.substring(this.getCurrentOffset());
    }

    public int getCurrentOffset() {
        return this.fCurrentOffset;
    }

    public int loadNextChar() {
        this.fMostRecentChar = ++this.fCurrentOffset >= this.fEndOffset ? -1 : (int)this.fData.charAt(this.fCurrentOffset);
        return this.fMostRecentChar;
    }

    public boolean lookingAtChar(char chr, boolean skipPastChar) {
        int ch = this.fMostRecentChar;
        if (ch != chr) {
            return false;
        }
        if (skipPastChar) {
            this.fMostRecentChar = ++this.fCurrentOffset >= this.fEndOffset ? -1 : (int)this.fData.charAt(this.fCurrentOffset);
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean skipPastChar) {
        int ch = this.fMostRecentChar;
        if (ch < 55296) {
            if (ch < 32 && ch != 9 && ch != 10 && ch != 13) {
                return false;
            }
            if (skipPastChar) {
                this.fMostRecentChar = ++this.fCurrentOffset >= this.fEndOffset ? -1 : (int)this.fData.charAt(this.fCurrentOffset);
            }
            return true;
        }
        if (ch > 65533) {
            return false;
        }
        if (ch < 56320) {
            if (this.fCurrentOffset + 1 >= this.fEndOffset) {
                return false;
            }
            ch = this.fData.charAt(this.fCurrentOffset + 1);
            if (ch < 56320 || ch >= 57344) {
                return false;
            }
            if (!skipPastChar) {
                return true;
            }
            ++this.fCurrentOffset;
        } else if (ch < 57344) {
            return false;
        }
        if (skipPastChar) {
            this.fMostRecentChar = ++this.fCurrentOffset >= this.fEndOffset ? -1 : (int)this.fData.charAt(this.fCurrentOffset);
        }
        return true;
    }

    public boolean lookingAtSpace(boolean skipPastChar) {
        int ch = this.fMostRecentChar;
        if (ch > 32) {
            return false;
        }
        if (ch == 32 || ch == 10 || ch == 13 || ch == 9) {
            if (skipPastChar) {
                this.loadNextChar();
            }
            return true;
        }
        return false;
    }

    public void skipToChar(char chr, boolean skipPastChar) {
        int ch = this.fMostRecentChar;
        while (true) {
            if (ch == chr) {
                if (skipPastChar) {
                    this.loadNextChar();
                }
                return;
            }
            if (ch == -1) {
                return;
            }
            ch = this.loadNextChar();
        }
    }

    public void skipPastSpaces() {
        int ch = this.fMostRecentChar;
        if (ch == -1) {
            return;
        }
        while (true) {
            if (ch > 32 || ch != 32 && ch != 10 && ch != 9 && ch != 13) {
                this.fMostRecentChar = ch;
                return;
            }
            if (++this.fCurrentOffset >= this.fEndOffset) {
                return;
            }
            ch = this.fData.charAt(this.fCurrentOffset);
        }
    }

    public void skipPastNameAndPEReference(char fastcheck) {
        int ch = this.fMostRecentChar;
        if (ch != 37) {
            if (ch < 128) {
                if (ch == -1 || XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                    return;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                    return;
                }
            }
        }
        while (true) {
            if (fastcheck == (ch = this.loadNextChar())) {
                return;
            }
            if (ch == 37 || ch == 59) continue;
            if (ch < 128) {
                if (ch != -1 && XMLCharacterProperties.fgAsciiNameChar[ch] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
        }
    }

    public void skipPastName(char fastcheck) {
        int ch = this.fMostRecentChar;
        if (ch < 128) {
            if (ch == -1 || XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                return;
            }
        }
        while (true) {
            if (fastcheck == (ch = this.loadNextChar())) {
                return;
            }
            if (ch < 128) {
                if (ch != -1 && XMLCharacterProperties.fgAsciiNameChar[ch] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
        }
    }

    public void skipPastNmtoken(char fastcheck) {
        int ch = this.fMostRecentChar;
        while (fastcheck != ch) {
            if (ch < 128) {
                if (ch == -1 || XMLCharacterProperties.fgAsciiNameChar[ch] == 0) {
                    return;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                    return;
                }
            }
            ch = this.loadNextChar();
        }
        return;
    }

    public void skipPastNmtokenAndPEReference(char fastcheck) {
        int ch = this.fMostRecentChar;
        while (fastcheck != ch) {
            if (ch == 37 || ch == 59) {
                ch = this.loadNextChar();
                continue;
            }
            if (ch < 128) {
                if (ch == -1 || XMLCharacterProperties.fgAsciiNameChar[ch] == 0) {
                    return;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                    return;
                }
            }
            ch = this.loadNextChar();
        }
        return;
    }

    public boolean skippedString(char[] s) {
        int ch = this.fMostRecentChar;
        if (ch != s[0]) {
            return false;
        }
        if (this.fCurrentOffset + s.length > this.fEndOffset) {
            return false;
        }
        int i = 1;
        while (i < s.length) {
            if (this.fData.charAt(this.fCurrentOffset + i) != s[i]) {
                return false;
            }
            ++i;
        }
        this.fCurrentOffset += s.length - 1;
        this.loadNextChar();
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int ch = this.fMostRecentChar;
        this.loadNextChar();
        return ch;
    }

    public boolean scanAttValue(char qchar) {
        boolean result = true;
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtChar(' ', true) || this.lookingAtValidChar(true)) continue;
            result = false;
        }
        this.lookingAtChar(qchar, true);
        return result;
    }
}

