/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers;

import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConnectionManagedListener;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerNavigationService;

public class ServerExplorerManager {
    public static final ServerExplorerManager INSTANCE = new ServerExplorerManager();
    private static final ConnectionManager connectionManager = RDBCorePlugin.getDefault().getConnectionManager();
    private IKnownConnectionNode knownServer;
    private IServerExplorerContentService serverExplorerService;
    private ServerExplorerConnectionManagedListener connectionListener;

    private void initializeListeners() {
        this.connectionListener = new ServerExplorerConnectionManagedListener();
        connectionManager.addListener((ConnectionManagerListener)this.connectionListener);
    }

    private void removeListeners() {
        if (this.connectionListener != null) {
            connectionManager.removeListener((ConnectionManagerListener)this.connectionListener);
            this.connectionListener.dispose();
            this.connectionListener = null;
        }
    }

    public void setServerExplorerService(IServerExplorerContentService serverExplorerService) {
        this.serverExplorerService = serverExplorerService;
        if (this.serverExplorerService != null) {
            this.initializeListeners();
        } else {
            this.removeListeners();
            if (this.knownServer != null) {
                this.knownServer.removeAllChildren();
            }
        }
    }

    public void setRootKnownServerNode(IKnownConnectionNode knownServer) {
        this.knownServer = knownServer;
    }

    public IKnownConnectionNode getRootKnownServerNode() {
        return this.knownServer;
    }

    public void initializeConnectionInfo(ConnectionInfo info) {
        this.connectionListener.connectionInfoCreated(info);
    }

    public IServerExplorerContentService getServerExplorerContentService() {
        return this.serverExplorerService;
    }

    public IServerExplorerNavigationService getServerExplorerNavigationService() {
        return (IServerExplorerNavigationService)((Object)this.serverExplorerService);
    }
}

