/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.css.core.internal.document;

import java.util.regex.Pattern;
import org.eclipse.jst.jsp.css.core.internal.document.JSPCSSImportRuleImpl;
import org.eclipse.jst.jsp.css.core.internal.document.JSPCSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelCreationContext;
import org.eclipse.wst.css.core.internal.document.CSSModelParser;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSRuleContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocumentRegion;

class JSPedCSSModelParser
extends CSSModelParser {
    public JSPedCSSModelParser(ICSSDocument doc) {
        super(doc);
    }

    protected CSSNodeImpl insertStructuredDocumentRegion(IStructuredDocumentRegion region) {
        CSSModelCreationContext creationContext = this.getCreationContext();
        if (creationContext == null || region == null) {
            return null;
        }
        String type = ((BasicStructuredDocumentRegion)region).getType();
        CSSNodeImpl modified = null;
        if (type == "CSS_JSP_DIRECTIVE") {
            boolean isInclude = region.getText().indexOf("include") != -1;
            modified = isInclude ? this.insertUnknownImport(region) : this.insertUnknownRule(region);
        }
        if (modified != null && modified instanceof CSSStructuredDocumentRegionContainer) {
            ((CSSStructuredDocumentRegionContainer)modified).propagateRangeStructuredDocumentRegion();
        }
        return modified != null ? modified : super.insertStructuredDocumentRegion(region);
    }

    private CSSNodeImpl insertUnknownImport(IStructuredDocumentRegion region) {
        CSSModelCreationContext creationContext = this.getCreationContext();
        CSSNodeImpl parent = creationContext.getTargetNode();
        ICSSDocument sheet = parent.getOwnerDocument();
        String text = region.getText();
        Pattern pattern = Pattern.compile(" ");
        String[] strs = pattern.split(text);
        String hrefValue = null;
        int i = 0;
        while (i < strs.length) {
            String hrefStr = "file=\"";
            if (strs[i].startsWith(hrefStr)) {
                int hrefStr_length = hrefStr.length();
                int hrefValue_length = strs[i].length() - 1;
                if (hrefValue_length > hrefStr_length) {
                    hrefValue = strs[i].substring(hrefStr_length, hrefValue_length);
                    break;
                }
                hrefValue = null;
                break;
            }
            ++i;
        }
        if (hrefValue == null) {
            return null;
        }
        JSPCSSImportRuleImpl rule = new JSPCSSImportRuleImpl();
        rule.setOwnerDocument(sheet);
        rule.appendChild((CSSNodeImpl)sheet.createMediaList());
        rule.setRangeStructuredDocumentRegion(region, region);
        if (!this.isUpdateContextActive()) {
            rule.setHref(hrefValue);
        }
        if (!this.isUpdateContextActive() && parent != null) {
            CSSNodeImpl next = creationContext.getNextNode();
            if (next != null) {
                ((CSSNodeImpl)sheet).insertBefore((CSSNodeImpl)rule, next);
            } else {
                ((CSSNodeImpl)sheet).appendChild((CSSNodeImpl)rule);
            }
        }
        return rule;
    }

    private CSSNodeImpl insertUnknownRule(IStructuredDocumentRegion flatNode) {
        CSSModelCreationContext creationContext = this.getCreationContext();
        CSSNodeImpl parent = creationContext.getTargetNode();
        if (!this.isParseFloating() && !(parent instanceof ICSSRuleContainer)) {
            return null;
        }
        JSPCSSNodeImpl rule = new JSPCSSNodeImpl(flatNode.getText());
        rule.setOwnerDocument(parent.getOwnerDocument());
        rule.setRangeStructuredDocumentRegion(flatNode, flatNode);
        if (!this.isUpdateContextActive() && parent != null) {
            this.propagateRangePreInsert(parent, (CSSNodeImpl)rule);
            CSSNodeImpl next = creationContext.getNextNode();
            if (next != null) {
                parent.insertBefore((CSSNodeImpl)rule, next);
            } else {
                parent.appendChild((CSSNodeImpl)rule);
            }
        }
        return rule;
    }
}

