/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jst.ws.util.JspUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DomElementHelper {
    public static Element createDomElementFromXMLString(String xmlString) {
        StringReader stringReader = new StringReader(xmlString);
        InputSource inputSource = new InputSource(stringReader);
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(inputSource);
            return document.getDocumentElement();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String domWriter(Node node, StringBuffer buffer) {
        if (node == null) {
            return "";
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                buffer.append(String.valueOf(JspUtils.markup("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) + "<br>");
                DomElementHelper.domWriter(((Document)node).getDocumentElement(), buffer);
                break;
            }
            case 1: {
                buffer.append(JspUtils.markup("<" + node.getNodeName()));
                Attr[] attrs = DomElementHelper.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    buffer.append(" " + attr.getNodeName() + "=\"" + JspUtils.markup(attr.getNodeValue()) + "\"");
                    ++i;
                }
                buffer.append(JspUtils.markup(">"));
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int len = children.getLength();
                    int i2 = 0;
                    while (i2 < len) {
                        if (children.item(i2).getNodeType() == 1) {
                            buffer.append("<br>");
                        }
                        DomElementHelper.domWriter(children.item(i2), buffer);
                        ++i2;
                    }
                }
                buffer.append(JspUtils.markup("</" + node.getNodeName() + ">"));
                break;
            }
            case 5: {
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    buffer.append(children.item(i));
                    ++i;
                }
                break;
            }
            case 4: {
                buffer.append(JspUtils.markup(node.getNodeValue()));
                break;
            }
            case 3: {
                buffer.append(JspUtils.markup(node.getNodeValue()));
                break;
            }
            case 7: {
                buffer.append(JspUtils.markup("<?"));
                buffer.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    buffer.append(" ");
                    buffer.append(data);
                }
                buffer.append(JspUtils.markup("?>"));
            }
        }
        return buffer.toString();
    }

    public static Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        i = 0;
        while (i < len - 1) {
            String name = array[i].getNodeName();
            int index = i;
            int j = i + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i) {
                Attr temp = array[i];
                array[i] = array[index];
                array[index] = temp;
            }
            ++i;
        }
        return array;
    }
}

