/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Map;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.GC;

public abstract class UpdateManager {
    private UpdateListener[] listeners = new UpdateListener[0];
    private boolean disposed;

    public abstract void addDirtyRegion(IFigure var1, int var2, int var3, int var4, int var5);

    public void addDirtyRegion(IFigure figure, Rectangle rect) {
        this.addDirtyRegion(figure, rect.x, rect.y, rect.width, rect.height);
    }

    public void runWithUpdate(Runnable run) {
    }

    public abstract void addInvalidFigure(IFigure var1);

    public void addUpdateListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            this.listeners = new UpdateListener[1];
            this.listeners[0] = listener;
        } else {
            int oldSize = this.listeners.length;
            UpdateListener[] newListeners = new UpdateListener[oldSize + 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
            newListeners[oldSize] = listener;
            this.listeners = newListeners;
        }
    }

    public void dispose() {
        this.disposed = true;
    }

    protected void firePainting(Rectangle damage, Map dirtyRegions) {
        UpdateListener[] localListeners = this.listeners;
        int i = 0;
        while (i < localListeners.length) {
            localListeners[i].notifyPainting(damage, dirtyRegions);
            ++i;
        }
    }

    protected void fireValidating() {
        UpdateListener[] localListeners = this.listeners;
        int i = 0;
        while (i < localListeners.length) {
            localListeners[i].notifyValidating();
            ++i;
        }
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    public abstract void performUpdate();

    void paint(GC gc) {
        this.performUpdate(new Rectangle(gc.getClipping()));
    }

    public abstract void performUpdate(Rectangle var1);

    public void removeUpdateListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int index = 0;
        while (index < this.listeners.length) {
            if (this.listeners[index] == listener) {
                int newSize = this.listeners.length - 1;
                UpdateListener[] newListeners = null;
                if (newSize != 0) {
                    newListeners = new UpdateListener[newSize];
                    System.arraycopy(this.listeners, 0, newListeners, 0, index);
                    System.arraycopy(this.listeners, index + 1, newListeners, index, newSize - index);
                }
                this.listeners = newListeners;
                return;
            }
            ++index;
        }
    }

    public abstract void setGraphicsSource(GraphicsSource var1);

    public abstract void setRoot(IFigure var1);

    public void performValidation() {
        this.performUpdate();
    }
}

