/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.reports.nextactions;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamFont;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    public String getID() {
        return "next-actions";
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>(3);
        params.add((Param)new ParamBoolean("show-project", this.getString("param-show-project-thought")));
        params.add((Param)new ParamBoolean("colour", this.getString("param-use-colour")));
        params.add((Param)new ParamFont("font", this.getString("param-font")));
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> params = this.getParams();
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        File xmlfile = ReportImpl.getTmpFile((String)"data.xml");
        this.extractData(data, xmlfile, Extract.FormatType.XML);
        URL xslfoURL = ((Object)((Object)this)).getClass().getResource("next-actions.fo.xml");
        File outfile = ReportImpl.getOutFile((String)(this.getID() + "-" + ReportImpl.getTimeStamp() + ".pdf"));
        this.transformXSLFO(xmlfile, xslfoURL, params, outfile);
        ReportImpl.openFile((File)outfile);
    }
}

