/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class BirdViewWindow
extends JWindow
implements MouseMotionListener {
    private Scene scene;
    private BirdViewComponent birdView;
    private boolean shown = false;
    private double zoomFactor = 3.0;
    private Point scenePoint;
    private WidgetAction action = new SceneTrackAction();
    private ViewAncestorListener ancestorListener = new ViewAncestorListener();

    public BirdViewWindow(Scene scene) {
        this.scene = scene;
        this.setSize(new Dimension(256, 256));
        this.setLayout(new BorderLayout());
        this.setAlwaysOnTop(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new CompoundBorder(new LineBorder(Color.BLACK, 1), new EmptyBorder(1, 1, 1, 1)));
        jPanel.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.birdView = new BirdViewComponent();
        this.birdView.setDoubleBuffered(true);
        jPanel.add((Component)this.birdView, "Center");
    }

    public void invokeShow() {
        if (this.scene.getView() == null) {
            return;
        }
        if (this.shown) {
            return;
        }
        this.shown = true;
        this.birdView.addMouseMotionListener(this);
        this.scene.getPriorActions().addAction(this.action);
        this.scene.getView().addAncestorListener(this.ancestorListener);
        this.updateForViewPoint(null);
    }

    public void invokeHide() {
        if (!this.shown) {
            return;
        }
        this.shown = false;
        this.birdView.removeMouseMotionListener(this);
        this.scene.getPriorActions().removeAction(this.action);
        this.scene.getView().removeAncestorListener(this.ancestorListener);
        this.updateForViewPoint(null);
    }

    public void invokeRepaint() {
        this.birdView.repaint();
    }

    public void setZoomFactor(double d) {
        this.zoomFactor = d;
        this.invokeRepaint();
    }

    public void setWindowSize(Dimension dimension) {
        Dimension dimension2 = this.getSize();
        this.setSize(dimension);
        if (this.isShowing()) {
            Point point = this.getLocation();
            this.setLocation(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
            this.validate();
        }
    }

    private void updateForViewPoint(Point point) {
        JComponent jComponent = this.scene.getView();
        if (!this.shown || point == null || !jComponent.getVisibleRect().contains(point)) {
            this.scenePoint = null;
            this.setVisible(false);
            this.dispose();
            return;
        }
        this.scenePoint = this.scene.convertViewToScene(point);
        Point point2 = jComponent.getLocationOnScreen();
        Dimension dimension = this.getSize();
        this.setBounds(point2.x + point.x - dimension.width / 2, point2.y + point.y - dimension.height / 2, dimension.width, dimension.height);
        this.setVisible(true);
        this.birdView.repaint();
    }

    private void updateForBirdViewPoint(Point point) {
        JComponent jComponent = this.scene.getView();
        if (jComponent.isShowing() && this.isShowing()) {
            Point point2 = jComponent.getLocationOnScreen();
            Point point3 = this.getLocationOnScreen();
            Dimension dimension = this.getSize();
            this.updateForViewPoint(new Point(point.x + point3.x - point2.x, point.y + point3.y - point2.y));
        } else {
            this.updateForViewPoint(null);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateForBirdViewPoint(mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateForBirdViewPoint(mouseEvent.getPoint());
    }

    private class BirdViewComponent
    extends JComponent {
        private BirdViewComponent() {
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            super.paint(graphics);
            if (BirdViewWindow.this.scenePoint == null) {
                graphics2D.setColor(Color.BLACK);
                graphics2D.fill(this.getBounds());
                return;
            }
            Dimension dimension = this.getSize();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(dimension.width / 2, dimension.height / 2);
            graphics2D.scale(BirdViewWindow.this.zoomFactor, BirdViewWindow.this.zoomFactor);
            graphics2D.translate(-((BirdViewWindow)BirdViewWindow.this).scenePoint.x, -((BirdViewWindow)BirdViewWindow.this).scenePoint.y);
            BirdViewWindow.this.scene.paint(graphics2D);
            graphics2D.setTransform(affineTransform);
        }
    }

    private class SceneTrackAction
    implements WidgetAction {
        private SceneTrackAction() {
        }

        public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseEntered(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseExited(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            BirdViewWindow.this.updateForViewPoint(widget.getScene().convertSceneToView(widget.convertLocalToScene(widgetMouseEvent.getPoint())));
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseMoved(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            BirdViewWindow.this.updateForViewPoint(widget.getScene().convertSceneToView(widget.convertLocalToScene(widgetMouseEvent.getPoint())));
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State mouseWheelMoved(Widget widget, WidgetAction.WidgetMouseWheelEvent widgetMouseWheelEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State keyReleased(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State focusGained(Widget widget, WidgetAction.WidgetFocusEvent widgetFocusEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State focusLost(Widget widget, WidgetAction.WidgetFocusEvent widgetFocusEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State dragEnter(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State dragOver(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State dropActionChanged(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State dragExit(Widget widget, WidgetAction.WidgetDropTargetEvent widgetDropTargetEvent) {
            return WidgetAction.State.CONSUMED;
        }

        public WidgetAction.State drop(Widget widget, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
            return WidgetAction.State.CONSUMED;
        }
    }

    private class ViewAncestorListener
    implements AncestorListener {
        private ViewAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            BirdViewWindow.this.invokeHide();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }
}

