/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openide.explorer.propertysheet.PSheet;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class DescriptionComponent
extends JComponent
implements ActionListener,
MouseListener,
Accessible {
    private static int fontHeight = -1;
    private JEditorPane jep;
    private JLabel lbl;
    private JButton btn;
    private JToolBar toolbar;
    private JScrollPane jsc;

    public DescriptionComponent() {
        this.init();
    }

    private void init() {
        Object object;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jep = new JEditorPane();
        this.jep.setOpaque(false);
        this.jep.setBackground(this.getBackground());
        this.jep.setEditable(false);
        this.jep.setOpaque(false);
        this.jep.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptionComponent.class, (String)"ACS_Description"));
        this.jep.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptionComponent.class, (String)"ACSD_Description"));
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        if (hTMLEditorKit.getStyleSheet().getStyleSheets() == null) {
            object = new StyleSheet();
            Font font = new JLabel().getFont();
            ((StyleSheet)object).addRule(new StringBuffer("body { font-size: ").append(font.getSize()).append("; font-family: ").append(font.getName()).append("; }").toString());
            ((StyleSheet)object).addStyleSheet(hTMLEditorKit.getStyleSheet());
            hTMLEditorKit.setStyleSheet((StyleSheet)object);
        }
        this.jep.setEditorKit(hTMLEditorKit);
        this.jsc = new JScrollPane(this.jep);
        this.jsc.setHorizontalScrollBarPolicy(31);
        this.jsc.setVerticalScrollBarPolicy(21);
        this.jsc.setBorder(BorderFactory.createEmptyBorder());
        this.jsc.setViewportBorder(this.jsc.getBorder());
        this.jsc.setOpaque(false);
        this.jsc.setBackground(this.getBackground());
        this.jsc.getViewport().setOpaque(false);
        if (!PropUtils.psNoHelpButton) {
            object = Utilities.loadImage((String)"org/openide/resources/propertysheet/propertySheetHelp.png", (boolean)true);
            this.btn = new JButton(new ImageIcon((Image)object));
            this.btn.addActionListener(this);
            this.toolbar = new JToolBar();
            this.toolbar.setRollover(true);
            this.toolbar.setFloatable(false);
            this.toolbar.setLayout(new BorderLayout(0, 0));
            this.toolbar.setBorder(BorderFactory.createEmptyBorder());
            this.toolbar.add(this.btn);
            this.btn.setFocusable(false);
        }
        this.lbl = new JLabel("Label");
        this.lbl.setFont(new Font(null, 1, this.lbl.getFont().getSize()));
        this.add(this.jsc);
        this.add(this.lbl);
        if (!PropUtils.psNoHelpButton) {
            this.add(this.toolbar);
        }
        this.jep.addMouseListener(this);
        this.jsc.addMouseListener(this);
        this.lbl.addMouseListener(this);
        if (!PropUtils.psNoHelpButton) {
            this.btn.addMouseListener(this);
        }
        this.jsc.getViewport().addMouseListener(this);
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        Dimension dimension = this.lbl.getPreferredSize();
        int n = dimension.height;
        int n2 = this.getWidth() - insets.right;
        if (!PropUtils.psNoHelpButton) {
            Dimension dimension2 = this.toolbar.getPreferredSize();
            n = Math.max(dimension2.height, dimension.height);
            n2 = this.getWidth() - (insets.right + dimension2.width);
            this.toolbar.setBounds(n2, insets.top, dimension2.width, n);
        }
        this.lbl.setBounds(insets.left, insets.top, n2, n);
        this.jsc.setBounds(insets.left, n, this.getWidth() - (insets.left + insets.right), this.getHeight() - n);
    }

    public void setDescription(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.lbl.setText(string);
        if (string.equals(string2)) {
            this.jep.setText("");
        } else {
            this.jep.setText(string2);
        }
    }

    public void setHelpEnabled(boolean bl) {
        if (!PropUtils.psNoHelpButton) {
            this.btn.setEnabled(bl);
        }
    }

    public void paint(Graphics graphics) {
        if (fontHeight == -1) {
            fontHeight = graphics.getFontMetrics(this.lbl.getFont()).getHeight();
        }
        super.paint(graphics);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(super.getPreferredSize());
        if (fontHeight > 0) {
            Insets insets = this.getInsets();
            dimension.height = Math.max(50, Math.max(dimension.height, 4 * fontHeight + insets.top + insets.bottom + 12));
        } else {
            dimension.height = Math.min(dimension.height, 64);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        if (fontHeight < 0) {
            return super.getMinimumSize();
        }
        Dimension dimension = new Dimension(4 * fontHeight, 4 * fontHeight);
        return dimension;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PSheet pSheet = (PSheet)SwingUtilities.getAncestorOfClass(PSheet.class, this);
        if (pSheet != null) {
            pSheet.helpRequested();
        }
    }

    private PSheet findSheet() {
        return (PSheet)SwingUtilities.getAncestorOfClass(PSheet.class, this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        PSheet pSheet = this.findSheet();
        if (pSheet != null) {
            pSheet.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        PSheet pSheet = this.findSheet();
        if (pSheet != null) {
            pSheet.mousePressed(mouseEvent);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (null == this.accessibleContext) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.SWING_COMPONENT;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(DescriptionComponent.class, (String)"ACS_Description"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(DescriptionComponent.class, (String)"ACSD_Description"));
        }
        return this.accessibleContext;
    }
}

