/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CloseAllButThisAction
extends AbstractAction
implements PropertyChangeListener,
Runnable {
    private TopComponent tc;
    private boolean isContext;

    public CloseAllButThisAction() {
        this.isContext = false;
        this.putValue("Name", NbBundle.getMessage(CloseAllButThisAction.class, (String)"CTL_CloseAllButThisAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public CloseAllButThisAction(TopComponent topComponent, boolean bl) {
        this.tc = topComponent;
        this.isContext = bl;
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_CloseAllButThisAction"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this.obtainTC();
        if (topComponent != null) {
            ActionUtils.closeAllExcept(topComponent, this.isContext);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("activated".equals(string) || "opened".equals(string)) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        Mutex.EVENT.readAccess((Runnable)this);
    }

    public void run() {
        TopComponent topComponent = this.obtainTC();
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
        boolean bl = this.isContext ? modeImpl.getOpenedTopComponents().size() > 1 : windowManagerImpl.getEditorTopComponents().length > 1;
        this.setEnabled(modeImpl != null && modeImpl.getKind() == 1 && bl);
    }

    private TopComponent obtainTC() {
        return this.tc == null ? TopComponent.getRegistry().getActivated() : this.tc;
    }

    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("CloseAllButThis", object);
        } else {
            super.putValue(string, object);
        }
    }

    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("CloseAllButThis");
        }
        return super.getValue(string);
    }
}

