/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.UIExceptions;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.BeanNode;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IDESettings {
    private static final IDESettings INSTANCE = new IDESettings();
    public static final String PROP_SHOW_TOOLTIPS_IN_IDE = "showToolTipsInIDE";
    public static final String PROP_CONFIRM_DELETE = "confirmDelete";
    public static final String PROP_HOME_PAGE = "homePage";
    public static final String PROP_SHOW_FILE_EXTENSIONS = "showFileExtensions";
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_IGNORED_FILES = "IgnoredFiles";

    public static IDESettings getInstance() {
        return INSTANCE;
    }

    static Preferences getPreferences() {
        return NbPreferences.forModule(IDESettings.class);
    }

    public boolean getShowToolTipsInIDE() {
        return IDESettings.getPreferences().getBoolean(PROP_SHOW_TOOLTIPS_IN_IDE, true);
    }

    public void setShowToolTipsInIDE(boolean bl) {
        IDESettings.getPreferences().putBoolean(PROP_SHOW_TOOLTIPS_IN_IDE, bl);
    }

    public boolean getConfirmDelete() {
        return IDESettings.getPreferences().getBoolean(PROP_CONFIRM_DELETE, true);
    }

    public void setConfirmDelete(boolean bl) {
        IDESettings.getPreferences().putBoolean(PROP_CONFIRM_DELETE, bl);
    }

    public String displayName() {
        return NbBundle.getBundle(IDESettings.class).getString("CTL_IDESettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IDESettings.class);
    }

    public String getHomePage() {
        return HtmlBrowser.getHomePage();
    }

    public void setHomePage(String string) {
        HtmlBrowser.setHomePage((String)string);
    }

    public boolean getShowFileExtensions() {
        return DataNode.getShowFileExtensions();
    }

    public void setShowFileExtensions(boolean bl) {
        DataNode.setShowFileExtensions((boolean)bl);
    }

    public static HtmlBrowser.Factory getWWWBrowser() {
        block8: {
            try {
                String string = IDESettings.getPreferences().get(PROP_WWWBROWSER, null);
                if (string instanceof String && !"".equals(string)) {
                    Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, string, null));
                    return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
                }
                if (string != null && !"".equals(string)) break block8;
                Lookup.Result result = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
                for (HtmlBrowser.Factory factory : result.allInstances()) {
                    FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    for (int i = 0; i < dataObjectArray.length; ++i) {
                        Object object = null;
                        try {
                            InstanceCookie instanceCookie;
                            if (Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute("hidden")) || (instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class)) == null || (object = instanceCookie.instanceCreate()) == null || !object.equals(factory)) continue;
                            return factory;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, iOException);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, classNotFoundException);
                        }
                    }
                }
                return null;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public static void setWWWBrowser(HtmlBrowser.Factory factory) {
        try {
            if (factory == null) {
                IDESettings.getPreferences().put(PROP_WWWBROWSER, "");
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)factory));
            if (item != null) {
                IDESettings.getPreferences().put(PROP_WWWBROWSER, item.getId());
            } else {
                Logger.getLogger(IDESettings.class.getName()).warning("IDESettings: Cannot find browser in lookup");
                IDESettings.getPreferences().put(PROP_WWWBROWSER, "");
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public String getIgnoredFiles() {
        return IDESettings.getPreferences().get(PROP_IGNORED_FILES, "^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|\\.(cvsignore|svn|DS_Store)|_svn)$|~$|^\\..*$");
    }

    public void setIgnoredFiles(String string) throws IllegalArgumentException {
        try {
            Pattern.compile(string);
            IDESettings.getPreferences().put(PROP_IGNORED_FILES, string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(patternSyntaxException);
            UIExceptions.annotateUser(illegalArgumentException, patternSyntaxException.getMessage(), patternSyntaxException.getLocalizedMessage(), null, null);
            throw illegalArgumentException;
        }
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)IDESettings.getInstance());
    }

    private static HtmlBrowser.FactoryEditor createHtmlBrowserFactoryEditor() {
        return new HtmlBrowser.FactoryEditor(){

            public void setValue(Object object) {
                IDESettings.setWWWBrowser((HtmlBrowser.Factory)object);
            }

            public Object getValue() {
                return IDESettings.getWWWBrowser();
            }
        };
    }
}

