/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.CompositeView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXLabel
extends JLabel {
    public static final double NORMAL = 0.0;
    public static final double INVERTED = Math.PI;
    public static final double VERTICAL_LEFT = 4.71238898038469;
    public static final double VERTICAL_RIGHT = 1.5707963267948966;
    private double textRotation = 0.0;
    private boolean painting = false;
    private Painter foregroundPainter;
    private Painter backgroundPainter;
    private boolean multiLine;
    private int pWidth;
    private int pHeight;
    private boolean ignoreRepaint;
    private static final String oldRendererKey = "washtml";
    private boolean paintBorderInsets = true;

    public JXLabel() {
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon image) {
        super(image);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text) {
        super(text);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text, Icon image, int horizontalAlignment) {
        super(text, image, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    private void initPainterSupport() {
        this.foregroundPainter = new AbstractPainter(){

            protected void doPaint(Graphics2D g, Object object, int width, int height) {
                Insets i = JXLabel.this.getInsets();
                g = (Graphics2D)g.create(-i.left, -i.top, width, height);
                JXLabel.super.paintComponent(g);
                g.dispose();
            }
        };
    }

    private void initLineWrapSupport() {
        this.addPropertyChangeListener(new MultiLineSupport());
    }

    public final Painter getForegroundPainter() {
        return this.foregroundPainter;
    }

    public void setForegroundPainter(Painter painter) {
        Painter old = this.getForegroundPainter();
        this.foregroundPainter = painter;
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public final Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public double getTextRotation() {
        return this.textRotation;
    }

    public void setTextRotation(double textOrientation) {
        double old = this.getTextRotation();
        this.textRotation = textOrientation;
        if (old != this.getTextRotation()) {
            this.firePropertyChange("textRotation", old, this.getTextRotation());
        }
        this.repaint();
    }

    public void setLineWrap(boolean b) {
        boolean old = this.isLineWrap();
        this.multiLine = b;
        if (this.isLineWrap() != old) {
            this.firePropertyChange("lineWrap", old, this.isLineWrap());
            if (this.getForegroundPainter() != null) {
                ((AbstractPainter)this.getForegroundPainter()).setCacheable(!b);
            }
            this.repaint();
        }
    }

    public boolean isLineWrap() {
        return this.multiLine;
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    protected void paintComponent(Graphics g) {
        if (this.ignoreRepaint) {
            return;
        }
        if (this.backgroundPainter == null && this.foregroundPainter == null) {
            super.paintComponent(g);
        } else {
            Graphics2D g2 = (Graphics2D)g.create();
            this.pWidth = this.getWidth();
            this.pHeight = this.getHeight();
            if (!this.isPaintBorderInsets()) {
                Insets i = this.getInsets();
                g2.translate(i.left, i.top);
                this.pWidth = this.getWidth() - i.left - i.right;
                this.pHeight = this.getHeight() - i.top - i.bottom;
            }
            if (this.backgroundPainter != null) {
                this.backgroundPainter.paint(g2, this, this.pWidth, this.pHeight);
            }
            if (this.foregroundPainter != null) {
                double tx = this.getWidth();
                double ty = this.getHeight();
                if (this.textRotation > 4.697 && this.textRotation < 4.727 || this.textRotation > 1.555 && this.textRotation < 1.585) {
                    int tmp = this.pHeight;
                    this.pHeight = this.pWidth;
                    this.pWidth = tmp;
                    tx = this.pWidth;
                    ty = this.pHeight;
                } else if (this.textRotation > -0.015 && this.textRotation < 0.015 || this.textRotation > 3.14 && this.textRotation < 3.143) {
                    this.pHeight = this.getHeight();
                    this.pWidth = this.getWidth();
                } else {
                    this.ignoreRepaint = true;
                    double square = (double)Math.min(this.getHeight(), this.getWidth()) * Math.cos(0.7853981633974483);
                    View v = (View)this.getClientProperty("html");
                    if (v == null) {
                        ty = this.getFontMetrics(this.getFont()).getHeight();
                        double cw = ((double)this.getWidth() - Math.abs(ty * Math.sin(this.textRotation))) / Math.abs(Math.cos(this.textRotation));
                        double ch = ((double)this.getHeight() - Math.abs(ty * Math.cos(this.textRotation))) / Math.abs(Math.sin(this.textRotation));
                        tx = cw < 0.0 ? ch : (ch > 0.0 ? Math.min(cw, ch) : cw);
                    } else {
                        float w = v.getPreferredSpan(0);
                        float h = v.getPreferredSpan(1);
                        double c = w;
                        double alpha = this.textRotation;
                        boolean ready = false;
                        while (!ready) {
                            while (h == v.getPreferredSpan(1)) {
                                v.setSize(w -= 10.0f, h);
                            }
                            if ((double)w < square || (double)h > square) {
                                w = h = (float)square;
                                v.setSize(w, 100000.0f);
                                break;
                            }
                            h = v.getPreferredSpan(1);
                            double cw = ((double)this.getWidth() - Math.abs((double)h * Math.sin(alpha))) / Math.abs(Math.cos(alpha));
                            double ch = ((double)this.getHeight() - Math.abs((double)h * Math.cos(alpha))) / Math.abs(Math.sin(alpha));
                            c = cw < 0.0 ? ch : (ch > 0.0 ? Math.min(cw, ch) : cw);
                            if ((c -= 1.0) > (double)w) {
                                v.setSize((float)c, 10.0f * h);
                                ready = true;
                                continue;
                            }
                            v.setSize((float)c, 10.0f * h);
                            if (v.getPreferredSpan(1) > h) {
                                v.setSize(w, 10.0f * h);
                                continue;
                            }
                            w = (float)c;
                            ready = true;
                        }
                        tx = Math.floor(w);
                        ty = h;
                    }
                    this.pWidth = (int)tx;
                    this.pHeight = (int)ty;
                    this.ignoreRepaint = false;
                }
                double wx = Math.sin(this.textRotation) * ty + Math.cos(this.textRotation) * tx;
                double wy = Math.sin(this.textRotation) * tx + Math.cos(this.textRotation) * ty;
                double x = ((double)this.getWidth() - wx) / 2.0 + Math.sin(this.textRotation) * ty;
                double y = ((double)this.getHeight() - wy) / 2.0;
                g2.translate(x, y);
                g2.rotate(this.textRotation);
                this.painting = true;
                this.foregroundPainter.paint(g2, this, this.pWidth, this.pHeight);
                this.painting = false;
                this.pWidth = 0;
                this.pHeight = 0;
            }
            g2.dispose();
        }
    }

    public void repaint() {
        if (this.ignoreRepaint) {
            return;
        }
        super.repaint();
    }

    public void repaint(int x, int y, int width, int height) {
        if (this.ignoreRepaint) {
            return;
        }
        super.repaint(x, y, width, height);
    }

    public void repaint(long tm) {
        if (this.ignoreRepaint) {
            return;
        }
        super.repaint(tm);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (this.ignoreRepaint) {
            return;
        }
        super.repaint(tm, x, y, width, height);
    }

    public int getHeight() {
        int retValue = super.getHeight();
        if (this.painting) {
            retValue = this.pHeight;
        }
        return retValue;
    }

    public int getWidth() {
        int retValue = super.getWidth();
        if (this.painting) {
            retValue = this.pWidth;
        }
        return retValue;
    }

    static class StateInvariantError
    extends Error {
        public StateInvariantError(String s) {
            super(s);
        }
    }

    static class AlterBoxView
    extends BoxView {
        Rectangle tempRect;
        boolean majorAllocValid;
        SizeRequirements minorRequest;

        public AlterBoxView(Element elem, int axis) {
            super(elem, axis);
        }

        protected short getRightInset() {
            return super.getRightInset();
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            if (!this.isAllocationValid()) {
                Rectangle alloc = a.getBounds();
                this.setSize(alloc.width, alloc.height);
            }
            return super.viewToModel(x, y, a, bias);
        }

        public void setSize(float width, float height) {
            this.layout((int)(width - (float)this.getLeftInset() - (float)this.getRightInset()), (int)(height - (float)this.getTopInset() - (float)this.getBottomInset()));
        }
    }

    abstract class AlterCompositeView
    extends CompositeView {
        public AlterCompositeView(Element elem) {
            super(elem);
        }

        protected boolean flipEastAndWestAtEnds(int position, Position.Bias bias) {
            return super.flipEastAndWestAtEnds(position, bias);
        }
    }

    static class SegmentCache {
        private static SegmentCache sharedCache = new SegmentCache();
        private List<Segment> segments = new ArrayList<Segment>(11);

        public static SegmentCache getSharedInstance() {
            return sharedCache;
        }

        public static Segment getSharedSegment() {
            return SegmentCache.getSharedInstance().getSegment();
        }

        public static void releaseSharedSegment(Segment segment) {
            SegmentCache.getSharedInstance().releaseSegment(segment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment getSegment() {
            SegmentCache segmentCache = this;
            synchronized (segmentCache) {
                int size = this.segments.size();
                if (size > 0) {
                    return this.segments.remove(size - 1);
                }
            }
            return new CachedSegment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSegment(Segment segment) {
            if (segment instanceof CachedSegment) {
                SegmentCache segmentCache = this;
                synchronized (segmentCache) {
                    segment.array = null;
                    segment.count = 0;
                    this.segments.add(segment);
                }
            }
        }

        private static class CachedSegment
        extends Segment {
            private CachedSegment() {
            }
        }
    }

    static class AlterWrappedPlainView
    extends AlterBoxView
    implements TabExpander {
        FontMetrics metrics;
        Segment lineBuffer;
        boolean widthChanging;
        int tabBase;
        int tabSize;
        boolean wordWrap;
        int sel0;
        int sel1;
        Color unselected;
        Color selected;

        public AlterWrappedPlainView(Element elem) {
            this(elem, false);
        }

        public AlterWrappedPlainView(Element elem, boolean wordWrap) {
            super(elem, 1);
            this.wordWrap = wordWrap;
        }

        protected int getTabSize() {
            Integer i = (Integer)this.getDocument().getProperty("tabSize");
            int size = i != null ? i : 8;
            return size;
        }

        protected void drawLine(int p0, int p1, Graphics g, int x, int y) {
            Element lineMap = this.getElement();
            Element line = lineMap.getElement(lineMap.getElementIndex(p0));
            try {
                if (line.isLeaf()) {
                    this.drawText(line, p0, p1, g, x, y);
                } else {
                    int lastIdx = line.getElementIndex(p1);
                    for (int idx = line.getElementIndex(p0); idx <= lastIdx; ++idx) {
                        Element elem = line.getElement(idx);
                        int start = Math.max(elem.getStartOffset(), p0);
                        int end = Math.min(elem.getEndOffset(), p1);
                        x = this.drawText(elem, start, end, g, x, y);
                    }
                }
            }
            catch (BadLocationException e) {
                throw new Error("Can't render: " + p0 + "," + p1);
            }
        }

        private int drawText(Element elem, int p0, int p1, Graphics g, int x, int y) throws BadLocationException {
            p1 = Math.min(this.getDocument().getLength(), p1);
            AttributeSet attr = elem.getAttributes();
            if (AlterUtilities.isComposedTextAttributeDefined(attr)) {
                g.setColor(this.unselected);
                x = AlterUtilities.drawComposedText(this, attr, g, x, y, p0 - elem.getStartOffset(), p1 - elem.getStartOffset());
            } else if (this.sel0 == this.sel1 || this.selected == this.unselected) {
                x = this.drawUnselectedText(g, x, y, p0, p1);
            } else if (p0 >= this.sel0 && p0 <= this.sel1 && p1 >= this.sel0 && p1 <= this.sel1) {
                x = this.drawSelectedText(g, x, y, p0, p1);
            } else if (this.sel0 >= p0 && this.sel0 <= p1) {
                if (this.sel1 >= p0 && this.sel1 <= p1) {
                    x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                    x = this.drawSelectedText(g, x, y, this.sel0, this.sel1);
                    x = this.drawUnselectedText(g, x, y, this.sel1, p1);
                } else {
                    x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                    x = this.drawSelectedText(g, x, y, this.sel0, p1);
                }
            } else if (this.sel1 >= p0 && this.sel1 <= p1) {
                x = this.drawSelectedText(g, x, y, p0, this.sel1);
                x = this.drawUnselectedText(g, x, y, this.sel1, p1);
            } else {
                x = this.drawUnselectedText(g, x, y, p0, p1);
            }
            return x;
        }

        protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            g.setColor(this.unselected);
            Document doc = this.getDocument();
            Segment segment = SegmentCache.getSharedSegment();
            doc.getText(p0, p1 - p0, segment);
            int ret = AlterUtilities.drawTabbedText(this, segment, x, y, g, this, p0);
            SegmentCache.releaseSharedSegment(segment);
            return ret;
        }

        protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            g.setColor(this.selected);
            Document doc = this.getDocument();
            Segment segment = SegmentCache.getSharedSegment();
            doc.getText(p0, p1 - p0, segment);
            int ret = AlterUtilities.drawTabbedText(this, segment, x, y, g, this, p0);
            SegmentCache.releaseSharedSegment(segment);
            return ret;
        }

        protected final Segment getLineBuffer() {
            if (this.lineBuffer == null) {
                this.lineBuffer = new Segment();
            }
            return this.lineBuffer;
        }

        protected int calculateBreakPosition(int p0, int p1) {
            Segment segment = SegmentCache.getSharedSegment();
            this.loadText(segment, p0, p1);
            int currentWidth = this.getWidth();
            int p = this.wordWrap ? p0 + AlterUtilities.getBreakLocation(segment, this.metrics, this.tabBase, this.tabBase + currentWidth, (TabExpander)this, p0) : p0 + AlterUtilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, this.tabBase + currentWidth, (TabExpander)this, p0, false);
            SegmentCache.releaseSharedSegment(segment);
            return p;
        }

        protected void loadChildren(ViewFactory f) {
            Element e = this.getElement();
            int n = e.getElementCount();
            if (n > 0) {
                View[] added = new View[n];
                for (int i = 0; i < n; ++i) {
                    added[i] = new WrappedLine(e.getElement(i));
                }
                this.replace(0, 0, added);
            }
        }

        void updateChildren(DocumentEvent e, Shape a) {
            Element elem = this.getElement();
            DocumentEvent.ElementChange ec = e.getChange(elem);
            if (ec != null) {
                Element[] removedElems = ec.getChildrenRemoved();
                Element[] addedElems = ec.getChildrenAdded();
                View[] added = new View[addedElems.length];
                for (int i = 0; i < addedElems.length; ++i) {
                    added[i] = new WrappedLine(addedElems[i]);
                }
                this.replace(ec.getIndex(), removedElems.length, added);
                if (a != null) {
                    this.preferenceChanged(null, true, true);
                    this.getContainer().repaint();
                }
            }
            this.updateMetrics();
        }

        final void loadText(Segment segment, int p0, int p1) {
            try {
                Document doc = this.getDocument();
                doc.getText(p0, p1 - p0, segment);
            }
            catch (BadLocationException bl) {
                throw new StateInvariantError("Can't get line text");
            }
        }

        final void updateMetrics() {
            Container host = this.getContainer();
            Font f = host.getFont();
            this.metrics = host.getFontMetrics(f);
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }

        public float nextTabStop(float x, int tabOffset) {
            if (this.tabSize == 0) {
                return x;
            }
            int ntabs = ((int)x - this.tabBase) / this.tabSize;
            return this.tabBase + (ntabs + 1) * this.tabSize;
        }

        public void paint(Graphics g, Shape a) {
            Rectangle alloc = (Rectangle)a;
            this.tabBase = alloc.x;
            JComponent host = (JComponent)this.getContainer();
            this.selected = this.unselected = host.getForeground();
            g.setFont(host.getFont());
            super.paint(g, a);
        }

        public void setSize(float width, float height) {
            this.updateMetrics();
            if ((int)width != this.getWidth()) {
                this.preferenceChanged(null, true, true);
                this.widthChanging = true;
            }
            super.setSize(width, height);
            this.widthChanging = false;
        }

        public float getPreferredSpan(int axis) {
            this.updateMetrics();
            return super.getPreferredSpan(axis);
        }

        public float getMinimumSpan(int axis) {
            this.updateMetrics();
            return super.getMinimumSpan(axis);
        }

        public float getMaximumSpan(int axis) {
            this.updateMetrics();
            return super.getMaximumSpan(axis);
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.updateChildren(e, a);
            Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
            int pos = e.getOffset();
            View v = this.getViewAtPosition(pos, alloc);
            if (v != null) {
                v.insertUpdate(e, alloc, f);
            }
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.updateChildren(e, a);
            Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
            int pos = e.getOffset();
            View v = this.getViewAtPosition(pos, alloc);
            if (v != null) {
                v.removeUpdate(e, alloc, f);
            }
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.updateChildren(e, a);
        }

        class WrappedLine
        extends View {
            int lineCount;
            SoftReference<int[]> lineCache;

            WrappedLine(Element elem) {
                super(elem);
                this.lineCache = null;
                this.lineCount = -1;
            }

            public float getPreferredSpan(int axis) {
                switch (axis) {
                    case 0: {
                        float width = AlterWrappedPlainView.this.getWidth();
                        if (width == 2.1474836E9f) {
                            return 100.0f;
                        }
                        return width;
                    }
                    case 1: {
                        if (this.lineCount < 0 || AlterWrappedPlainView.this.widthChanging) {
                            this.breakLines(this.getStartOffset());
                        }
                        int h = this.lineCount * AlterWrappedPlainView.this.metrics.getHeight();
                        return h;
                    }
                }
                throw new IllegalArgumentException("Invalid axis: " + axis);
            }

            public void paint(Graphics g, Shape a) {
                Rectangle alloc = (Rectangle)a;
                int y = alloc.y + AlterWrappedPlainView.this.metrics.getAscent();
                int x = alloc.x;
                int start = this.getStartOffset();
                int end = this.getEndOffset();
                int p0 = start;
                int[] lineEnds = this.getLineEnds();
                for (int i = 0; i < this.lineCount; ++i) {
                    int p1 = lineEnds == null ? end : start + lineEnds[i];
                    AlterWrappedPlainView.this.drawLine(p0, p1, g, x, y);
                    p0 = p1;
                    y += AlterWrappedPlainView.this.metrics.getHeight();
                }
            }

            public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
                Rectangle alloc = a.getBounds();
                alloc.height = AlterWrappedPlainView.this.metrics.getHeight();
                alloc.width = 1;
                int p0 = this.getStartOffset();
                if (pos < p0 || pos > this.getEndOffset()) {
                    throw new BadLocationException("Position out of range", pos);
                }
                int testP = b == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
                int line = 0;
                int[] lineEnds = this.getLineEnds();
                if (lineEnds != null) {
                    line = this.findLine(testP - p0);
                    if (line > 0) {
                        p0 += lineEnds[line - 1];
                    }
                    alloc.y += alloc.height * line;
                }
                if (pos > p0) {
                    Segment segment = SegmentCache.getSharedSegment();
                    AlterWrappedPlainView.this.loadText(segment, p0, pos);
                    alloc.x += AlterUtilities.getTabbedTextWidth(segment, AlterWrappedPlainView.this.metrics, alloc.x, (TabExpander)AlterWrappedPlainView.this, p0);
                    SegmentCache.releaseSharedSegment(segment);
                }
                return alloc;
            }

            public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
                int p1;
                bias[0] = Position.Bias.Forward;
                Rectangle alloc = (Rectangle)a;
                int x = (int)fx;
                int y = (int)fy;
                if (y < alloc.y) {
                    return this.getStartOffset();
                }
                if (y > alloc.y + alloc.height) {
                    return this.getEndOffset() - 1;
                }
                alloc.height = AlterWrappedPlainView.this.metrics.getHeight();
                int line = (y - alloc.y) / alloc.height;
                if (line >= this.lineCount) {
                    return this.getEndOffset() - 1;
                }
                int p0 = this.getStartOffset();
                if (this.lineCount == 1) {
                    p1 = this.getEndOffset();
                } else {
                    int[] lineEnds = this.getLineEnds();
                    p1 = p0 + lineEnds[line];
                    if (line > 0) {
                        p0 += lineEnds[line - 1];
                    }
                }
                if (x < alloc.x) {
                    return p0;
                }
                if (x > alloc.x + alloc.width) {
                    return p1 - 1;
                }
                Segment segment = SegmentCache.getSharedSegment();
                AlterWrappedPlainView.this.loadText(segment, p0, p1);
                int n = AlterUtilities.getTabbedTextOffset(segment, AlterWrappedPlainView.this.metrics, alloc.x, x, AlterWrappedPlainView.this, p0);
                SegmentCache.releaseSharedSegment(segment);
                return Math.min(p0 + n, p1 - 1);
            }

            public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
                this.update(e, a);
            }

            public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
                this.update(e, a);
            }

            private void update(DocumentEvent ev, Shape a) {
                int oldCount = this.lineCount;
                this.breakLines(ev.getOffset());
                if (oldCount != this.lineCount) {
                    AlterWrappedPlainView.this.preferenceChanged(this, false, true);
                    this.getContainer().repaint();
                } else if (a != null) {
                    Container c = this.getContainer();
                    Rectangle alloc = (Rectangle)a;
                    c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
                }
            }

            final int[] getLineEnds() {
                if (this.lineCache == null) {
                    return null;
                }
                int[] lineEnds = this.lineCache.get();
                if (lineEnds == null) {
                    return this.breakLines(this.getStartOffset());
                }
                return lineEnds;
            }

            final int[] breakLines(int startPos) {
                int maxCapacity;
                int[] lineEnds;
                int[] oldLineEnds = lineEnds = this.lineCache == null ? null : this.lineCache.get();
                int start = this.getStartOffset();
                int lineIndex = 0;
                if (lineEnds != null && (lineIndex = this.findLine(startPos - start)) > 0) {
                    --lineIndex;
                }
                int p0 = lineIndex == 0 ? start : start + lineEnds[lineIndex - 1];
                int p1 = this.getEndOffset();
                while (p0 < p1) {
                    int p = AlterWrappedPlainView.this.calculateBreakPosition(p0, p1);
                    int n = p0 = p == p0 ? ++p : p;
                    if (lineIndex == 0 && p0 >= p1) {
                        this.lineCache = null;
                        lineEnds = null;
                        lineIndex = 1;
                        break;
                    }
                    if (lineEnds == null || lineIndex >= lineEnds.length) {
                        double growFactor = (double)(p1 - start) / (double)(p0 - start);
                        int newSize = (int)Math.ceil((double)(lineIndex + 1) * growFactor);
                        newSize = Math.max(newSize, lineIndex + 2);
                        int[] tmp = new int[newSize];
                        if (lineEnds != null) {
                            System.arraycopy(lineEnds, 0, tmp, 0, lineIndex);
                        }
                        lineEnds = tmp;
                    }
                    lineEnds[lineIndex++] = p0 - start;
                }
                this.lineCount = lineIndex;
                if (this.lineCount > 1 && lineEnds.length > (maxCapacity = this.lineCount + this.lineCount / 3)) {
                    int[] tmp = new int[maxCapacity];
                    System.arraycopy(lineEnds, 0, tmp, 0, this.lineCount);
                    lineEnds = tmp;
                }
                if (lineEnds != null && lineEnds != oldLineEnds) {
                    this.lineCache = new SoftReference<int[]>(lineEnds);
                }
                return lineEnds;
            }

            private int findLine(int offset) {
                int[] lineEnds = this.lineCache.get();
                if (offset < lineEnds[0]) {
                    return 0;
                }
                if (offset > lineEnds[this.lineCount - 1]) {
                    return this.lineCount;
                }
                return this.findLine(lineEnds, offset, 0, this.lineCount - 1);
            }

            private int findLine(int[] array, int offset, int min, int max) {
                if (max - min <= 1) {
                    return max;
                }
                int mid = (max + min) / 2;
                return offset < array[mid] ? this.findLine(array, offset, min, mid) : this.findLine(array, offset, mid, max);
            }
        }
    }

    static class AlterGlyphView
    extends GlyphView
    implements TabableView,
    Cloneable {
        private JustificationInfo justificationInfo = null;

        public AlterGlyphView(Element elem) {
            super(elem);
        }

        JustificationInfo getJustificationInfo(int rowStartOffset) {
            if (this.justificationInfo != null) {
                return this.justificationInfo;
            }
            boolean TRAILING = false;
            boolean CONTENT = true;
            int SPACES = 2;
            int startOffset = this.getStartOffset();
            int endOffset = this.getEndOffset();
            Segment segment = this.getText(startOffset, endOffset);
            int txtOffset = segment.offset;
            int txtEnd = segment.offset + segment.count - 1;
            int startContentPosition = txtEnd + 1;
            int endContentPosition = txtOffset - 1;
            int trailingSpaces = 0;
            int contentSpaces = 0;
            int leadingSpaces = 0;
            boolean hasTab = false;
            BitSet spaceMap = new BitSet(endOffset - startOffset + 1);
            int state = 0;
            for (int i = txtEnd; i >= txtOffset; --i) {
                if (' ' == segment.array[i]) {
                    spaceMap.set(i - txtOffset);
                    if (state == 0) {
                        ++trailingSpaces;
                        continue;
                    }
                    if (state == 1) {
                        state = 2;
                        leadingSpaces = 1;
                        continue;
                    }
                    if (state != 2) continue;
                    ++leadingSpaces;
                    continue;
                }
                if ('\t' == segment.array[i]) {
                    hasTab = true;
                    break;
                }
                if (state == 0) {
                    if ('\n' != segment.array[i] && '\r' != segment.array[i]) {
                        state = 1;
                        endContentPosition = i;
                    }
                } else if (state != 1 && state == 2) {
                    contentSpaces += leadingSpaces;
                    leadingSpaces = 0;
                }
                startContentPosition = i;
            }
            SegmentCache.releaseSharedSegment(segment);
            int startJustifiableContent = -1;
            if (startContentPosition < txtEnd) {
                startJustifiableContent = startContentPosition - txtOffset;
            }
            int endJustifiableContent = -1;
            if (endContentPosition > txtOffset) {
                endJustifiableContent = endContentPosition - txtOffset;
            }
            this.justificationInfo = new JustificationInfo(startJustifiableContent, endJustifiableContent, leadingSpaces, contentSpaces, trailingSpaces, hasTab, spaceMap);
            return this.justificationInfo;
        }

        static class JustificationInfo {
            final int start;
            final int end;
            final int leadingSpaces;
            final int contentSpaces;
            final int trailingSpaces;
            final boolean hasTab;
            final BitSet spaceMap;

            JustificationInfo(int start, int end, int leadingSpaces, int contentSpaces, int trailingSpaces, boolean hasTab, BitSet spaceMap) {
                this.start = start;
                this.end = end;
                this.leadingSpaces = leadingSpaces;
                this.contentSpaces = contentSpaces;
                this.trailingSpaces = trailingSpaces;
                this.hasTab = hasTab;
                this.spaceMap = spaceMap;
            }
        }
    }

    static class AlterUtilities
    extends Utilities {
        private static Method drawChars;
        private static Method drawString;
        private static Method getFontMetrics;
        private static Class clz;

        AlterUtilities() {
        }

        private static FontMetrics getFontMetrics(JComponent component, Graphics g) {
            try {
                return (FontMetrics)getFontMetrics.invoke(null, component, g);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static int drawChars(JComponent component, Graphics g, char[] txt, int flushIndex, int flushLen, int x, int y) {
            try {
                return (Integer)drawChars.invoke(null, component, g, txt, flushIndex, flushLen, x, y);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static float drawString(JComponent c, Graphics2D g2d, AttributedCharacterIterator aci, int x, int y) {
            try {
                return ((Float)drawString.invoke(null, c, g2d, aci, x, y)).floatValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static JComponent getJComponent(View view) {
            Container component;
            if (view != null && (component = view.getContainer()) instanceof JComponent) {
                return (JComponent)component;
            }
            return null;
        }

        static final int drawTabbedText(View view, Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
            return AlterUtilities.drawTabbedText(view, s, x, y, g, e, startOffset, null);
        }

        static final int drawTabbedText(View view, Segment s, int x, int y, Graphics g, TabExpander e, int startOffset, int[] justificationData) {
            JComponent component = AlterUtilities.getJComponent(view);
            FontMetrics metrics = AlterUtilities.getFontMetrics(component, g);
            int nextX = x;
            char[] txt = s.array;
            int txtOffset = s.offset;
            int flushLen = 0;
            int flushIndex = s.offset;
            int spaceAddon = 0;
            int spaceAddonLeftoverEnd = -1;
            int startJustifiableContent = 0;
            int endJustifiableContent = 0;
            if (justificationData != null) {
                int offset = -startOffset + txtOffset;
                View parent = null;
                if (view != null && (parent = view.getParent()) != null) {
                    offset += parent.getStartOffset();
                }
                spaceAddon = justificationData[0];
                spaceAddonLeftoverEnd = justificationData[1] + offset;
                startJustifiableContent = justificationData[2] + offset;
                endJustifiableContent = justificationData[3] + offset;
            }
            int n = s.offset + s.count;
            for (int i = txtOffset; i < n; ++i) {
                if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                    if (flushLen > 0) {
                        nextX = AlterUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    if (txt[i] == '\t') {
                        nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                    } else if (txt[i] == ' ') {
                        nextX += metrics.charWidth(' ') + spaceAddon;
                        if (i <= spaceAddonLeftoverEnd) {
                            // empty if block
                        }
                    }
                    x = ++nextX;
                    continue;
                }
                if (txt[i] == '\n' || txt[i] == '\r') {
                    if (flushLen > 0) {
                        nextX = AlterUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    x = nextX;
                    continue;
                }
                ++flushLen;
            }
            if (flushLen > 0) {
                nextX = AlterUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y);
            }
            return nextX;
        }

        static final int getTabbedTextWidth(View view, Segment s, FontMetrics metrics, int x, TabExpander e, int startOffset, int[] justificationData) {
            int nextX = x;
            char[] txt = s.array;
            int txtOffset = s.offset;
            int n = s.offset + s.count;
            int charCount = 0;
            int spaceAddon = 0;
            int spaceAddonLeftoverEnd = -1;
            int startJustifiableContent = 0;
            int endJustifiableContent = 0;
            if (justificationData != null) {
                int offset = -startOffset + txtOffset;
                View parent = null;
                if (view != null && (parent = view.getParent()) != null) {
                    offset += parent.getStartOffset();
                }
                spaceAddon = justificationData[0];
                spaceAddonLeftoverEnd = justificationData[1] + offset;
                startJustifiableContent = justificationData[2] + offset;
                endJustifiableContent = justificationData[3] + offset;
            }
            for (int i = txtOffset; i < n; ++i) {
                if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                    nextX += metrics.charsWidth(txt, i - charCount, charCount);
                    charCount = 0;
                    if (txt[i] == '\t') {
                        if (e != null) {
                            nextX = (int)e.nextTabStop(nextX, startOffset + i - txtOffset);
                            continue;
                        }
                        nextX += metrics.charWidth(' ');
                        continue;
                    }
                    if (txt[i] != ' ') continue;
                    nextX += metrics.charWidth(' ') + spaceAddon;
                    if (i > spaceAddonLeftoverEnd) continue;
                    ++nextX;
                    continue;
                }
                if (txt[i] == '\n') {
                    nextX += metrics.charsWidth(txt, i - charCount, charCount);
                    charCount = 0;
                    continue;
                }
                ++charCount;
            }
            return (nextX += metrics.charsWidth(txt, n - charCount, charCount)) - x;
        }

        static final int getTabbedTextOffset(View view, Segment s, FontMetrics metrics, int x0, int x, TabExpander e, int startOffset, int[] justificationData) {
            return AlterUtilities.getTabbedTextOffset(view, s, metrics, x0, x, e, startOffset, true, justificationData);
        }

        static final int getTabbedTextOffset(View view, Segment s, FontMetrics metrics, int x0, int x, TabExpander e, int startOffset, boolean round, int[] justificationData) {
            int currX;
            if (x0 >= x) {
                return 0;
            }
            int nextX = currX = x0;
            char[] txt = s.array;
            int txtOffset = s.offset;
            int txtCount = s.count;
            int spaceAddon = 0;
            int spaceAddonLeftoverEnd = -1;
            int startJustifiableContent = 0;
            int endJustifiableContent = 0;
            if (justificationData != null) {
                int offset = -startOffset + txtOffset;
                View parent = null;
                if (view != null && (parent = view.getParent()) != null) {
                    offset += parent.getStartOffset();
                }
                spaceAddon = justificationData[0];
                spaceAddonLeftoverEnd = justificationData[1] + offset;
                startJustifiableContent = justificationData[2] + offset;
                endJustifiableContent = justificationData[3] + offset;
            }
            int n = s.offset + s.count;
            for (int i = s.offset; i < n; ++i) {
                if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                    if (txt[i] == '\t') {
                        nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                    } else if (txt[i] == ' ') {
                        nextX += metrics.charWidth(' ') + spaceAddon;
                        if (i <= spaceAddonLeftoverEnd) {
                            ++nextX;
                        }
                    }
                } else {
                    nextX += metrics.charWidth(txt[i]);
                }
                if (x >= currX && x < nextX) {
                    if (!round || x - currX < nextX - x) {
                        return i - txtOffset;
                    }
                    return i + 1 - txtOffset;
                }
                currX = nextX;
            }
            return txtCount;
        }

        static int getNextWordInParagraph(JTextComponent c, Element line, int offs, boolean first) throws BadLocationException {
            if (line == null) {
                throw new BadLocationException("No more words", offs);
            }
            Document doc = line.getDocument();
            int lineStart = line.getStartOffset();
            int lineEnd = Math.min(line.getEndOffset(), doc.getLength());
            if (offs >= lineEnd || offs < lineStart) {
                throw new BadLocationException("No more words", offs);
            }
            Segment seg = SegmentCache.getSharedSegment();
            doc.getText(lineStart, lineEnd - lineStart, seg);
            BreakIterator words = BreakIterator.getWordInstance(c.getLocale());
            words.setText(seg);
            if (first && words.first() == seg.offset + offs - lineStart && !Character.isWhitespace(seg.array[words.first()])) {
                return offs;
            }
            int wordPosition = words.following(seg.offset + offs - lineStart);
            if (wordPosition == -1 || wordPosition >= seg.offset + seg.count) {
                return -1;
            }
            char ch = seg.array[wordPosition];
            if (!Character.isWhitespace(ch)) {
                return lineStart + wordPosition - seg.offset;
            }
            wordPosition = words.next();
            if (wordPosition != -1 && (offs = lineStart + wordPosition - seg.offset) != lineEnd) {
                return offs;
            }
            SegmentCache.releaseSharedSegment(seg);
            return -1;
        }

        static int getPrevWordInParagraph(JTextComponent c, Element line, int offs) throws BadLocationException {
            int wordPosition;
            if (line == null) {
                throw new BadLocationException("No more words", offs);
            }
            Document doc = line.getDocument();
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            if (offs > lineEnd || offs < lineStart) {
                throw new BadLocationException("No more words", offs);
            }
            Segment seg = SegmentCache.getSharedSegment();
            doc.getText(lineStart, lineEnd - lineStart, seg);
            BreakIterator words = BreakIterator.getWordInstance(c.getLocale());
            words.setText(seg);
            if (words.following(seg.offset + offs - lineStart) == -1) {
                words.last();
            }
            if ((wordPosition = words.previous()) == seg.offset + offs - lineStart) {
                wordPosition = words.previous();
            }
            if (wordPosition == -1) {
                return -1;
            }
            char ch = seg.array[wordPosition];
            if (!Character.isWhitespace(ch)) {
                return lineStart + wordPosition - seg.offset;
            }
            wordPosition = words.previous();
            if (wordPosition != -1) {
                return lineStart + wordPosition - seg.offset;
            }
            SegmentCache.releaseSharedSegment(seg);
            return -1;
        }

        static boolean isComposedTextElement(Document doc, int offset) {
            Element elem = doc.getDefaultRootElement();
            while (!elem.isLeaf()) {
                elem = elem.getElement(elem.getElementIndex(offset));
            }
            return AlterUtilities.isComposedTextElement(elem);
        }

        static boolean isComposedTextElement(Element elem) {
            AttributeSet as = elem.getAttributes();
            return AlterUtilities.isComposedTextAttributeDefined(as);
        }

        static boolean isComposedTextAttributeDefined(AttributeSet as) {
            return as != null && as.isDefined(StyleConstants.ComposedTextAttribute);
        }

        static int drawComposedText(View view, AttributeSet attr, Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            Graphics2D g2d = (Graphics2D)g;
            AttributedString as = (AttributedString)attr.getAttribute(StyleConstants.ComposedTextAttribute);
            as.addAttribute(TextAttribute.FONT, g.getFont());
            if (p0 >= p1) {
                return x;
            }
            AttributedCharacterIterator aci = as.getIterator(null, p0, p1);
            return x + (int)AlterUtilities.drawString(AlterUtilities.getJComponent(view), g2d, aci, x, y);
        }

        static void paintComposedText(Graphics g, Rectangle alloc, AlterGlyphView v) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                int p0 = v.getStartOffset();
                int p1 = v.getEndOffset();
                AttributeSet attrSet = v.getElement().getAttributes();
                AttributedString as = (AttributedString)attrSet.getAttribute(StyleConstants.ComposedTextAttribute);
                int start = v.getElement().getStartOffset();
                int y = alloc.y + alloc.height - (int)v.getGlyphPainter().getDescent(v);
                int x = alloc.x;
                as.addAttribute(TextAttribute.FONT, v.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, v.getForeground());
                if (StyleConstants.isBold(v.getAttributes())) {
                    as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
                if (StyleConstants.isItalic(v.getAttributes())) {
                    as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                }
                if (v.isUnderline()) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (v.isStrikeThrough()) {
                    as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                if (v.isSuperscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                }
                if (v.isSubscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                }
                AttributedCharacterIterator aci = as.getIterator(null, p0 - start, p1 - start);
                AlterUtilities.drawString(AlterUtilities.getJComponent(v), g2d, aci, x, y);
            }
        }

        static boolean isLeftToRight(Component c) {
            return c.getComponentOrientation().isLeftToRight();
        }

        static int getNextVisualPositionFrom(View v, int pos, Position.Bias b, Shape alloc, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int retValue;
            boolean top;
            if (v.getViewCount() == 0) {
                return pos;
            }
            boolean bl = top = direction == 1 || direction == 7;
            if (pos == -1) {
                Shape childBounds;
                int childIndex = top ? v.getViewCount() - 1 : 0;
                View child = v.getView(childIndex);
                retValue = child.getNextVisualPositionFrom(pos, b, childBounds = v.getChildAllocation(childIndex, alloc), direction, biasRet);
                if (retValue == -1 && !top && v.getViewCount() > 1) {
                    child = v.getView(1);
                    childBounds = v.getChildAllocation(1, alloc);
                    retValue = child.getNextVisualPositionFrom(-1, biasRet[0], childBounds, direction, biasRet);
                }
            } else {
                int increment = top ? -1 : 1;
                int childIndex = b == Position.Bias.Backward && pos > 0 ? v.getViewIndex(pos - 1, Position.Bias.Forward) : v.getViewIndex(pos, Position.Bias.Forward);
                View child = v.getView(childIndex);
                Shape childBounds = v.getChildAllocation(childIndex, alloc);
                retValue = child.getNextVisualPositionFrom(pos, b, childBounds, direction, biasRet);
                if ((direction == 3 || direction == 7) && v instanceof AlterCompositeView && ((AlterCompositeView)v).flipEastAndWestAtEnds(pos, b)) {
                    increment *= -1;
                }
                if (retValue == -1 && (childIndex += increment) >= 0 && childIndex < v.getViewCount()) {
                    child = v.getView(childIndex);
                    retValue = child.getNextVisualPositionFrom(-1, b, childBounds = v.getChildAllocation(childIndex, alloc), direction, biasRet);
                    if (retValue == pos && biasRet[0] != b) {
                        return AlterUtilities.getNextVisualPositionFrom(v, pos, biasRet[0], alloc, direction, biasRet);
                    }
                } else if (retValue != -1 && biasRet[0] != b && (increment == 1 && child.getEndOffset() == retValue || increment == -1 && child.getStartOffset() == retValue) && childIndex >= 0 && childIndex < v.getViewCount()) {
                    child = v.getView(childIndex);
                    childBounds = v.getChildAllocation(childIndex, alloc);
                    Position.Bias originalBias = biasRet[0];
                    int nextPos = child.getNextVisualPositionFrom(-1, b, childBounds, direction, biasRet);
                    if (biasRet[0] == b) {
                        retValue = nextPos;
                    } else {
                        biasRet[0] = originalBias;
                    }
                }
            }
            return retValue;
        }

        static {
            clz = null;
            String j5 = "com.sun.java.swing.SwingUtilities2";
            String j6 = "sun.swing.SwingUtilities2";
            try {
                clz = Class.forName(j6);
            }
            catch (ClassNotFoundException e) {
                try {
                    clz = Class.forName(j5);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Failed to find SwingUtilities2. Check the classpath.");
                }
            }
            try {
                drawChars = clz.getMethod("drawChars", JComponent.class, Graphics.class, char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                drawString = clz.getMethod("drawString", JComponent.class, Graphics.class, AttributedCharacterIterator.class, Integer.TYPE, Integer.TYPE);
                getFontMetrics = clz.getMethod("getFontMetrics", JComponent.class, Graphics.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to use SwingUtilities2. Check the permissions and class version.");
            }
        }
    }

    class Row
    extends AlterBoxView {
        private int justification;
        private float lineSpacing;
        protected int firstLineIndent;
        static final int SPACE_ADDON = 0;
        static final int SPACE_ADDON_LEFTOVER_END = 1;
        static final int START_JUSTIFIABLE = 2;
        static final int END_JUSTIFIABLE = 3;
        int[] justificationData;

        Row(Element elem) {
            super(elem, 0);
            this.firstLineIndent = 0;
            this.justificationData = null;
        }

        protected void loadChildren(ViewFactory f) {
        }

        public AttributeSet getAttributes() {
            View p = this.getParent();
            return p != null ? p.getAttributes() : null;
        }

        public float getAlignment(int axis) {
            if (axis == 0) {
                switch (this.justification) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: {
                        return 0.5f;
                    }
                    case 3: {
                        float rv = 0.5f;
                        if (this.isJustifiableDocument()) {
                            rv = 0.0f;
                        }
                        return rv;
                    }
                }
            }
            return super.getAlignment(axis);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle r = a.getBounds();
            View v = this.getViewAtPosition(pos, r);
            if (v != null && !v.getElement().isLeaf()) {
                return super.modelToView(pos, a, b);
            }
            r = a.getBounds();
            int height = r.height;
            int y = r.y;
            Shape loc = super.modelToView(pos, a, b);
            r = loc.getBounds();
            r.height = height;
            r.y = y;
            return r;
        }

        public int getStartOffset() {
            int offs = Integer.MAX_VALUE;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.min(offs, v.getStartOffset());
            }
            return offs;
        }

        public int getEndOffset() {
            int offs = 0;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.max(offs, v.getEndOffset());
            }
            return offs;
        }

        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            this.baselineLayout(targetSpan, axis, offsets, spans);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            return this.baselineRequirements(axis, r);
        }

        private boolean isLastRow() {
            View parent = this.getParent();
            return parent == null || this == parent.getView(parent.getViewCount() - 1);
        }

        private boolean isBrokenRow() {
            View lastView;
            boolean rv = false;
            int viewsCount = this.getViewCount();
            if (viewsCount > 0 && (lastView = this.getView(viewsCount - 1)).getBreakWeight(0, 0.0f, 0.0f) >= 3000) {
                rv = true;
            }
            return rv;
        }

        private boolean isJustifiableDocument() {
            return !Boolean.TRUE.equals(this.getDocument().getProperty("i18n"));
        }

        private boolean isJustifyEnabled() {
            boolean ret = this.justification == 3;
            ret = ret && this.isJustifiableDocument();
            ret = ret && !this.isLastRow();
            ret = ret && !this.isBrokenRow();
            return ret;
        }

        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            int[] oldJustficationData = this.justificationData;
            this.justificationData = null;
            SizeRequirements ret = super.calculateMajorAxisRequirements(axis, r);
            if (this.isJustifyEnabled()) {
                this.justificationData = oldJustficationData;
            }
            return ret;
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int[] oldJustficationData = this.justificationData;
            this.justificationData = null;
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            if (!this.isJustifyEnabled()) {
                return;
            }
            int currentSpan = 0;
            for (int span : spans) {
                currentSpan += span;
            }
            if (currentSpan == targetSpan) {
                return;
            }
            int extendableSpaces = 0;
            int startJustifiableContent = -1;
            int endJustifiableContent = -1;
            int lastLeadingSpaces = 0;
            int rowStartOffset = this.getStartOffset();
            int rowEndOffset = this.getEndOffset();
            int[] spaceMap = new int[rowEndOffset - rowStartOffset];
            Arrays.fill(spaceMap, 0);
            for (int i = this.getViewCount() - 1; i >= 0; --i) {
                View view = this.getView(i);
                if (!(view instanceof AlterGlyphView)) continue;
                AlterGlyphView.JustificationInfo justificationInfo = ((AlterGlyphView)view).getJustificationInfo(rowStartOffset);
                int viewStartOffset = view.getStartOffset();
                int offset = viewStartOffset - rowStartOffset;
                for (int j = 0; j < justificationInfo.spaceMap.length(); ++j) {
                    if (!justificationInfo.spaceMap.get(j)) continue;
                    spaceMap[j + offset] = 1;
                }
                if (startJustifiableContent > 0) {
                    if (justificationInfo.end >= 0) {
                        extendableSpaces += justificationInfo.trailingSpaces;
                    } else {
                        lastLeadingSpaces += justificationInfo.trailingSpaces;
                    }
                }
                if (justificationInfo.start >= 0) {
                    startJustifiableContent = justificationInfo.start + viewStartOffset;
                    extendableSpaces += lastLeadingSpaces;
                }
                if (justificationInfo.end >= 0 && endJustifiableContent < 0) {
                    endJustifiableContent = justificationInfo.end + viewStartOffset;
                }
                extendableSpaces += justificationInfo.contentSpaces;
                lastLeadingSpaces = justificationInfo.leadingSpaces;
                if (justificationInfo.hasTab) break;
            }
            if (extendableSpaces <= 0) {
                return;
            }
            int adjustment = targetSpan - currentSpan;
            int spaceAddon = extendableSpaces > 0 ? adjustment / extendableSpaces : 0;
            int spaceAddonLeftoverEnd = -1;
            int i = startJustifiableContent - rowStartOffset;
            int leftover = adjustment - spaceAddon * extendableSpaces;
            while (leftover > 0) {
                spaceAddonLeftoverEnd = i;
                leftover -= spaceMap[i];
                ++i;
            }
            if (spaceAddon > 0 || spaceAddonLeftoverEnd >= 0) {
                this.justificationData = oldJustficationData != null ? oldJustficationData : new int[4];
                this.justificationData[0] = spaceAddon;
                this.justificationData[1] = spaceAddonLeftoverEnd;
                this.justificationData[2] = startJustifiableContent - rowStartOffset;
                this.justificationData[3] = endJustifiableContent - rowStartOffset;
                super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            }
        }

        public float getMaximumSpan(int axis) {
            float ret = 0 == axis && this.isJustifyEnabled() ? Float.MAX_VALUE : super.getMaximumSpan(axis);
            return ret;
        }

        protected int getViewIndexAtPosition(int pos) {
            if (pos < this.getStartOffset() || pos >= this.getEndOffset()) {
                return -1;
            }
            for (int counter = this.getViewCount() - 1; counter >= 0; --counter) {
                View v = this.getView(counter);
                if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
                return counter;
            }
            return -1;
        }

        protected short getLeftInset() {
            int adjustment = 0;
            View parentView = this.getParent();
            if (parentView != null && this == parentView.getView(0)) {
                adjustment = this.firstLineIndent;
            }
            return (short)(super.getLeftInset() + adjustment);
        }

        protected short getBottomInset() {
            return (short)((float)super.getBottomInset() + (float)(this.minorRequest != null ? this.minorRequest.preferred : 0) * this.lineSpacing);
        }
    }

    private static abstract class AlterAbstractDocument
    extends AbstractDocument
    implements Document,
    Serializable {
        static final String I18NProperty = "i18n";

        public AlterAbstractDocument(AbstractDocument.Content data, AbstractDocument.AttributeContext context) {
            super(data, context);
        }

        public AlterAbstractDocument(AbstractDocument.Content data) {
            super(data);
        }
    }

    static class Renderer
    extends AlterWrappedPlainView {
        JXLabel host;
        private View view;
        private ViewFactory factory;

        Renderer(JXLabel c, ViewFactory f, View v, boolean wordWrap) {
            super(null, wordWrap);
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
            this.host = c;
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this.view.setSize(alloc.width, alloc.height);
            if (g.getClipBounds() == null) {
                g.setClip(alloc);
                this.view.paint(g, allocation);
                g.setClip(null);
            } else {
                this.view.paint(g, allocation);
            }
        }

        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Document getDocument() {
            return this.view == null ? null : this.view.getDocument();
        }

        public void setSize(float width, float height) {
            this.view.setSize(width, height);
        }

        public Container getContainer() {
            return this.host;
        }

        public ViewFactory getViewFactory() {
            return this.factory;
        }
    }

    static class BasicDocument
    extends DefaultStyledDocument {
        BasicDocument(Font defaultFont, Color foreground) {
            this.setFontAndColor(defaultFont, foreground);
        }

        private void setFontAndColor(Font font, Color fg) {
            SimpleAttributeSet attr;
            if (fg != null) {
                attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, fg);
                this.getStyle("default").addAttributes(attr);
            }
            if (font != null) {
                attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, font.getFamily());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, font.getSize());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setBold(attr, font.isBold());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setItalic(attr, font.isItalic());
                this.getStyle("default").addAttributes(attr);
            }
            attr = new SimpleAttributeSet();
            StyleConstants.setSpaceAbove(attr, 0.0f);
            this.getStyle("default").addAttributes(attr);
        }
    }

    private static class BasicViewFactory
    implements ViewFactory {
        private BasicViewFactory() {
        }

        public View create(Element elem) {
            String kind = elem.getName();
            View view = null;
            if (kind == null) {
                view = new LabelView(elem);
            } else if (kind.equals("content")) {
                view = new LabelView(elem);
            } else if (kind.equals("paragraph")) {
                view = new ParagraphView(elem);
            } else if (kind.equals("section")) {
                view = new BoxView(elem, 1);
            } else if (kind.equals("component")) {
                view = new ComponentView(elem);
            } else if (kind.equals("icon")) {
                view = new IconView(elem);
            }
            return view;
        }
    }

    private static class MultiLineSupport
    implements PropertyChangeListener {
        private static final String HTML = "<html>";
        private static ViewFactory basicViewFactory;
        private static BasicEditorKit basicFactory;

        private MultiLineSupport() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            JXLabel src = (JXLabel)evt.getSource();
            if (src.isLineWrap()) {
                if ("font".equals(name) || "foreground".equals(name)) {
                    MultiLineSupport.updateRenderer(src);
                } else if ("text".equals(name)) {
                    if (MultiLineSupport.isHTML((String)evt.getOldValue()) && evt.getNewValue() != null && !MultiLineSupport.isHTML((String)evt.getNewValue())) {
                        if (src.getClientProperty(JXLabel.oldRendererKey) == null && src.getClientProperty("html") != null) {
                            src.putClientProperty(JXLabel.oldRendererKey, src.getClientProperty("html"));
                        }
                        src.putClientProperty("html", MultiLineSupport.createView(src));
                    } else if (!MultiLineSupport.isHTML((String)evt.getOldValue()) && evt.getNewValue() != null && !MultiLineSupport.isHTML((String)evt.getNewValue())) {
                        MultiLineSupport.updateRenderer(src);
                    } else {
                        MultiLineSupport.restoreHtmlRenderer(src);
                    }
                } else if ("lineWrap".equals(name) && !MultiLineSupport.isHTML(src.getText())) {
                    src.putClientProperty("html", MultiLineSupport.createView(src));
                }
            } else if ("lineWrap".equals(name)) {
                MultiLineSupport.restoreHtmlRenderer(src);
            }
        }

        private static void restoreHtmlRenderer(JXLabel src) {
            Object current = src.getClientProperty("html");
            if (current == null || current instanceof Renderer) {
                src.putClientProperty("html", src.getClientProperty(JXLabel.oldRendererKey));
            }
        }

        private static boolean isHTML(String s) {
            return s != null && s.toLowerCase().startsWith(HTML);
        }

        private static View createView(JXLabel c) {
            BasicEditorKit kit = MultiLineSupport.getFactory();
            Document doc = kit.createDefaultDocument(c.getFont(), c.getForeground());
            StringReader r = new StringReader(c.getText());
            try {
                kit.read(r, doc, 0);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ViewFactory f = kit.getViewFactory();
            View hview = f.create(doc.getDefaultRootElement());
            Renderer v = new Renderer(c, f, hview, true);
            return v;
        }

        public static void updateRenderer(JXLabel c) {
            View value = null;
            View oldValue = (View)c.getClientProperty("html");
            if (oldValue == null || oldValue instanceof Renderer) {
                value = MultiLineSupport.createView(c);
            }
            if (value != oldValue && oldValue != null) {
                for (int i = 0; i < oldValue.getViewCount(); ++i) {
                    oldValue.getView(i).setParent(null);
                }
            }
            c.putClientProperty("html", value);
        }

        private static BasicEditorKit getFactory() {
            if (basicFactory == null) {
                basicViewFactory = new BasicViewFactory();
                basicFactory = new BasicEditorKit();
            }
            return basicFactory;
        }

        private static class BasicEditorKit
        extends StyledEditorKit {
            private BasicEditorKit() {
            }

            public Document createDefaultDocument(Font defaultFont, Color foreground) {
                BasicDocument doc = new BasicDocument(defaultFont, foreground);
                doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                return doc;
            }

            public ViewFactory getViewFactory() {
                return basicViewFactory;
            }
        }
    }
}

